/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.dynamictablecolumns;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.mihalis.opal.dynamictablecolumns.DynamicColumnData;
import org.mihalis.opal.dynamictablecolumns.DynamicTableColumnLayout;

public class DynamicTable
extends Table {
    private Composite parent = null;
    private Composite container = null;
    private Menu headerMenu = null;
    private DynamicTableColumnLayout dynamicLayout = null;

    public DynamicTable(Composite composite, int n) {
        super(new Composite(composite, 0){

            public void reskin(int n) {
                super.reskin(n);
            }
        }, n);
        this.parent = composite;
        this.container = super.getParent();
        this.dynamicLayout = new DynamicTableColumnLayout(){

            @Override
            public void setColumnData(DynamicColumnData dynamicColumnData) {
                super.setColumnData(dynamicColumnData);
                DynamicTable.this.createMenuItem(DynamicTable.this.headerMenu, dynamicColumnData);
            }
        };
        this.container.setLayout((Layout)this.dynamicLayout);
        this.headerMenu = new Menu((Decorations)this.container.getShell(), 8);
        this.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                DynamicTable.this.setMenu(DynamicTable.this.isMouseOverHeader(event.x, event.y) ? DynamicTable.this.headerMenu : null);
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DynamicTable.this.headerMenu.dispose();
            }
        });
    }

    protected boolean isMouseOverHeader(int n, int n2) {
        Point point = Display.getDefault().map(null, (Control)this, new Point(n, n2));
        Rectangle rectangle = this.getClientArea();
        return rectangle.y <= point.y && point.y < rectangle.y + this.getHeaderHeight();
    }

    private void createMenuItem(Menu menu, final DynamicColumnData dynamicColumnData) {
        final TableColumn tableColumn = dynamicColumnData.getTableColumn();
        final MenuItem menuItem = new MenuItem(menu, 32);
        menuItem.setText(tableColumn.getText());
        menuItem.setSelection(tableColumn.getResizable());
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean bl = menuItem.getSelection();
                dynamicColumnData.setVisible(bl);
                tableColumn.setResizable(bl);
                DynamicTable.this.layout();
            }
        });
    }

    public DynamicTableColumnLayout getLayout() {
        return (DynamicTableColumnLayout)this.container.getLayout();
    }

    public void setLayout(Layout layout) {
        throw new IllegalStateException();
    }

    public void setLayoutData(Object object) {
        this.container.setLayoutData(object);
    }

    public void layout() {
        this.container.layout();
    }

    public Composite getParent() {
        return this.parent;
    }

    protected void checkSubclass() {
    }
}

