/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.flatButton.FlatButton;
import org.mihalis.opal.preferenceWindow.PWTab;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.utils.SWTGraphicUtil;

class PWTabContainer
extends Composite {
    private final List<PWTab> tabs = new ArrayList<PWTab>();
    private Composite container;
    private Image oldButtonContainerImage;
    private final List<FlatButton> buttons;
    private Composite buttonContainer;

    PWTabContainer(Composite composite, int n, List<PWTab> list) {
        super(composite, n);
        this.tabs.addAll(list);
        this.buttons = new ArrayList<FlatButton>();
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
    }

    void build() {
        this.createButtonsContainer();
        this.createButtons();
        this.createContentContainer();
        this.select(PreferenceWindow.getInstance().getSelectedTab());
    }

    private void createButtonsContainer() {
        this.createContainer();
        this.createButtonsContainerBackground();
    }

    private void createContainer() {
        this.buttonContainer = new Composite((Composite)this, 0);
        GridData gridData = new GridData(4, 4, true, false, 2, 1);
        gridData.heightHint = 63;
        this.buttonContainer.setLayoutData((Object)gridData);
        this.buttonContainer.setBackground(this.getDisplay().getSystemColor(1));
        GridLayout gridLayout = new GridLayout(this.tabs.size(), false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 2;
        this.buttonContainer.setLayout((Layout)gridLayout);
    }

    private void createButtonsContainerBackground() {
        this.buttonContainer.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = PWTabContainer.this.buttonContainer.getClientArea();
                Image image = new Image((Device)PWTabContainer.this.getDisplay(), Math.max(1, rectangle.width), Math.max(1, rectangle.height));
                GC gC = new GC((Drawable)image);
                Color color = new Color((Device)PWTabContainer.this.getDisplay(), 204, 204, 204);
                gC.setForeground(color);
                gC.drawLine(0, rectangle.height - 1, rectangle.width, rectangle.height - 1);
                color.dispose();
                gC.dispose();
                PWTabContainer.this.buttonContainer.setBackgroundImage(image);
                if (PWTabContainer.this.oldButtonContainerImage != null) {
                    PWTabContainer.this.oldButtonContainerImage.dispose();
                }
                PWTabContainer.this.oldButtonContainerImage = image;
            }
        });
        SWTGraphicUtil.addDisposer((Widget)this.buttonContainer, (Resource)this.oldButtonContainerImage);
    }

    private void createButtons() {
        int n = 0;
        while (n < this.tabs.size()) {
            PWTab pWTab = this.tabs.get(n);
            FlatButton flatButton = new FlatButton(this.buttonContainer, 0);
            flatButton.setText(pWTab.getText());
            flatButton.setImage(pWTab.getImage());
            GridData gridData = n == this.tabs.size() - 1 ? new GridData(1, 1, true, false) : new GridData(1, 1, false, false);
            if (n == 0) {
                gridData.horizontalIndent = 5;
            }
            gridData.widthHint = 75;
            flatButton.setLayoutData(gridData);
            final int n2 = n++;
            flatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PWTabContainer.this.select(n2);
                }
            });
            this.buttons.add(flatButton);
        }
    }

    void select(int n) {
        for (Control control : this.container.getChildren()) {
            control.dispose();
        }
        this.tabs.get(n).build(this.container);
        this.container.layout();
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).setSelection(i == n);
        }
    }

    private void createContentContainer() {
        this.container = new Composite((Composite)this, 0);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.widthHint = 700;
        gridData.heightHint = 550;
        this.container.setLayoutData((Object)gridData);
    }
}

