/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.propertyTable.editor;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.PTWidget;
import org.mihalis.opal.propertyTable.editor.PTChooserEditor;
import org.mihalis.opal.utils.ResourceManager;

public class PTFontEditor
extends PTChooserEditor {
    @Override
    protected void openWindow(PTWidget pTWidget, Item item, PTProperty pTProperty) {
        FontDialog fontDialog = new FontDialog(pTWidget.getWidget().getShell());
        FontData fontData = fontDialog.open();
        if (fontData != null && fontData.getName() != null && !"".equals(fontData.getName().trim())) {
            pTProperty.setValue(fontData);
            if (item instanceof TableItem) {
                ((TableItem)item).setText(1, this.getTextFor(pTProperty));
            } else {
                ((TreeItem)item).setText(1, this.getTextFor(pTProperty));
            }
        }
    }

    @Override
    protected String getTextFor(PTProperty pTProperty) {
        if (pTProperty.getValue() == null) {
            return "";
        }
        FontData fontData = (FontData)pTProperty.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        if (fontData != null) {
            stringBuilder.append(fontData.getName()).append(",").append(fontData.getHeight()).append(" pt");
            if ((fontData.getStyle() & 1) == 1) {
                stringBuilder.append(", ").append(ResourceManager.getLabel("bold"));
            }
            if ((fontData.getStyle() & 2) == 2) {
                stringBuilder.append(", ").append(ResourceManager.getLabel("italic"));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected Color getBackgroundColor(PTProperty pTProperty) {
        return null;
    }
}

