/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.starRating;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.starRating.Star;

public class StarRating
extends Canvas {
    private static final int SIZE_SMALL = 16;
    private static final int SIZE_BIG = 32;
    private SIZE sizeOfStars = SIZE.SMALL;
    private int maxNumberOfStars;
    private int currentNumberOfStars = 0;
    private static final int DEFAULT_MAX_NUMBERS_OF_STARS = 5;
    private final List<Star> stars;
    private int orientation;
    private final List<SelectionListener> selectionListeners;

    public StarRating(Composite composite, int n) {
        super(composite, StarRating.checkStyle(n) | 0x20000000);
        this.orientation = (n & 0x200) != 0 ? 512 : 256;
        this.stars = new ArrayList<Star>();
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.setMaxNumberOfStars(5);
        this.initListeners();
    }

    private static int checkStyle(int n) {
        if ((n & 0x200) != 0) {
            n &= 0xFFFFFDFF;
        }
        if ((n & 0x100) != 0) {
            n &= 0xFFFFFEFF;
        }
        return n;
    }

    private void initListeners() {
        int[] nArray;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: 
                    case 6: {
                        StarRating.this.onMouseEnterOrMove(event);
                        break;
                    }
                    case 7: {
                        StarRating.this.onMouseExit(event);
                        break;
                    }
                    case 4: {
                        StarRating.this.onMouseUp(event);
                        break;
                    }
                    case 9: {
                        StarRating.this.onMousePaint(event);
                        break;
                    }
                    case 12: {
                        StarRating.this.onDispose(event);
                    }
                }
            }
        };
        for (int n : nArray = new int[]{6, 5, 7, 4, 9, 12}) {
            this.addListener(n, listener);
        }
    }

    private void onMouseEnterOrMove(Event event) {
        for (Star star : this.stars) {
            star.hover = false;
        }
        for (Star star : this.stars) {
            boolean bl = star.bounds.contains(event.x, event.y);
            star.hover = true;
            if (!bl) continue;
            break;
        }
        this.redraw();
        this.update();
    }

    private void onMouseExit(Event event) {
        for (Star star : this.stars) {
            star.hover = false;
        }
        this.redraw();
        this.update();
    }

    private void onMouseUp(Event event) {
        for (int i = 0; i < this.maxNumberOfStars; ++i) {
            Star star = this.stars.get(i);
            boolean bl = star.bounds.contains(event.x, event.y);
            if (!bl) continue;
            this.setCurrentNumberOfStars(i + 1);
            this.fireSelectionEvent();
            this.redraw();
            this.update();
            break;
        }
    }

    private void fireSelectionEvent() {
        Event event = new Event();
        event.widget = this;
        event.display = this.getDisplay();
        event.item = this;
        event.type = 13;
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    private void onMousePaint(Event event) {
        GC gC = event.gc;
        int n = 0;
        int n2 = 0;
        for (Star star : this.stars) {
            star.draw(gC, n, n2);
            if (this.orientation == 512) {
                n2 += this.sizeOfStars.equals((Object)SIZE.BIG) ? 32 : 16;
                continue;
            }
            n += this.sizeOfStars.equals((Object)SIZE.BIG) ? 32 : 16;
        }
    }

    private void onDispose(Event event) {
        for (Star star : this.stars) {
            star.dispose();
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(selectionListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        if (this.orientation == 512) {
            return this.computeSizeVertical();
        }
        return this.computeSizeHorizontal();
    }

    private Point computeSizeVertical() {
        int n = this.sizeOfStars.equals((Object)SIZE.BIG) ? 32 : 16;
        int n2 = this.maxNumberOfStars * n;
        return new Point(n + this.getBorderWidth() * 2, n2 + this.getBorderWidth() * 2);
    }

    private Point computeSizeHorizontal() {
        int n = this.sizeOfStars.equals((Object)SIZE.BIG) ? 32 : 16;
        int n2 = this.maxNumberOfStars * n;
        return new Point(n2 + this.getBorderWidth() * 2, n + this.getBorderWidth() * 2);
    }

    public int getCurrentNumberOfStars() {
        this.checkWidget();
        return this.currentNumberOfStars;
    }

    public int getMaxNumberOfStars() {
        this.checkWidget();
        return this.maxNumberOfStars;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.orientation;
    }

    public SIZE getSizeOfStars() {
        this.checkWidget();
        return this.sizeOfStars;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(selectionListener);
    }

    public void setCurrentNumberOfStars(int n) {
        this.checkWidget();
        if (n < 0 || n > this.maxNumberOfStars) {
            SWT.error((int)5);
        }
        this.currentNumberOfStars = n;
        for (Star star : this.stars) {
            star.marked = false;
        }
        for (int i = 0; i < n; ++i) {
            this.stars.get((int)i).marked = true;
        }
    }

    public void setMaxNumberOfStars(int n) {
        this.maxNumberOfStars = n;
        this.reinitStars();
    }

    private void reinitStars() {
        for (Star star : this.stars) {
            star.dispose();
        }
        this.stars.clear();
        for (int i = 0; i < this.maxNumberOfStars; ++i) {
            if (this.sizeOfStars.equals((Object)SIZE.BIG)) {
                this.stars.add(Star.initBig(this));
                continue;
            }
            this.stars.add(Star.initSmall(this));
        }
    }

    public void setSizeOfStars(SIZE sIZE) {
        this.checkWidget();
        this.sizeOfStars = sIZE;
        this.reinitStars();
    }

    public static enum SIZE {
        SMALL,
        BIG;

    }
}

