/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors;

import java.awt.Menu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.domain.Card;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.utils.JaxbUtil;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.view.XMLFileDialog;

public class ExportDialog
extends TitleAreaDialog {
    private static final Logger log = LoggerFactory.getLogger(ExportDialog.class);
    private Map<String, Class> classesMap;
    private Map<String, Button> exportButtons = new HashMap<String, Button>();

    public ExportDialog() {
        super(Display.getCurrent().getActiveShell());
        this.classesMap = Directory.exportClasesMap;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        this.setMessage("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f", 1);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        Group group = new Group(container, 16);
        group.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)group);
        group.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        ArrayList<String> sortedKeys = new ArrayList<String>(this.classesMap.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            Button button = new Button((Composite)group, 32);
            button.setText(key);
            button.setSelection(true);
            button.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
            this.exportButtons.put(key, button);
        }
        Composite container1 = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().applyTo(container1);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container1);
        Button selectAll = new Button(container1, 0);
        selectAll.setText("\u0412\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0441\u0435");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDialog.this.setSelectExportButtons(true);
            }
        });
        Button deselectAll = new Button(container1, 0);
        deselectAll.setText("\u0423\u0431\u0440\u0430\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDialog.this.setSelectExportButtons(false);
            }
        });
        return area;
    }

    private void setSelectExportButtons(boolean selected) {
        for (String key : this.exportButtons.keySet()) {
            this.exportButtons.get(key).setSelection(selected);
        }
    }

    protected void okPressed() {
        String xmlFileName = new XMLFileDialog(8192).open();
        if (xmlFileName != null) {
            try {
                SessionManager.openSession(Menu.class);
                SessionManager.openSession(Card.class);
                GuiActivator.getDefault().setLoadCursor(true);
                ArrayList collection = new ArrayList();
                for (String key : this.exportButtons.keySet()) {
                    if (!this.exportButtons.get(key).getSelection()) continue;
                    collection.addAll(ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.classesMap.get(key)).getList());
                }
                DomainCollections domainCollections = new DomainCollections(collection);
                JaxbUtil.INSTANCE.exportToXML(xmlFileName, domainCollections);
                GuiActivator.getDefault().setLoadCursor(false);
                SessionManager.closeSession(Menu.class);
                SessionManager.closeSession(Card.class);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

