/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.validator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.validator.JSR303Validator;

public class JSR303ValidatorMulti<T>
extends MultiValidator {
    private static final Logger log = LoggerFactory.getLogger(JSR303Validator.class);
    private final T bean;
    private final String propertyName1;
    private final String propertyName2;
    private final IObservableValue observe1;
    private final IObservableValue observe2;
    private Validator validator;
    private final Button check1;
    private final Button check2;
    private final Label statusControl;
    private static ValidatorFactory validatorFactory;
    private final PropertyChangeListener changeListener;

    public static void setValidatorFactory(ValidatorFactory factory) {
        validatorFactory = factory;
    }

    public JSR303ValidatorMulti(T bean, String propertyName1, String propertyName2, IObservableValue observe1, IObservableValue observe2, PropertyChangeListener listener, Label statusControl, Button check1, Button check2) {
        this.bean = bean;
        this.propertyName1 = propertyName1;
        this.propertyName2 = propertyName2;
        this.observe1 = observe1;
        this.observe2 = observe2;
        this.statusControl = statusControl;
        this.check1 = check1;
        this.check2 = check2;
        this.changeListener = listener;
        this.initValidator();
    }

    private void initValidator() {
        if (validatorFactory == null) {
            try {
                validatorFactory = GuiActivator.getDefault().getBeanByClass(ValidatorFactory.class);
            }
            catch (Exception e) {
                throw new ValidationException("ValidationFactory not set and unable to initialize validation from default values", (Throwable)e);
            }
        }
        this.validator = validatorFactory.getValidator();
    }

    public IStatus validate() {
        boolean isValid1 = true;
        IStatus ret = null;
        Comparable value1 = null;
        Comparable value2 = null;
        try {
            String message;
            value1 = (Comparable)this.observe1.getValue();
            value2 = (Comparable)this.observe2.getValue();
            Set validationResult1 = this.validator.validateValue(this.bean.getClass(), this.propertyName1, (Object)value1, new Class[]{Default.class});
            Set validationResult2 = this.validator.validateValue(this.bean.getClass(), this.propertyName2, (Object)value2, new Class[]{Default.class});
            if (!validationResult1.isEmpty()) {
                message = this.assembleErrorMessage(validationResult1);
                this.statusControl.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                this.statusControl.setToolTipText(message);
                ret = ValidationStatus.error((String)message);
                isValid1 = false;
            } else {
                this.statusControl.setImage(null);
                this.statusControl.setToolTipText("");
                ret = ValidationStatus.ok();
            }
            if (!validationResult2.isEmpty()) {
                message = this.assembleErrorMessage(validationResult1);
                this.statusControl.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                this.statusControl.setToolTipText(message);
                ret = ValidationStatus.error((String)message);
                isValid1 = false;
            } else {
                this.statusControl.setImage(null);
                this.statusControl.setToolTipText("");
                ret = ValidationStatus.ok();
            }
            if (value1 != null && value2 != null) {
                message = "\u041f\u0435\u0440\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u0432\u0442\u043e\u0440\u043e\u0435";
                if (value1.compareTo(value2) > 0) {
                    ret = ValidationStatus.error((String)message);
                    this.statusControl.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                    this.statusControl.setToolTipText(message);
                    ret = ValidationStatus.error((String)message);
                    isValid1 = false;
                } else {
                    this.statusControl.setImage(null);
                    this.statusControl.setToolTipText("");
                    ret = ValidationStatus.ok();
                }
            }
        }
        catch (Exception e) {
            log.trace(e.getMessage());
        }
        if (!this.check1.getSelection() || !this.check2.getSelection()) {
            this.statusControl.setImage(null);
            this.statusControl.setToolTipText("");
            ret = ValidationStatus.ok();
            isValid1 = true;
        }
        this.notifyListener(value1, isValid1);
        this.notifyListener(value2, isValid1);
        return ret;
    }

    private void notifyListener(Object value, Boolean isValid) {
        this.changeListener.propertyChange(new PropertyChangeEvent(this.bean, this.propertyName1, null, isValid));
        this.changeListener.propertyChange(new PropertyChangeEvent(this.bean, this.propertyName2, null, isValid));
    }

    private String assembleErrorMessage(Set<?> validationResult) {
        String message = "";
        Iterator<?> iterator = validationResult.iterator();
        while (iterator.hasNext()) {
            ConstraintViolation violation = (ConstraintViolation)iterator.next();
            message = String.valueOf(message) + violation.getMessage();
            if (!iterator.hasNext()) continue;
            message = String.valueOf(message) + System.getProperty("line.separator");
        }
        return message;
    }
}

