/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashregistry.mock;

import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class SQLiteDBCreator {
    private static final Logger log = LoggerFactory.getLogger(SQLiteDBCreator.class);
    private static DataSource dataSource;

    public static void createDatabase() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        String createSecurityObjectTable = "CREATE TABLE IF NOT EXISTS `securityObject` (`id` TEXT NOT NULL UNIQUE, `title` TEXT, `parentId` TEXT, PRIMARY KEY(id));";
        jdbcTemplate.execute(createSecurityObjectTable);
        String createSecurityRoleTable = "CREATE TABLE IF NOT EXISTS `securityRole` ( `id` TEXT NOT NULL UNIQUE, PRIMARY KEY(id));";
        jdbcTemplate.execute(createSecurityRoleTable);
        String createSecurityPermissionTable = "CREATE TABLE IF NOT EXISTS `securityPermission` ( `id` INTEGER NOT NULL UNIQUE, `permission` INTEGER, `securityObjectId` TEXT, PRIMARY KEY(id));";
        jdbcTemplate.execute(createSecurityPermissionTable);
        String createSecurityRolePermissionsTable = "CREATE TABLE IF NOT EXISTS `securityRolePermissions` ( `securityRoleId` TEXT NOT NULL, `securityPermissionId` INTEGER NOT NULL);";
        jdbcTemplate.execute(createSecurityRolePermissionsTable);
        String createWebUserTable = "CREATE TABLE IF NOT EXISTS `webUser` ( `id` TEXT NOT NULL UNIQUE, `password` TEXT NOT NULL, PRIMARY KEY(id));";
        jdbcTemplate.execute(createWebUserTable);
        String createWebUserRolesTable = "CREATE TABLE IF NOT EXISTS `webUserRoles` ( `webUserId` TEXT NOT NULL, `securityRoleId` TEXT NOT NULL, PRIMARY KEY(webUserId, securityRoleId));";
        jdbcTemplate.execute(createWebUserRolesTable);
        String insertDefaultUser = "INSERT INTO `webUser` ( `id`, `password` ) VALUES ('admin', 'admin');";
        try {
            jdbcTemplate.execute(insertDefaultUser);
        }
        catch (Exception exception) {
            log.info("WebUser admin already exist.");
        }
    }

    public void setDataSource(DataSource dataSource) {
        SQLiteDBCreator.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return dataSource;
    }
}

