/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.ShopInfo;

public class ShopsRestClient {
    private static final String SHOP_URL = "shops";
    private final RestInvokerManager restInvokerManager;

    public ShopsRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public Long countShops() {
        return this.restInvokerManager.getRestInvoker().invokeGet("shops/count", Long.class);
    }

    public Boolean existsShops(String shopCode) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shops/{0}/exists", shopCode), Boolean.class);
    }

    public List<ShopInfo> getShopInfosList() {
        ParameterizedTypeReference<List<ShopInfo>> returnTypeRef = new ParameterizedTypeReference<List<ShopInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(SHOP_URL, returnTypeRef);
    }

    public List<ShopInfo> getRootShops() {
        ParameterizedTypeReference<List<ShopInfo>> returnTypeRef = new ParameterizedTypeReference<List<ShopInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("shops?rootShops=true", returnTypeRef);
    }

    public List<ShopInfo> getShopsByGroupCode(String groupId) {
        ParameterizedTypeReference<List<ShopInfo>> returnTypeRef = new ParameterizedTypeReference<List<ShopInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shops?groupId={0}", groupId), returnTypeRef);
    }

    public List<ShopInfo> getShopsByTagId(String tagId) {
        ParameterizedTypeReference<List<ShopInfo>> returnTypeRef = new ParameterizedTypeReference<List<ShopInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shops?tagId={0}", tagId), returnTypeRef);
    }

    public List<ShopInfo> getShopsByCategory(String categoryId) {
        ParameterizedTypeReference<List<ShopInfo>> returnTypeRef = new ParameterizedTypeReference<List<ShopInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shops?categoryId={0}", categoryId), returnTypeRef);
    }

    public ShopInfo getShop(String shopId) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shops/{0}", shopId), ShopInfo.class);
    }
}

