/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import ru.ssa.artixadmin.ApplicationActionBarAdvisor;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.artixadmin.StatusHelper;
import ru.ssa.artixadmin.view.CashTreeActivity;
import ru.ssa.artixadmin.view.CashTreeCS2Activity;
import ru.ssa.artixadmin.view.DBVersionViewActivity;
import ru.ssa.artixadmin.view.ViewActivity;
import ru.ssa.cashadmin.domain.Connect;
import su.artix.yuki.images.ArtixAdminImages;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private ApplicationActionBarAdvisor actionBarAdvisor;
    private IStatusLineManager statusLine;

    public IStatusLineManager getStatusLine() {
        return this.statusLine;
    }

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        this.actionBarAdvisor = new ApplicationActionBarAdvisor(configurer);
        this.statusLine = this.getWindowConfigurer().getActionBarConfigurer().getStatusLineManager();
        return this.actionBarAdvisor;
    }

    public void preWindowOpen() {
        PlatformUI.getPreferenceStore().putValue("initialFastViewBarLocation", "left");
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(false);
        configurer.setShowFastViewBars(false);
        configurer.setShowMenuBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowProgressIndicator(true);
        configurer.setInitialSize(new Point(1200, 768));
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        Connect connect = ArtixAdminActivator.getDefault().getCurrentConnect();
        if (!StringUtils.isEmpty((String)connect.getStoreId())) {
            CashTreeActivity.INSTANCE.cashTreeActivate();
            CashTreeCS2Activity.INSTANCE.cashTreeActivate();
            DBVersionViewActivity.INSTANCE.activate(true);
            ViewActivity.INSTANCE.activate(true);
            CashTreeActivity.INSTANCE.addCashTreeListener(connect);
        } else {
            ViewActivity.INSTANCE.activate(false);
            CashTreeActivity.INSTANCE.cashTreeDeActivate();
            DBVersionViewActivity.INSTANCE.activate(false);
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().resetPerspective();
        StatusHelper.setArtixAdminStatus(ArtixAdminImages.getDefault().getImage("plane/24x24/connect"), "\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e: " + connect.getName() + " (IP " + (connect.isMysqlServerSplitConnect() ? connect.getMysqlServerHost() : connect.getAddress()) + ":" + connect.getPort() + ")");
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        pm.remove("org.eclipse.debug.ui.DebugPreferencePage");
        pm.remove("org.eclipse.equinox.internal.p2.ui.sdk.ProvisioningPreferencePage");
        pm.remove("eclipse.help.ui.browsersPreferencePage");
        pm.remove("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage");
        pm.remove("org.eclipse.team.ui.TeamPreferences");
        pm.remove("org.eclipse.ui.preferencePages.Workbench");
    }
}

