/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.goods;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.view.directory.goods.TmcKitItemViewPanel;
import ru.ssa.artixadmin.view.directory.goods.TmcKitTableView;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.TmcKit;
import ru.ssa.cashadmin.domain.TmcKitItem;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438. \u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0442\u044b. \u0422\u043e\u0432\u0430\u0440\u044b \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442\u0430")
public class TmcKitItemTableView
extends DirectoryTableView<TmcKitItem> {
    public static final String ID = "ru.ssa.artixadmin.view.directory.TmcKitItemTableView";
    private static final Logger log = LoggerFactory.getLogger(TmcKitItemTableView.class);
    private TmcKit currentSelected;

    public void createPartControl(Composite parent) {
        this.setPojoClass(TmcKitItem.class);
        this.setViewPanel((DirectoryViewPanel)new TmcKitItemViewPanel(parent, 0, false));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        LazyContentProvider lazyContentProvider = new LazyContentProvider(TmcKitItem.class, (TableViewer)this.getViewer());
        lazyContentProvider.setSortProperty("tmccode");
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)lazyContentProvider);
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns()));
        this.commonActionGroup = new DirectoryEditActionGroup(TmcKitItem.class).removeAction(new String[]{"ru.ssa.artixadmin.action.DirectoryCopyAction"});
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.commonActionGroup.getAddAction().setEnabled(false);
        super.createPartControl(parent);
        this.restoreState();
    }

    protected String getID() {
        return ID;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
        IStructuredSelection selection = (IStructuredSelection)selectionIn;
        if (part instanceof TmcKitTableView) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof TmcKit) {
                TmcKit selected = (TmcKit)selection.getFirstElement();
                if (this.currentSelected != null && StringUtils.equals((String)this.currentSelected.getBarcode(), (String)selected.getBarcode())) {
                    this.getViewPanel().setInput(null);
                    this.commonActionGroup.getAddAction().setEnabled(false);
                    this.currentSelected = null;
                } else {
                    this.currentSelected = selected;
                    TmcKitItem addmodel = (TmcKitItem)LibActivator.getDefault().getActualClassResolver().getInstance(TmcKitItem.class);
                    addmodel.setTmcKit(selected);
                    this.commonActionGroup.getAddAction().setModel((Object)addmodel);
                    this.commonActionGroup.getAddAction().setEnabled(true);
                    this.getViewPanel().setInput((Object)addmodel);
                }
            } else {
                this.commonActionGroup.getAddAction().setEnabled(false);
            }
        }
    }

    protected boolean isMaster() {
        return false;
    }
}

