/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.formattedtext;

import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractFormatter
implements ITextFormatter {
    protected static final char SPACE = ' ';
    protected static final String EMPTY = "";
    protected Text text;
    protected boolean ignore;

    protected void beep() {
        if (this.text != null) {
            this.text.getDisplay().beep();
        }
    }

    public void detach() {
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setText(Text text) {
        if (text == null) {
            SWT.error((int)4);
        }
        this.text = text;
    }

    protected void updateText(String t) {
        if (this.text != null) {
            this.updateText(t, this.text.getCaretPosition());
        }
    }

    protected void updateText(String t, int pos) {
        if (this.text != null) {
            String oldText = this.text.getText();
            this.ignore = true;
            if (!oldText.equals(t)) {
                this.text.setText(t);
            }
            this.text.setSelection(pos);
            this.ignore = false;
        }
    }
}

