/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import org.eclipse.nebula.widgets.ganttchart.IColorManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class GanttToolTip {
    private static boolean _codeHoverBelow = false;
    private static Shell _shell;
    private static String _lastText;
    private static Point _lastLocation;

    GanttToolTip() {
    }

    public static void makeDialog(IColorManager colorManager, String name, String text, Point location) {
        GanttToolTip.internalMakeDialog(colorManager, name, text, null, null, null, location);
    }

    public static void makeDialog(IColorManager colorManager, String name, String text, String text2, Point location) {
        GanttToolTip.internalMakeDialog(colorManager, name, text, text2, null, null, location);
    }

    public static void makeDialog(IColorManager colorManager, String name, String text, String text2, String text3, Point location) {
        GanttToolTip.internalMakeDialog(colorManager, name, text, text2, text3, null, location);
    }

    public static void makeDialog(IColorManager colorManager, String name, String text, String text2, String text3, String text4, Point location) {
        GanttToolTip.internalMakeDialog(colorManager, name, text, text2, text3, text4, location);
    }

    private static void internalMakeDialog(IColorManager colorManager, String name, String text, String text2, String text3, String text4, Point loc) {
        Point location = new Point(loc.x, loc.y);
        if (_shell != null && !_shell.isDisposed()) {
            if (!_codeHoverBelow) {
                location = new Point(location.x, location.y - GanttToolTip._shell.getSize().y - 20);
            }
            if (_lastText != null && _lastText.equals(text) && _lastLocation != null && _lastLocation.equals((Object)location)) {
                return;
            }
            _shell.dispose();
        }
        _lastText = text;
        _shell = new Shell(Display.getDefault().getActiveShell(), 16388);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginLeft = 1;
        rowLayout.marginRight = 1;
        rowLayout.marginTop = 1;
        rowLayout.marginBottom = 1;
        _shell.setLayout((Layout)rowLayout);
        _shell.setBackground(colorManager.getTooltipBackgroundColor());
        Composite comp = new Composite((Composite)_shell, 0);
        comp.setBackground(colorManager.getTooltipBackgroundColor());
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        comp.setLayout((Layout)fillLayout);
        CLabel label = new CLabel(comp, 16384);
        label.setBackground(colorManager.getTooltipBackgroundColor());
        label.setForeground(colorManager.getTooltipForegroundColor());
        label.setText(name);
        Font cur = label.getFont();
        cur = GanttToolTip.applyBoldFont(cur);
        label.setFont(cur);
        CLabel textLabel = new CLabel(comp, 16384);
        textLabel.setBackground(colorManager.getTooltipBackgroundColor());
        if (text4 != null) {
            textLabel.setForeground(colorManager.getTooltipForegroundColorFaded());
        }
        textLabel.setText(text);
        if (text2 != null) {
            CLabel text2Label = new CLabel(comp, 16384);
            text2Label.setBackground(colorManager.getTooltipBackgroundColor());
            text2Label.setForeground(colorManager.getTooltipForegroundColorFaded());
            text2Label.setText(text2);
        }
        if (text3 != null) {
            CLabel text3Label = new CLabel(comp, 16384);
            text3Label.setBackground(colorManager.getTooltipBackgroundColor());
            text3Label.setForeground(colorManager.getTooltipForegroundColorFaded());
            text3Label.setText(text3);
        }
        if (text4 != null) {
            CLabel text4Label = new CLabel(comp, 16384);
            text4Label.setBackground(colorManager.getTooltipBackgroundColor());
            text4Label.setForeground(colorManager.getTooltipForegroundColorFaded());
            text4Label.setText(text4);
        }
        _shell.pack();
        if (!_codeHoverBelow) {
            location = new Point(location.x, location.y - GanttToolTip._shell.getSize().y - 10);
        }
        _shell.setLocation(location);
        _lastLocation = location;
        _shell.setVisible(true);
    }

    private static Font applyBoldFont(Font font) {
        if (font == null) {
            return null;
        }
        FontData[] fontDataArray = font.getFontData();
        if (fontDataArray == null) {
            return null;
        }
        for (int index = 0; index < fontDataArray.length; ++index) {
            FontData fData = fontDataArray[index];
            fData.setStyle(1);
        }
        return new Font((Device)Display.getDefault(), fontDataArray);
    }

    public static void kill() {
        if (_shell != null && !_shell.isDisposed()) {
            _shell.dispose();
        }
    }

    public static boolean isActive() {
        return _shell != null && !_shell.isDisposed();
    }
}

