/*
 * Decompiled with CFR 0.152.
 */
package su.artix.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class TextWithClear
extends Composite {
    public static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    public static final String DISABLED_CLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private Control clearControl;
    private String initText;
    private Text text;
    private Action clearAction;

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.gif");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/clear_co.gif")) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_CLEAR_ICON, descriptor);
        }
    }

    public TextWithClear(Composite parent) {
        this(parent, null);
    }

    public TextWithClear(Composite parent, int style) {
        this(parent, style, null);
    }

    public TextWithClear(Composite parent, String initText) {
        this(parent, 2048, initText);
    }

    public TextWithClear(Composite parent, int style, String initText) {
        super(parent, style);
        this.initText = initText;
        this.init();
    }

    protected abstract Control createClearText(Composite var1, Action var2);

    protected void doSearch() {
    }

    protected Composite createMainPanel() {
        return this;
    }

    private void init() {
        Composite mainPanel = this.createMainPanel();
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(mainPanel);
        this.text = new Text(mainPanel, 4);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.text);
        this.clearControl = this.createClearText(mainPanel, new Action(){

            public void run() {
                TextWithClear.this.clearText();
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextWithClear.this.clearControl.setVisible(!TextWithClear.this.text.getText().isEmpty());
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    TextWithClear.this.doSearch();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        if (this.initText != null && !this.initText.isEmpty()) {
            this.text.setText(this.initText);
        }
        mainPanel.setBackground(this.text.getBackground());
        this.clearControl.setBackground(this.text.getBackground());
        this.clearControl.setVisible(false);
    }

    public void setEditable(boolean flag) {
        this.text.setEditable(flag);
        if (flag) {
            this.setBackground(this.text.getBackground());
            this.clearControl.setBackground(this.text.getBackground());
        } else {
            Color color = Display.getDefault().getSystemColor(22);
            this.setBackground(color);
            this.clearControl.setBackground(color);
        }
    }

    public void clearText() {
        this.text.setText("");
        if (this.clearAction != null) {
            this.clearAction.run();
        }
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void append(String text) {
        this.text.append(text);
    }

    public Text getTextField() {
        return this.text;
    }

    public Action getClearAction() {
        return this.clearAction;
    }

    public void setClearAction(Action clearAction) {
        this.clearAction = clearAction;
    }
}

