/*
 * Decompiled with CFR 0.152.
 */
package su.artix.widgets;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import su.artix.widgets.DualSelectionAdapter;

public class TextWithClearButton
extends Composite {
    private Text textField;
    private Control clearButtonControl;
    private Control selectButtonControl;
    private Control viewButtonControl;
    private Composite textComposite;
    private String initialText = "";
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String SELECT_ICON = "org.eclipse.ui.internal.dialogs.SELECT_ICON";
    private static final String DISABLED_CLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private static final String DISABLED_SELECT_ICON = "org.eclipse.ui.internal.dialogs.DSELECT_ICON";
    private static final String VIEW_ICON = "org.eclipse.ui.internal.dialogs.VIEW_ICON";
    private static final String DISABLED_VIEW_ICON = "org.eclipse.ui.internal.dialogs.DVIEW_ICON";
    private Composite parent;
    private boolean editable;
    SelectionListener listener;
    SelectionListener viewListener;

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.gif");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/clear_co.gif")) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/widgets/16x16/plane/change_item_moved.png")) != null) {
            JFaceResources.getImageRegistry().put(SELECT_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/widgets/16x16/plane/change_item.png")) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_SELECT_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/help_contents.gif")) != null) {
            JFaceResources.getImageRegistry().put(VIEW_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/help_contents.gif")) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_VIEW_ICON, descriptor);
        }
    }

    protected void init(int style) {
        this.createControl(this.parent, style);
        this.setInitialText("");
        this.setFont(this.parent.getFont());
    }

    public TextWithClearButton(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.init(style);
    }

    public TextWithClearButton(Composite parent, int style, boolean editable) {
        super(parent, style);
        this.parent = parent;
        this.editable = editable;
        this.init(style);
    }

    protected void createControl(Composite parent, int style) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.textComposite = new Composite((Composite)this, 2048);
        if (this.editable) {
            this.textComposite.setBackground(this.getDisplay().getSystemColor(25));
        } else {
            this.textComposite.setBackground(parent.getDisplay().getSystemColor(22));
        }
        GridLayout filterLayout = new GridLayout(4, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        filterLayout.horizontalSpacing = 0;
        filterLayout.verticalSpacing = 0;
        this.textComposite.setLayout((Layout)filterLayout);
        this.textComposite.setFont(parent.getFont());
        this.createTextControls(this.textComposite);
        this.textComposite.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected Composite createTextControls(Composite parent) {
        Text textField = this.createText(parent);
        this.createClearText(parent, textField);
        this.createSelectText(parent);
        this.createViewText(parent);
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(true);
        }
        return parent;
    }

    protected Text createText(Composite parent) {
        this.textField = this.doCreateText(parent);
        this.textField.setEditable(this.editable);
        if (!this.editable) {
            this.textField.setBackground(parent.getDisplay().getSystemColor(22));
        }
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextWithClearButton.this.textChanged();
            }
        });
        if ((this.textField.getStyle() & 0x100) != 0) {
            this.textField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.detail == 256) {
                        TextWithClearButton.this.clearText();
                    }
                }
            });
        }
        GridData gridData = new GridData(4, 0x1000000, true, false);
        if ((this.textField.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.textField.setLayoutData((Object)gridData);
        return this.textField;
    }

    protected Text doCreateText(Composite parent) {
        return new Text(parent, 4);
    }

    public void setInitialText(String text) {
        this.initialText = text;
        this.textField.setMessage(text);
        if (this.textField.isFocusControl()) {
            this.setText(this.initialText);
            this.textChanged();
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TextWithClearButton.this.textField.isDisposed() && TextWithClearButton.this.textField.isFocusControl()) {
                        TextWithClearButton.this.setText(TextWithClearButton.this.initialText);
                        TextWithClearButton.this.textChanged();
                    }
                }
            });
        }
    }

    private void createClearText(Composite parent, final Text textField) {
        if ((textField.getStyle() & 0x100) == 0) {
            final Image inactiveImage = JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON).createImage();
            final Image activeImage = JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON).createImage();
            final Image pressedImage = new Image((Device)this.getDisplay(), activeImage, 2);
            final Label clearButton = new Label(parent, 0);
            clearButton.setDragDetect(false);
            GridData data = new GridData(1, 0x1000000, false, false);
            clearButton.setLayoutData((Object)data);
            clearButton.setImage(inactiveImage);
            clearButton.setBackground(parent.getDisplay().getSystemColor(25));
            clearButton.setToolTipText("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
            textField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    clearButton.setImage(textField.getText().isEmpty() ? inactiveImage : activeImage);
                }
            });
            clearButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    boolean mouseInButton = this.isMouseInButton(e);
                    clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                    if (mouseInButton) {
                        TextWithClearButton.this.clearText();
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = clearButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            clearButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    inactiveImage.dispose();
                    activeImage.dispose();
                    pressedImage.dispose();
                }
            });
            clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.clearButtonControl = clearButton;
        }
    }

    private void createSelectText(Composite parent) {
        if ((this.textField.getStyle() & 0x100) == 0) {
            final Image inactiveImage = JFaceResources.getImageRegistry().getDescriptor(DISABLED_SELECT_ICON).createImage();
            final Image activeImage = JFaceResources.getImageRegistry().getDescriptor(SELECT_ICON).createImage();
            final Image pressedImage = new Image((Device)this.getDisplay(), activeImage, 2);
            final Label selectButton = new Label(parent, 0);
            GridData data = new GridData(1, 0x1000000, false, false);
            selectButton.setLayoutData((Object)data);
            selectButton.setImage(inactiveImage);
            selectButton.setBackground(parent.getDisplay().getSystemColor(25));
            selectButton.setToolTipText("\u0412\u044b\u0431\u0440\u0430\u0442\u044c");
            selectButton.setDragDetect(false);
            selectButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    boolean mouseInButton = this.isMouseInButton(e);
                    selectButton.setImage(mouseInButton ? activeImage : inactiveImage);
                    if (mouseInButton && TextWithClearButton.this.listener != null) {
                        TextWithClearButton.this.listener.widgetSelected(null);
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = selectButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            selectButton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    selectButton.setImage(activeImage);
                }

                public void mouseExit(MouseEvent e) {
                    selectButton.setImage(inactiveImage);
                }
            });
            selectButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    inactiveImage.dispose();
                    activeImage.dispose();
                    pressedImage.dispose();
                }
            });
            selectButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.selectButtonControl = selectButton;
        }
    }

    private void createViewText(Composite parent) {
        if ((this.textField.getStyle() & 0x100) == 0) {
            final Image inactiveImage = JFaceResources.getImageRegistry().getDescriptor(DISABLED_VIEW_ICON).createImage();
            final Image activeImage = JFaceResources.getImageRegistry().getDescriptor(VIEW_ICON).createImage();
            final Image pressedImage = new Image((Device)this.getDisplay(), activeImage, 2);
            final Label selectButton = new Label(parent, 0);
            GridData data = new GridData(1, 0x1000000, false, false);
            selectButton.setLayoutData((Object)data);
            selectButton.setImage(inactiveImage);
            selectButton.setBackground(parent.getDisplay().getSystemColor(25));
            selectButton.setToolTipText("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c");
            selectButton.setDragDetect(false);
            selectButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    boolean mouseInButton = this.isMouseInButton(e);
                    selectButton.setImage(mouseInButton ? activeImage : inactiveImage);
                    if (mouseInButton && TextWithClearButton.this.viewListener != null) {
                        TextWithClearButton.this.viewListener.widgetSelected(null);
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = selectButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            selectButton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    selectButton.setImage(activeImage);
                }

                public void mouseExit(MouseEvent e) {
                    selectButton.setImage(inactiveImage);
                }
            });
            selectButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    inactiveImage.dispose();
                    activeImage.dispose();
                    pressedImage.dispose();
                }
            });
            selectButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.viewButtonControl = selectButton;
        }
    }

    public void addSelectionListener(DualSelectionAdapter listener) {
        this.listener = listener;
        this.viewListener = listener.getShowDetailAdapter();
    }

    protected void setText(String string) {
        if (this.textField != null) {
            this.textField.setText(string);
            this.selectAll();
        }
    }

    protected void textChanged() {
    }

    protected void clearText() {
        this.setText("");
        this.textChanged();
        this.getClearButtonControl().setData(null);
    }

    protected void selectAll() {
        if (this.textField != null) {
            this.textField.selectAll();
        }
    }

    public Text getTextField() {
        return this.textField;
    }

    public Control getClearButtonControl() {
        return this.clearButtonControl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public Control getSelectButtonControl() {
        return this.selectButtonControl;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Control[] controlArray = this.textComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    public Control getViewButtonControl() {
        return this.viewButtonControl;
    }
}

