/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import su.artix.cashserver.core.cashregistry.domain.ShopGroupLabel;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.providers.discountsystem.TagContentProvider;
import su.artix.discountmanager.providers.discountsystem.TagLabelProvider;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.images.ArtixAdminImages;

@SecurityKey(title="\u0412\u043a\u043b\u0430\u0434\u043a\u0430 \u043c\u0435\u0442\u043e\u043a \u0443 \u0430\u043a\u0446\u0438\u0439 \u0441\u043a\u0438\u0434\u043e\u043a")
public class DiscountCampaignTagsPanel
extends EditorComposite<DiscountCampaign> {
    @SecurityKey(id="avaliableTags", title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043c\u0435\u0442\u043e\u043a")
    private Label avaliableTagsLabel;
    @SecurityKey(id="avaliableTags")
    private FilteredTree avaliableTags;
    @SecurityKey(id="selectedTags", title="\u0421\u043f\u0438\u0441\u043e\u043a \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043c\u0435\u0442\u043e\u043a")
    private Label selectedTagsLabel;
    @SecurityKey(id="selectedTags")
    private FilteredTree selectedTags;
    @SecurityKey(id="allowedTagsButton", title="\u041a\u043d\u043e\u043f\u043a\u0430 '\u0412\u044b\u0431\u0440\u0430\u043d\u044b \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043c\u0435\u0442\u043a\u0438'")
    private Button allowedTagsButton;
    @SecurityKey(id="forbiddenTagsButton", title="\u041a\u043d\u043e\u043f\u043a\u0430 '\u0412\u044b\u0431\u0440\u0430\u043d\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0435 \u043c\u0435\u0442\u043a\u0438'")
    private Button forbiddenTagsButton;
    private List<ShopLabel> currentList;

    public DiscountCampaignTagsPanel(Composite parent, int style, Class<DiscountCampaign> clazz, DiscountCampaign model, boolean isBonusDiscountSystem) {
        super(parent, style, clazz, (Object)model);
    }

    public DiscountCampaignTagsPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public DiscountCampaign getActualModel(DiscountCampaign model) {
        DiscountCampaign discountCampaign = new DiscountCampaign();
        this.currentList = new ArrayList<ShopLabel>();
        if (CollectionUtils.isNotEmpty((Collection)model.getCheckedTags())) {
            int index = 0;
            for (List tagsList : model.getCheckedTags()) {
                for (String tagId : tagsList) {
                    ShopLabel label = new ShopLabel();
                    label.setCode(tagId);
                    label.setGroup(String.valueOf(index));
                    this.currentList.add(label);
                }
                ++index;
            }
        }
        discountCampaign.setTagsIsAllowed(model.isTagsIsAllowed());
        return discountCampaign;
    }

    public void initialize() {
        this.setLayout((Layout)new GridLayout(1, false));
        final TagContentProvider avaliableTagContentProvider = new TagContentProvider(false, false);
        Composite tagsComposite = new Composite((Composite)this, 0);
        tagsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_tagsComposite = new GridLayout(3, false);
        gl_tagsComposite.marginWidth = 0;
        gl_tagsComposite.marginHeight = 0;
        tagsComposite.setLayout((Layout)gl_tagsComposite);
        Composite avaliableRowComposite = new Composite(tagsComposite, 0);
        GridLayout gl_avaliableRowComposite = new GridLayout(1, false);
        gl_avaliableRowComposite.marginWidth = 0;
        gl_avaliableRowComposite.marginHeight = 0;
        avaliableRowComposite.setLayout((Layout)gl_avaliableRowComposite);
        GridData gd_avaliableRowComposite = new GridData(4, 4, true, true, 1, 1);
        gd_avaliableRowComposite.widthHint = 200;
        avaliableRowComposite.setLayoutData((Object)gd_avaliableRowComposite);
        avaliableRowComposite.setBounds(0, 0, 64, 64);
        this.avaliableTagsLabel = new Label(avaliableRowComposite, 0);
        this.avaliableTagsLabel.setText("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043c\u0435\u0442\u043a\u0438:");
        this.avaliableTags = new FilteredTree(avaliableRowComposite, 2048, new PatternFilter(), true);
        this.avaliableTags.getViewer().setContentProvider((IContentProvider)avaliableTagContentProvider);
        this.avaliableTags.getViewer().setLabelProvider((IBaseLabelProvider)new TagLabelProvider());
        this.avaliableTags.getViewer().setInput(this.currentList);
        Tree availableTagsTree = this.avaliableTags.getViewer().getTree();
        availableTagsTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.avaliableTags.getViewer().refresh();
        Composite buttonsRowComposite = new Composite(tagsComposite, 0);
        buttonsRowComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gd_buttonsRowComposite = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_buttonsRowComposite.widthHint = 60;
        buttonsRowComposite.setLayoutData((Object)gd_buttonsRowComposite);
        buttonsRowComposite.setBounds(0, 0, 64, 64);
        final Button addToTag = new Button(buttonsRowComposite, 8);
        addToTag.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_right").createImage());
        addToTag.setToolTipText("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043f\u0440\u0430\u0432\u043e");
        addToTag.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)addToTag);
        final Button delToTag = new Button(buttonsRowComposite, 8);
        delToTag.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_left").createImage());
        delToTag.setToolTipText("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043b\u0435\u0432\u043e");
        delToTag.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)delToTag);
        final Button addAllToTag = new Button(buttonsRowComposite, 8);
        addAllToTag.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        addAllToTag.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_right2").createImage());
        addAllToTag.setToolTipText("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0441\u0435 \u0432\u043f\u0440\u0430\u0432\u043e");
        addAllToTag.setEnabled(this.avaliableTags.getViewer().getTree().getItemCount() != 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)addAllToTag);
        final Button delAllToTag = new Button(buttonsRowComposite, 8);
        delAllToTag.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        delAllToTag.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/navigate_left2").createImage());
        delAllToTag.setToolTipText("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0441\u0435 \u0432\u043b\u0435\u0432\u043e");
        delAllToTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiscountCampaignTagsPanel.this.currentList.clear();
                DiscountCampaignTagsPanel.this.avaliableTags.getViewer().refresh();
                DiscountCampaignTagsPanel.this.selectedTags.getViewer().refresh();
                addAllToTag.setEnabled(true);
                delAllToTag.setEnabled(false);
                delToTag.setEnabled(false);
            }
        });
        delAllToTag.setEnabled(!this.currentList.isEmpty());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)delAllToTag);
        final TagContentProvider selectedTagContentProvider = new TagContentProvider(false, true);
        addAllToTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiscountCampaignTagsPanel.this.currentList.clear();
                DiscountCampaignTagsPanel.this.currentList.addAll(avaliableTagContentProvider.getAllTags());
                DiscountCampaignTagsPanel.this.avaliableTags.getViewer().refresh();
                DiscountCampaignTagsPanel.this.selectedTags.getViewer().refresh();
                delAllToTag.setEnabled(true);
                addAllToTag.setEnabled(false);
                addToTag.setEnabled(false);
            }
        });
        delToTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DiscountCampaignTagsPanel.this.selectedTags.getViewer().getSelection();
                if (!selection.isEmpty()) {
                    Object tag = selection.getFirstElement();
                    DiscountCampaignTagsPanel.this.moveTags(tag, selectedTagContentProvider, false);
                    addAllToTag.setEnabled(DiscountCampaignTagsPanel.this.avaliableTags.getViewer().getTree().getItemCount() != 0);
                    delAllToTag.setEnabled(!DiscountCampaignTagsPanel.this.currentList.isEmpty());
                }
            }
        });
        addToTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DiscountCampaignTagsPanel.this.avaliableTags.getViewer().getSelection();
                if (!selection.isEmpty() && !selection.isEmpty()) {
                    Object tag = selection.getFirstElement();
                    DiscountCampaignTagsPanel.this.moveTags(tag, avaliableTagContentProvider, true);
                    addAllToTag.setEnabled(DiscountCampaignTagsPanel.this.avaliableTags.getViewer().getTree().getItemCount() != 0);
                    delAllToTag.setEnabled(!DiscountCampaignTagsPanel.this.currentList.isEmpty());
                }
            }
        });
        this.avaliableTags.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                addToTag.setEnabled(!event.getSelection().isEmpty());
            }
        });
        Composite selectedRowComposite = new Composite(tagsComposite, 0);
        GridLayout gl_selectedRowComposite = new GridLayout(1, false);
        gl_selectedRowComposite.marginWidth = 0;
        gl_selectedRowComposite.marginHeight = 0;
        selectedRowComposite.setLayout((Layout)gl_selectedRowComposite);
        GridData gd_selectedRowComposite = new GridData(4, 4, true, false, 1, 1);
        gd_selectedRowComposite.widthHint = 200;
        selectedRowComposite.setLayoutData((Object)gd_selectedRowComposite);
        selectedRowComposite.setBounds(0, 0, 64, 64);
        this.selectedTagsLabel = new Label(selectedRowComposite, 0);
        this.selectedTagsLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.selectedTagsLabel.setText("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043c\u0435\u0442\u043a\u0438:");
        Composite selectedTagsComposite = new Composite(selectedRowComposite, 0);
        selectedTagsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_selectedTagsComposite = new GridLayout(1, false);
        gl_selectedTagsComposite.marginHeight = 0;
        gl_selectedTagsComposite.marginWidth = 0;
        selectedTagsComposite.setLayout((Layout)gl_selectedTagsComposite);
        this.selectedTags = new FilteredTree(selectedTagsComposite, 2048, new PatternFilter(), true);
        this.selectedTags.setSize(227, 303);
        this.selectedTags.getViewer().setContentProvider((IContentProvider)selectedTagContentProvider);
        this.selectedTags.getViewer().setLabelProvider((IBaseLabelProvider)new TagLabelProvider());
        this.selectedTags.getViewer().setInput(this.currentList);
        Tree selectedTagsTree = this.selectedTags.getViewer().getTree();
        this.selectedTags.getViewer().refresh();
        selectedTagsTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite selectedTagsModeComposite = new Composite(selectedTagsComposite, 0);
        selectedTagsModeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        selectedTagsModeComposite.setBounds(0, 0, 64, 64);
        GridLayout gl_selectedTagsModeComposite = new GridLayout(1, false);
        gl_selectedTagsModeComposite.verticalSpacing = 0;
        gl_selectedTagsModeComposite.marginWidth = 0;
        gl_selectedTagsModeComposite.marginHeight = 0;
        selectedTagsModeComposite.setLayout((Layout)gl_selectedTagsModeComposite);
        Composite selectedTagsModeLabelComposite = new Composite(selectedTagsModeComposite, 0);
        selectedTagsModeLabelComposite.setLayout((Layout)new GridLayout(1, false));
        selectedTagsModeLabelComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        Label label = new Label(selectedTagsModeLabelComposite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label.setBounds(0, 0, 49, 13);
        label.setText("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0430\u043a\u0446\u0438\u0438:");
        Composite selectedTagsModeButtonsComposite = new Composite(selectedTagsModeComposite, 0);
        selectedTagsModeButtonsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_selectedTagsModeButtonsComposite = new GridLayout(1, false);
        gl_selectedTagsModeButtonsComposite.marginHeight = 0;
        gl_selectedTagsModeButtonsComposite.marginWidth = 0;
        gl_selectedTagsModeButtonsComposite.marginLeft = 20;
        selectedTagsModeButtonsComposite.setLayout((Layout)gl_selectedTagsModeButtonsComposite);
        this.allowedTagsButton = new Button(selectedTagsModeButtonsComposite, 16);
        this.allowedTagsButton.setSize(254, 16);
        this.allowedTagsButton.setText("\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445");
        this.allowedTagsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DiscountCampaign)DiscountCampaignTagsPanel.this.getModel()).setTagsIsAllowed(DiscountCampaignTagsPanel.this.allowedTagsButton.getSelection());
            }
        });
        this.allowedTagsButton.setSelection(((DiscountCampaign)this.getModel()).isTagsIsAllowed());
        this.forbiddenTagsButton = new Button(selectedTagsModeButtonsComposite, 16);
        this.forbiddenTagsButton.setSize(254, 16);
        this.forbiddenTagsButton.setSelection(true);
        this.forbiddenTagsButton.setText("\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445");
        this.forbiddenTagsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DiscountCampaign)DiscountCampaignTagsPanel.this.getModel()).setTagsIsAllowed(!DiscountCampaignTagsPanel.this.forbiddenTagsButton.getSelection());
            }
        });
        this.forbiddenTagsButton.setSelection(!((DiscountCampaign)this.getModel()).isTagsIsAllowed());
        this.selectedTags.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                delToTag.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    private void moveTags(Object tag, TagContentProvider contentProvider, boolean isAvaliableList) {
        this.updateTagTree(tag, this.currentList, contentProvider, isAvaliableList);
        this.avaliableTags.getViewer().refresh();
        this.selectedTags.getViewer().refresh();
    }

    public List<List<String>> getGroupingTags() {
        return ((TagContentProvider)this.selectedTags.getViewer().getContentProvider()).getGroupingTags();
    }

    private void updateTagTree(Object tag, List<ShopLabel> currentList, TagContentProvider contentProvider, boolean isAvaliableList) {
        if (tag instanceof ShopLabel) {
            if (isAvaliableList) {
                currentList.add((ShopLabel)tag);
            } else {
                currentList.remove((ShopLabel)tag);
            }
        } else if (tag instanceof ShopGroupLabel) {
            Object[] objectArray = contentProvider.getChildren(tag);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof ShopLabel) {
                    if (isAvaliableList) {
                        currentList.add((ShopLabel)obj);
                    } else {
                        currentList.remove((ShopLabel)obj);
                    }
                } else if (obj instanceof ShopGroupLabel) {
                    this.updateTagTree(obj, currentList, contentProvider, isAvaliableList);
                }
                ++n2;
            }
        }
    }
}

