/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.controls;

import com.richclientgui.toolbox.validation.ValidatingField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControlListener;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionEntitySelectControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionTextboxAndSelectButton;
import su.artix.discountmanager.utils.StringResultGetter;

public abstract class DiscountConditionEntityControl
extends DiscountConditionEntitySelectControl
implements DiscountConditionControl {
    protected ValidatingField<String> validator;
    protected Text text;
    protected boolean isIntValues;

    public DiscountConditionEntityControl(Composite parent, String labelName, String defaultValue, boolean isMulti) {
        this(parent, labelName, defaultValue, isMulti, false);
    }

    public DiscountConditionEntityControl(Composite parent, String labelName, String defaultValue, boolean isMulti, boolean isIntValues) {
        DiscountConditionTextboxAndSelectButton panel = new DiscountConditionTextboxAndSelectButton(parent, 0, labelName);
        this.validator = panel.getValidator();
        this.text = panel.getText();
        this.isIntValues = isIntValues;
        if (defaultValue != null) {
            if (!defaultValue.startsWith("[") && !defaultValue.endsWith("]")) {
                this.text.setText(this.getStringDefaultValue(defaultValue, isMulti, isIntValues));
            } else {
                this.text.setText(defaultValue);
            }
        }
        Button button = panel.getButton();
        StringResultGetter rg = isIntValues ? new StringResultGetter(",", "", "[", "]") : new StringResultGetter(",", "\"", "[", "]", "u");
        button.addSelectionListener((SelectionListener)this.getSelectionAdapter(isMulti, rg, defaultValue));
    }

    private String getStringDefaultValue(String defaultValue, boolean isMulti, boolean isIntValue) {
        if (isMulti) {
            return "[" + this.getStringDefaultValue(defaultValue, isIntValue) + "]";
        }
        return this.getStringDefaultValue(defaultValue, isIntValue);
    }

    private String getStringDefaultValue(String defaultValue, boolean isIntValue) {
        if (isIntValue) {
            return defaultValue;
        }
        return "u\"" + defaultValue + "\"";
    }

    protected abstract SelectionAdapter getSelectionAdapter(boolean var1, StringResultGetter var2, String var3);

    @Override
    public String getText() {
        return this.text.getText();
    }

    @Override
    public String getDesc() {
        return this.getText();
    }

    @Override
    public boolean isValid() {
        return this.validator != null && this.validator.isValid();
    }

    @Override
    public void addListener(final DiscountConditionControlListener listener) {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                listener.exec();
            }
        });
    }
}

