/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.controls;

import com.richclientgui.toolbox.validation.ValidatingField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import su.artix.discountmanager.dialogs.ListSelectionDialog;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControlListener;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionTextboxAndSelectButton;
import su.artix.discountmanager.utils.StringResultGetter;
import su.artix.yuki.directory.DirectoryLabelProvider;
import su.artix.yuki.directory.DirectoryList;
import su.artix.yuki.directory.MyKeyValue;

public class DiscountConditionMultiSelectControl
implements DiscountConditionControl {
    private ValidatingField<String> validator;
    private Map<String, String> values;
    private Object[] desc;
    private StringResultGetter rg;
    private Text text;

    public DiscountConditionMultiSelectControl(Composite parent, final String labelName, Map<String, String> values, String defaultValue) {
        this.values = values;
        this.rg = new StringResultGetter(",", "", "[", "]", "");
        DiscountConditionTextboxAndSelectButton panel = new DiscountConditionTextboxAndSelectButton(parent, 0, labelName);
        this.validator = panel.getValidator();
        this.text = panel.getText();
        if (defaultValue != null) {
            this.text.setText(defaultValue);
        }
        Button btn = panel.getButton();
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String result = null;
                if (DiscountConditionMultiSelectControl.this.text.getText() != null) {
                    List<String> selectedValues = Arrays.asList(DiscountConditionMultiSelectControl.this.text.getText().replaceAll("\\[", "").replaceAll("\\]", "").split(","));
                    DirectoryList directoryList = new DirectoryList();
                    DirectoryList selectedList = new DirectoryList();
                    for (Map.Entry value : DiscountConditionMultiSelectControl.this.values.entrySet()) {
                        directoryList.add((String)value.getValue(), (String)value.getKey());
                        if (!selectedValues.contains(value.getValue())) continue;
                        selectedList.add((String)value.getValue(), (String)value.getKey());
                    }
                    result = DiscountConditionMultiSelectControl.this.selectListAction(labelName, directoryList, selectedList);
                } else {
                    DirectoryList directoryList = new DirectoryList();
                    for (Map.Entry value : DiscountConditionMultiSelectControl.this.values.entrySet()) {
                        directoryList.add((String)value.getValue(), (String)value.getKey());
                    }
                    result = DiscountConditionMultiSelectControl.this.selectListAction(labelName, directoryList, null);
                }
                if (result != null) {
                    DiscountConditionMultiSelectControl.this.validator.setContents((Object)result);
                }
            }
        });
    }

    @Override
    public String getText() {
        return ((Text)this.validator.getControl()).getText();
    }

    @Override
    public String getDesc() {
        String result = this.getText();
        if (this.desc != null) {
            ArrayList<String> list = new ArrayList<String>();
            Object[] objectArray = this.desc;
            int n = this.desc.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof MyKeyValue) {
                    MyKeyValue pair = (MyKeyValue)obj;
                    list.add((String)pair.getValue());
                }
                ++n2;
            }
            if (!list.isEmpty() && this.desc.length == list.size()) {
                result = this.rg.getStringFromList(list);
            }
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return this.validator != null && this.validator.isValid();
    }

    @Override
    public void addListener(final DiscountConditionControlListener listener) {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                listener.exec();
            }
        });
    }

    protected String selectListAction(String title, DirectoryList valuesMap, DirectoryList selectedValues) {
        String res = null;
        DirectoryLabelProvider lblProvider = new DirectoryLabelProvider();
        ArrayContentProvider strProvider = ArrayContentProvider.getInstance();
        ListSelectionDialog dialog = selectedValues != null ? new ListSelectionDialog(Display.getDefault().getActiveShell(), valuesMap, (IStructuredContentProvider)strProvider, (ILabelProvider)lblProvider, title, selectedValues) : new ListSelectionDialog(Display.getDefault().getActiveShell(), valuesMap, (IStructuredContentProvider)strProvider, (ILabelProvider)lblProvider, title);
        if (dialog.open() == 0 && dialog.getResult() != null) {
            this.desc = dialog.getResult();
            res = this.rg.getStringFromList(this.desc);
        }
        return res;
    }
}

