/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.kitnew;

import com.richclientgui.toolbox.validation.ValidatingField;
import com.richclientgui.toolbox.validation.string.StringValidationToolkit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Catalog;
import ru.ssa.cashadmin.domain.Invent;
import su.artix.discountmanager.dialogs.discountsystem.DiscountRateConstructorDialog;
import su.artix.discountmanager.dialogs.discountsystem.kitnew.DiscountConditionEditDialog;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanager.utils.QuestionMessageFactory;
import su.artix.discountmanager.utils.ValidatorFactory;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountKitObjectItem;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateCalculate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateIndex;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitObjectItem;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRatePercent;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRatePrice;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateSum;
import su.artix.yuki.editors.AbstractDirectorySelectDialog;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.editors.DirectorySelectFactory;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public class KitItemDialog
extends Dialog {
    private static Logger log = LoggerFactory.getLogger(KitItemDialog.class);
    private String title;
    private ValidatingField<String> nameValField;
    private Spinner countValSpinner;
    private TabFolder contentTabFolder;
    private TabItem catalogsTabItem;
    private TabItem conditionsTabItem;
    private Table codeTable;
    private Button addCodeButton;
    private Button deleteCodeButton;
    private final DiscountRateKitObjectItem rateItem;
    private List<String> codes = new ArrayList<String>();
    private Clipboard clipboard;
    private Combo rateObject;
    private Spinner valueValField;
    private Text calcValField = null;
    private Combo calcRateType = null;
    private Composite valuePanel;
    private int lastSelectionIndex = -1;
    private double lastSpinerValue = 1.0;
    private String lastCalcValue = "";
    private String lastCalcRateTypeValue = "";
    private List<DiscountCondition> conditions = new ArrayList<DiscountCondition>();
    private Table conditionTable;
    private Button addConditionButton;
    private Button editConditionButton;
    private Button deleteConditionButton;
    DirectorySelectDialogState selectDialogState = new DirectorySelectDialogState();

    public KitItemDialog(String title, DiscountRateKitObjectItem rateItem) {
        super(Display.getCurrent().getActiveShell());
        this.codes.addAll(rateItem.getDiscountKitObjectItem().getGoodsCode());
        this.conditions.addAll(rateItem.getDiscountKitObjectItem().getConditions());
        this.title = title;
        this.clipboard = new Clipboard(Display.getCurrent());
        this.rateItem = rateItem;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Point getInitialSize() {
        return new Point(450, 600);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(131072, 1024, false, false);
        data.horizontalSpan = 1;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        Label label1 = new Label(composite, 0);
        label1.setText("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:");
        StringValidationToolkit codeValToolKit = new StringValidationToolkit(131200, 1, true);
        this.nameValField = codeValToolKit.createTextField(composite, ValidatorFactory.NotNullStringValidator, false, (Object)"");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo(this.nameValField.getControl());
        Label label2 = new Label(composite, 0);
        label2.setText("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:");
        this.countValSpinner = new Spinner(composite, 2048);
        this.countValSpinner.setValues(1000, 1, 999999999, 3, 1000, 10000);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.countValSpinner);
        this.createRateFields(parent);
        Group contentGroup = new Group(parent, 16);
        contentGroup.setText("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435");
        GridLayoutFactory.swtDefaults().margins(10, 5).applyTo((Composite)contentGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)contentGroup);
        this.contentTabFolder = new TabFolder((Composite)contentGroup, 0);
        GridLayoutFactory.swtDefaults().applyTo((Composite)this.contentTabFolder);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.contentTabFolder);
        this.createCodeTabItem(this.contentTabFolder);
        this.createConditionTabItem(this.contentTabFolder);
        this.contentTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                TableItem item;
                int n;
                int n2;
                TableItem[] tableItemArray;
                TabItem curTabItem = (TabItem)arg0.item;
                if (KitItemDialog.this.conditionsTabItem.equals(curTabItem) && !KitItemDialog.this.codes.isEmpty()) {
                    if (QuestionMessageFactory.simpleQuestionMessage("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", "\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0430\u0431\u043e\u0440\u0430 \u043c\u043e\u0436\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043b\u0438\u0431\u043e \u043f\u043e \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430\u043c, \u043b\u0438\u0431\u043e \u043f\u043e \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u043c. \u041f\u0440\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0435 \u0432\u043e \u0432\u043a\u043b\u0430\u0434\u043a\u0443 \"\u0423\u0441\u043b\u043e\u0432\u0438\u044f\" \u0431\u0443\u0434\u0443\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u044b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0438. \u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432\u043e \u0432\u043a\u043b\u0430\u0434\u043a\u0443 \"\u0423\u0441\u043b\u043e\u0432\u0438\u044f\"?")) {
                        tableItemArray = KitItemDialog.this.codeTable.getItems();
                        n2 = tableItemArray.length;
                        n = 0;
                        while (n < n2) {
                            item = tableItemArray[n];
                            item.dispose();
                            ++n;
                        }
                        KitItemDialog.this.codes.clear();
                    } else {
                        KitItemDialog.this.contentTabFolder.setSelection(KitItemDialog.this.catalogsTabItem);
                    }
                }
                if (KitItemDialog.this.catalogsTabItem.equals(curTabItem) && !KitItemDialog.this.conditions.isEmpty()) {
                    if (QuestionMessageFactory.simpleQuestionMessage("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", "\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0430\u0431\u043e\u0440\u0430 \u043c\u043e\u0436\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043b\u0438\u0431\u043e \u043f\u043e \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430\u043c, \u043b\u0438\u0431\u043e \u043f\u043e \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u043c. \u041f\u0440\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0435 \u0432\u043e \u0432\u043a\u043b\u0430\u0434\u043a\u0443 \"\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0438\" \u0431\u0443\u0434\u0443\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u044b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f. \u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432\u043e \u0432\u043a\u043b\u0430\u0434\u043a\u0443 \"\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0438\"?")) {
                        tableItemArray = KitItemDialog.this.conditionTable.getItems();
                        n2 = tableItemArray.length;
                        n = 0;
                        while (n < n2) {
                            item = tableItemArray[n];
                            item.dispose();
                            ++n;
                        }
                        KitItemDialog.this.conditions.clear();
                    } else {
                        KitItemDialog.this.contentTabFolder.setSelection(KitItemDialog.this.conditionsTabItem);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        DiscountKitObjectItem kitItem = this.rateItem.getDiscountKitObjectItem();
        if (kitItem.getName() != null) {
            this.nameValField.setContents((Object)kitItem.getName());
        }
        if (kitItem.getGoodsCount() != 0.0) {
            Double goodsCountTmp = kitItem.getGoodsCount() * 1000.0;
            this.countValSpinner.setSelection(goodsCountTmp.intValue());
        }
        if (!kitItem.getGoodsCode().isEmpty()) {
            List<KitItemElem> items = this.getInventItemsFromList(this.codes);
            for (KitItemElem invent : items) {
                new TableItem(this.codeTable, 0).setText(new String[]{invent.getCode(), invent.getName()});
            }
        }
        if (!kitItem.getConditions().isEmpty()) {
            for (DiscountCondition dc : kitItem.getConditions()) {
                new TableItem(this.conditionTable, 0).setText(new String[]{dc.getDescription(), dc.getCondition()});
            }
            this.contentTabFolder.setSelection(this.conditionsTabItem);
        }
        return parent;
    }

    private void createRateFields(Composite parent) {
        Group group = new Group(parent, 16);
        GridLayoutFactory.swtDefaults().margins(10, 5).numColumns(2).applyTo((Composite)group);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        group.setText("\u0421\u0442\u0430\u0432\u043a\u0430");
        Label label1 = new Label((Composite)group, 0);
        label1.setText("\u0422\u0438\u043f \u0441\u043a\u0438\u0434\u043a\u0438:");
        this.rateObject = new Combo((Composite)group, 2060);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.rateObject);
        this.rateObject.add("\u0411\u0435\u0437 \u0441\u043a\u0438\u0434\u043a\u0438");
        this.rateObject.add("\u041f\u0440\u043e\u0446\u0435\u043d\u0442\u043d\u0430\u044f");
        this.rateObject.add("\u0421\u0443\u043c\u043c\u043e\u0432\u0430\u044f");
        this.rateObject.add("\u0420\u0430\u0441\u0447\u0435\u0442\u043d\u0430\u044f");
        this.rateObject.add("\u0418\u043d\u0434\u0435\u043a\u0441\u043d\u0430\u044f");
        this.rateObject.add("\u0424\u0438\u043a\u0441. \u0446\u0435\u043d\u0430");
        this.rateObject.select(0);
        Label label2 = new Label((Composite)group, 0);
        label2.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:");
        this.valuePanel = new Composite((Composite)group, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.valuePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.valuePanel);
        Text textTmp = new Text(this.valuePanel, 2048);
        textTmp.setEnabled(false);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)textTmp);
        if (this.rateItem != null && this.rateItem.getDiscountRate() != null) {
            if (this.rateItem.getDiscountRate() instanceof DiscountRatePercent) {
                this.rateObject.select(1);
                this.lastSpinerValue = Double.valueOf(String.valueOf(this.rateItem.getDiscountRate().getDiscountValue()));
                this.addSpinnerToValuePanel();
            } else if (this.rateItem.getDiscountRate() instanceof DiscountRateSum) {
                this.rateObject.select(2);
                this.lastSpinerValue = Double.valueOf(String.valueOf(this.rateItem.getDiscountRate().getDiscountValue()));
                this.addSpinnerToValuePanel();
            } else if (this.rateItem.getDiscountRate() instanceof DiscountRateCalculate) {
                this.rateObject.select(3);
                this.lastCalcValue = String.valueOf(this.rateItem.getDiscountRate().getDiscountValue());
                this.lastCalcRateTypeValue = ((DiscountRateCalculate)this.rateItem.getDiscountRate()).getDiscountRateType();
                this.addCalcFieldToValuePanel();
            } else if (this.rateItem.getDiscountRate() instanceof DiscountRateIndex) {
                this.rateObject.select(4);
                this.lastSpinerValue = Double.valueOf(String.valueOf(this.rateItem.getDiscountRate().getDiscountValue()));
                this.addSpinnerToValuePanel();
            } else if (this.rateItem.getDiscountRate() instanceof DiscountRatePrice) {
                this.rateObject.select(5);
                this.lastSpinerValue = Double.valueOf(String.valueOf(this.rateItem.getDiscountRate().getDiscountValue()));
                this.addSpinnerToValuePanel();
            }
            this.lastSelectionIndex = this.rateObject.getSelectionIndex();
        }
        this.rateObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (KitItemDialog.this.lastSelectionIndex != KitItemDialog.this.rateObject.getSelectionIndex()) {
                    if (KitItemDialog.this.lastSelectionIndex == 3) {
                        KitItemDialog.this.lastCalcValue = KitItemDialog.this.calcValField.getText();
                        KitItemDialog.this.lastCalcRateTypeValue = KitItemDialog.this.calcRateTypeSelectionIndexToValue(KitItemDialog.this.calcRateType.getSelectionIndex());
                    } else if (KitItemDialog.this.lastSelectionIndex == 4) {
                        KitItemDialog.this.lastSpinerValue = KitItemDialog.this.valueValField.getSelection();
                    } else if (KitItemDialog.this.lastSelectionIndex == 1 || KitItemDialog.this.lastSelectionIndex == 2) {
                        KitItemDialog.this.lastSpinerValue = (double)KitItemDialog.this.valueValField.getSelection() / 100.0;
                    }
                    if (KitItemDialog.this.rateObject.getSelectionIndex() == 0) {
                        KitItemDialog.this.addTextboxToValuePanel();
                    } else if (KitItemDialog.this.rateObject.getSelectionIndex() == 1) {
                        KitItemDialog.this.addSpinnerToValuePanel();
                    } else if (KitItemDialog.this.rateObject.getSelectionIndex() == 2) {
                        KitItemDialog.this.addSpinnerToValuePanel();
                    } else if (KitItemDialog.this.rateObject.getSelectionIndex() == 3) {
                        KitItemDialog.this.addCalcFieldToValuePanel();
                    } else if (KitItemDialog.this.rateObject.getSelectionIndex() == 4) {
                        KitItemDialog.this.addSpinnerToValuePanel();
                    } else if (KitItemDialog.this.rateObject.getSelectionIndex() == 5) {
                        KitItemDialog.this.addSpinnerToValuePanel();
                    }
                    KitItemDialog.this.lastSelectionIndex = KitItemDialog.this.rateObject.getSelectionIndex();
                }
            }
        });
    }

    private void disposeValuePanel() {
        Control[] controlArray = this.valuePanel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private void resizeValuePanel() {
        this.valuePanel.layout();
        this.valuePanel.getParent().pack();
        if (this.valuePanel.getParent() != null && this.valuePanel.getParent().getParent() != null) {
            this.valuePanel.getParent().getParent().layout();
        }
    }

    private void addTextboxToValuePanel() {
        this.disposeValuePanel();
        Text textTmp = new Text(this.valuePanel, 2048);
        textTmp.setEnabled(false);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)textTmp);
        this.resizeValuePanel();
    }

    private void addSpinnerToValuePanel() {
        this.disposeValuePanel();
        this.valueValField = new Spinner(this.valuePanel, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.valueValField);
        if (this.rateObject.getSelectionIndex() == 1) {
            this.valueValField.setValues((int)(this.lastSpinerValue * 100.0), 1, 10000, 2, 100, 1000);
            this.valueValField.setSelection((int)(this.lastSpinerValue * 100.0));
        } else if (this.rateObject.getSelectionIndex() == 2) {
            this.valueValField.setValues((int)(this.lastSpinerValue * 100.0), 1, 999999999, 2, 100, 1000);
            this.valueValField.setSelection((int)(this.lastSpinerValue * 100.0));
        } else if (this.rateObject.getSelectionIndex() == 4) {
            this.valueValField.setValues((int)this.lastSpinerValue, 0, 999999999, 0, 1, 10);
        } else if (this.rateObject.getSelectionIndex() == 5) {
            this.valueValField.setValues((int)(this.lastSpinerValue * 100.0), 1, 999999999, 2, 100, 1000);
            this.valueValField.setSelection((int)(this.lastSpinerValue * 100.0));
        }
        this.resizeValuePanel();
    }

    private void addCalcFieldToValuePanel() {
        this.disposeValuePanel();
        this.calcValField = new Text(this.valuePanel, 128);
        this.calcValField.setText(this.lastCalcValue);
        GridDataFactory.fillDefaults().span(1, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.calcValField);
        Button btn = new Button(this.valuePanel, 8);
        btn.setToolTipText("\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0430");
        btn.setImage(ImagesFactory.INSTANCE.getImage("16x16/shadow/construction.png"));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscountRateConstructorDialog dialog = new DiscountRateConstructorDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0439 \u0441\u0442\u0430\u0432\u043a\u0438");
                if (dialog.open() == 0) {
                    log.info("Return from rate constructor: {}", (Object)dialog.getDiscountCondition());
                    KitItemDialog.this.calcValField.setText(dialog.getDiscountCondition());
                }
            }
        });
        Composite calcRateTypePanel = new Composite(this.valuePanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(calcRateTypePanel);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)calcRateTypePanel);
        Label calcRateTypeLabel = new Label(calcRateTypePanel, 0);
        calcRateTypeLabel.setText("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0441\u0442\u0430\u0432\u043a\u0438: ");
        this.calcRateType = new Combo(calcRateTypePanel, 2060);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, true).applyTo((Control)this.calcRateType);
        this.calcRateType.add("\u041f\u0440\u043e\u0446\u0435\u043d\u0442\u044b");
        this.calcRateType.add("\u0421\u0443\u043c\u043c\u0430");
        this.calcRateType.add("\u0418\u043d\u0434\u0435\u043a\u0441\u044b");
        this.calcRateType.add("\u0424\u0438\u043a\u0441. \u0446\u0435\u043d\u0430");
        this.calcRateType.select(this.calcRateTypeValueToSelectionIndex(this.lastCalcRateTypeValue));
        this.resizeValuePanel();
    }

    protected void okPressed() {
        DiscountKitObjectItem kitItem = this.rateItem.getDiscountKitObjectItem();
        if (this.nameValField.isValid() && (!this.codes.isEmpty() || !this.conditions.isEmpty()) && (this.valueValField != null && !this.valueValField.isDisposed() || this.calcValField != null && !this.calcValField.isDisposed() && !this.calcValField.getText().isEmpty()) || this.rateObject.getSelectionIndex() == 0) {
            kitItem.setName((String)this.nameValField.getContents());
            kitItem.setGoodsCount(Double.valueOf((double)this.countValSpinner.getSelection() / 1000.0));
            kitItem.setGoodsCode(this.codes);
            kitItem.setConditions(this.conditions);
            this.doWithRate();
            super.okPressed();
        } else {
            ErrorMessageFactory.emptyFieldMessage();
        }
    }

    private void createCodeTabItem(TabFolder tabFolder) {
        this.catalogsTabItem = new TabItem(tabFolder, 0);
        this.catalogsTabItem.setText("\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0438");
        Composite composite = new Composite((Composite)this.catalogsTabItem.getParent(), 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.catalogsTabItem.setControl((Control)composite);
        this.codeTable = new Table(composite, 67584);
        this.codeTable.setLinesVisible(true);
        this.codeTable.setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.codeTable);
        TableColumn tableColumnCode = new TableColumn(this.codeTable, 16384);
        tableColumnCode.setText("\u041a\u043e\u0434");
        tableColumnCode.setWidth(100);
        tableColumnCode.setResizable(true);
        TableColumn tableColumnName = new TableColumn(this.codeTable, 16384);
        tableColumnName.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        tableColumnName.setWidth(180);
        MenuManager popupMenu = new MenuManager();
        popupMenu.add((IAction)new PasteCodeFromClipboardAction());
        Menu menu = popupMenu.createContextMenu((Control)this.codeTable);
        this.codeTable.setMenu(menu);
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().applyTo(buttonsComposite);
        GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)buttonsComposite);
        this.addCodeButton = new Button(buttonsComposite, 8);
        this.addCodeButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u0430\u0442\u0430\u043b\u043e\u0433");
        this.addCodeButton.setImage(ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/add.png").createImage());
        this.addCodeButton.addSelectionListener((SelectionListener)new InsertCodeAdapter());
        this.deleteCodeButton = new Button(buttonsComposite, 8);
        this.deleteCodeButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u0430\u0442\u0430\u043b\u043e\u0433");
        this.deleteCodeButton.setImage(ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/delete.png").createImage());
        this.deleteCodeButton.addSelectionListener((SelectionListener)new DeleteCodeAdapter());
    }

    private void createConditionTabItem(TabFolder tabFolder) {
        this.conditionsTabItem = new TabItem(tabFolder, 0);
        this.conditionsTabItem.setText("\u0423\u0441\u043b\u043e\u0432\u0438\u044f");
        Composite composite = new Composite((Composite)this.conditionsTabItem.getParent(), 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.conditionsTabItem.setControl((Control)composite);
        this.conditionTable = new Table(composite, 67584);
        this.conditionTable.setLinesVisible(true);
        this.conditionTable.setHeaderVisible(true);
        this.conditionTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                KitItemDialog.this.editConditionButton.setEnabled(true);
                KitItemDialog.this.deleteConditionButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.conditionTable);
        TableColumn columnConditionDescription = new TableColumn(this.conditionTable, 16384);
        columnConditionDescription.setText("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f");
        columnConditionDescription.setWidth(200);
        columnConditionDescription.setResizable(true);
        TableColumn columnConditionValue = new TableColumn(this.conditionTable, 16384);
        columnConditionValue.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f");
        columnConditionValue.setWidth(120);
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().applyTo(buttonsComposite);
        GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)buttonsComposite);
        this.addConditionButton = new Button(buttonsComposite, 8);
        this.addConditionButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u0435");
        this.addConditionButton.setImage(ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/add.png").createImage());
        this.addConditionButton.addSelectionListener((SelectionListener)new InsertConditionAdapter(false));
        this.editConditionButton = new Button(buttonsComposite, 8);
        this.editConditionButton.setToolTipText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u0435");
        this.editConditionButton.setImage(ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/edit.png").createImage());
        this.editConditionButton.addSelectionListener((SelectionListener)new InsertConditionAdapter(true));
        this.editConditionButton.setEnabled(false);
        this.deleteConditionButton = new Button(buttonsComposite, 8);
        this.deleteConditionButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u0435");
        this.deleteConditionButton.setImage(ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/delete.png").createImage());
        this.deleteConditionButton.addSelectionListener((SelectionListener)new DeleteConditionAdapter());
        this.deleteConditionButton.setEnabled(false);
    }

    private boolean checkContainsCode(KitItemElem item) {
        if (!this.codes.isEmpty()) {
            for (String s : this.codes) {
                if (!s.equals(item.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkContainsCode(String item) {
        if (!this.codes.isEmpty()) {
            for (String s : this.codes) {
                if (!s.equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    private DiscountCondition getExistsDiscountCondition(DiscountCondition item) {
        if (!this.conditions.isEmpty()) {
            for (DiscountCondition s : this.conditions) {
                if (!s.equalsWithoutParent((Object)item)) continue;
                return s;
            }
        }
        return null;
    }

    private void doWithRate() {
        try {
            if (this.valueValField != null || this.calcValField != null || this.rateObject.getSelectionIndex() == 0) {
                if (this.rateObject.getSelectionIndex() == 0) {
                    this.rateItem.setDiscountRate(null);
                } else if (this.rateObject.getSelectionIndex() == 1) {
                    this.rateItem.setDiscountRate((DiscountRate)new DiscountRatePercent(BigDecimal.valueOf(Double.valueOf(this.valueValField.getSelection()) / 100.0)));
                } else if (this.rateObject.getSelectionIndex() == 2) {
                    this.rateItem.setDiscountRate((DiscountRate)new DiscountRateSum(BigDecimal.valueOf(Double.valueOf(this.valueValField.getSelection()) / 100.0)));
                } else if (this.rateObject.getSelectionIndex() == 3) {
                    this.rateItem.setDiscountRate((DiscountRate)new DiscountRateCalculate(this.calcValField.getText(), this.calcRateTypeSelectionIndexToValue(this.calcRateType.getSelectionIndex())));
                } else if (this.rateObject.getSelectionIndex() == 4) {
                    this.rateItem.setDiscountRate((DiscountRate)new DiscountRateIndex(Integer.valueOf(String.valueOf(this.valueValField.getSelection()))));
                } else if (this.rateObject.getSelectionIndex() == 5) {
                    this.rateItem.setDiscountRate((DiscountRate)new DiscountRatePrice(BigDecimal.valueOf(Double.valueOf(this.valueValField.getSelection()) / 100.0)));
                }
            } else {
                ErrorMessageFactory.emptyFieldMessage();
            }
        }
        catch (Exception e) {
            ErrorMessageFactory.exceptionMessage(e);
        }
    }

    private KitItemElem getKitItemElem(Object itemFromDomain) {
        KitItemElem elem = new KitItemElem();
        if (itemFromDomain instanceof Invent) {
            String name = ((Invent)itemFromDomain).getName();
            if (name == null) {
                name = "<\u0442\u043e\u0432\u0430\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0411\u0414>";
            }
            elem.setCode(((Invent)itemFromDomain).getCode());
            elem.setName(name);
        } else {
            String name = ((Catalog)itemFromDomain).getCatalogname();
            if (name == null) {
                name = "<\u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0411\u0414>";
            }
            elem.setCode(String.valueOf(((Catalog)itemFromDomain).getCatalogid()));
            elem.setName(name);
        }
        return elem;
    }

    private List<KitItemElem> getInventItemsFromList(List<String> codes) {
        DirectoryEditModel model = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Catalog.class);
        ArrayList<KitItemElem> items = new ArrayList<KitItemElem>(codes.size());
        try {
            Object modelItem = LibActivator.getDefault().getActualClassResolver().getInstance(Catalog.class);
            for (String code : codes) {
                if (modelItem instanceof Invent) {
                    ((Invent)modelItem).setCode(code);
                } else {
                    ((Catalog)modelItem).setCatalogid(code);
                }
                List itemsFromDomain = model.getList(modelItem);
                if (itemsFromDomain.isEmpty()) {
                    KitItemElem elem = this.getKitItemElem(modelItem);
                    items.add(elem);
                    continue;
                }
                for (Object itemFromDomain : itemsFromDomain) {
                    KitItemElem elem = this.getKitItemElem(itemFromDomain);
                    items.add(elem);
                }
            }
        }
        catch (Exception e) {
            log.error("Exception while added invents: {}", (Object)e.getMessage());
        }
        return items;
    }

    private int calcRateTypeValueToSelectionIndex(String rateType) {
        switch (rateType) {
            case "sum": {
                return 1;
            }
            case "index": {
                return 2;
            }
            case "price": {
                return 3;
            }
        }
        return 0;
    }

    private String calcRateTypeSelectionIndexToValue(int rateTypeIndex) {
        switch (rateTypeIndex) {
            case 1: {
                return "sum";
            }
            case 2: {
                return "index";
            }
            case 3: {
                return "price";
            }
        }
        return "percent";
    }

    public DiscountRateKitObjectItem getRateItem() {
        return this.rateItem;
    }

    private class DeleteCodeAdapter
    extends SelectionAdapter {
        private DeleteCodeAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = KitItemDialog.this.codeTable.getSelectionIndex();
            if (QuestionMessageFactory.deleteObjectQuestionMessage((String)KitItemDialog.this.codes.get(index))) {
                KitItemDialog.this.codeTable.getItem(index).dispose();
                KitItemDialog.this.codes.remove(index);
            }
        }
    }

    private class DeleteConditionAdapter
    extends SelectionAdapter {
        private DeleteConditionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = KitItemDialog.this.conditionTable.getSelectionIndex();
            if (QuestionMessageFactory.deleteObjectQuestionMessage(((DiscountCondition)KitItemDialog.this.conditions.get(index)).getDescription())) {
                KitItemDialog.this.conditionTable.getItem(index).dispose();
                KitItemDialog.this.conditions.remove(index);
            }
        }
    }

    private class InsertCodeAdapter
    extends SelectionAdapter {
        private InsertCodeAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            KitItemElem item;
            AbstractDirectorySelectDialog dialog = DirectorySelectFactory.getSelect(Catalog.class, (Shell)KitItemDialog.this.getShell(), null, (DirectorySelectDialogState)KitItemDialog.this.selectDialogState);
            if (dialog.open() == 0 && !KitItemDialog.this.checkContainsCode(item = KitItemDialog.this.getKitItemElem(dialog.getModel()))) {
                new TableItem(KitItemDialog.this.codeTable, 0).setText(new String[]{item.getCode(), item.getName()});
                KitItemDialog.this.codes.add(item.getCode());
            }
        }
    }

    private class InsertConditionAdapter
    extends SelectionAdapter {
        private boolean editMode;

        public InsertConditionAdapter(boolean editMode) {
            this.editMode = editMode;
        }

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionEditDialog dialog = new DiscountConditionEditDialog(this.editMode ? (DiscountCondition)KitItemDialog.this.conditions.get(KitItemDialog.this.conditionTable.getSelectionIndex()) : null);
            if (dialog.open() == 0 && KitItemDialog.this.getExistsDiscountCondition(dialog.getDiscountCondition()) == null) {
                KitItemDialog.this.conditions.add(dialog.getDiscountCondition());
                new TableItem(KitItemDialog.this.conditionTable, 0).setText(new String[]{dialog.getDiscountCondition().getDescription(), dialog.getDiscountCondition().getCondition()});
            }
        }
    }

    private static class KitItemElem {
        private String code;
        private String name;

        private KitItemElem() {
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private class PasteCodeFromClipboardAction
    extends Action {
        public PasteCodeFromClipboardAction() {
            super("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u0434\u044b \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430");
        }

        public void run() {
            String str = (String)KitItemDialog.this.clipboard.getContents((Transfer)TextTransfer.getInstance());
            String[] codesList = StringUtils.split((String)str);
            ArrayList<String> codesWithoutContains = new ArrayList<String>();
            if (codesList.length != 0) {
                String[] stringArray = codesList;
                int n = codesList.length;
                int n2 = 0;
                while (n2 < n) {
                    String code = stringArray[n2];
                    if (!KitItemDialog.this.checkContainsCode(code)) {
                        codesWithoutContains.add(code);
                    }
                    List items = KitItemDialog.this.getInventItemsFromList(codesWithoutContains);
                    for (KitItemElem kitItemElem : items) {
                        new TableItem(KitItemDialog.this.codeTable, 0).setText(new String[]{kitItemElem.getCode(), kitItemElem.getName()});
                        KitItemDialog.this.codes.add(kitItemElem.getCode());
                    }
                    ++n2;
                }
            }
        }
    }
}

