/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.handlers.ImportSystemHandler;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.loyaltylib.convertor.discountsystem.DiscountSystemFromYaml;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.loyaltylib.domain.java.observable.AutoincCodes;
import su.artix.loyaltylib.domain.java.observable.Named;

public class ImportSubTreeDiscountSystemHandler
extends ImportSystemHandler {
    private static Logger log = LoggerFactory.getLogger(ImportSubTreeDiscountSystemHandler.class);

    private boolean changeIdUserQuestion() throws Exception {
        MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "\u041f\u043e\u0432\u0442\u043e\u0440 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u0432", null, "\u0412 \u0434\u0438\u0441\u043a\u043e\u043d\u0442\u0435 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441 \u0442\u0435\u043c \u0436\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c, \u0447\u0442\u043e \u0438 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442. \u0427\u0442\u043e \u0434\u0435\u043b\u0430\u0442\u044c?", 3, new String[]{"\u041d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442", "\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 id", "\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443"}, 0);
        dialog.open();
        switch (dialog.getReturnCode()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                throw new Exception("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u0430 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c");
            }
        }
        return false;
    }

    protected void loadDiscountModelFromFile() {
        Object discountObject = ViewHolder.INSTANCE.getSelectionElementFromActiveView();
        DiscountSystemDAO.SystemType systemType = this.getProvider().getSystemType();
        AtomicLong next = Activator.getDefault().next(systemType);
        try {
            String discountModelFromFile = this.getDiscountModelFromFile();
            if (discountModelFromFile != null) {
                List modelsFromFile = DiscountSystemFromYaml.getDiscountModel((String)discountModelFromFile);
                for (AbstractDiscountModel modelFromFile : modelsFromFile) {
                    if (discountObject instanceof DiscountCampaignGroup && (modelFromFile instanceof DiscountCampaignGroup || modelFromFile instanceof DiscountCampaign)) {
                        DiscountCampaignGroup campaignGroup = (DiscountCampaignGroup)discountObject;
                        if (modelFromFile instanceof DiscountCampaignGroup) {
                            campaignGroup.addSubGroup((DiscountCampaignGroup)modelFromFile);
                        } else {
                            DiscountCampaign importedCampaign = (DiscountCampaign)modelFromFile;
                            importedCampaign.setParent((Named)campaignGroup);
                            if (AutoincCodes.checkCodesDiscountCampaign((DiscountCampaignGroup)campaignGroup, (Long)importedCampaign.getId())) {
                                if (!this.changeIdUserQuestion()) continue;
                                importedCampaign.setId(Long.valueOf(next.getAndIncrement()));
                                for (Discount importedDiscount : importedCampaign.getDiscounts()) {
                                    if (!AutoincCodes.checkCodesDiscount((DiscountCampaign)importedCampaign, (Long)importedDiscount.getId())) continue;
                                    importedDiscount.setId(Long.valueOf(next.getAndIncrement()));
                                }
                            }
                            campaignGroup.addDiscountCampaign((DiscountCampaign)modelFromFile);
                        }
                    } else if (discountObject instanceof DiscountCampaign && modelFromFile instanceof Discount) {
                        DiscountCampaign campaign = (DiscountCampaign)discountObject;
                        Discount importedDiscount = (Discount)modelFromFile;
                        if (AutoincCodes.checkCodesDiscount((DiscountCampaign)campaign, (Long)importedDiscount.getId())) {
                            if (!this.changeIdUserQuestion()) continue;
                            importedDiscount.setId(Long.valueOf(next.getAndIncrement()));
                        }
                        campaign.addDiscount((Discount)modelFromFile);
                    } else {
                        throw new Exception("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0447\u0430\u0441\u0442\u044c \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u0430 \u0432 \u0434\u0430\u043d\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e.");
                    }
                    this.getProvider().addListenerTo(modelFromFile);
                }
                this.getProvider().getSystemTreeViewer().refresh();
                this.getProvider().getSystemTreeViewer().setIsChanged(true);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ErrorMessageFactory.exceptionMessage(e);
        }
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.loadDiscountModelFromFile();
        return null;
    }
}

