/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.holders;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.controls.actions.ChangeOwnerDbAction;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;

public enum ViewHolder {
    INSTANCE;

    private static final Logger log;
    private final AtomicReference<IWorkbenchPart> activeViewPart = new AtomicReference();
    private final AtomicReference<IWorkbenchPart> activeSystemViewPart = new AtomicReference();
    private ConcurrentMap<String, IViewPart> loadedDiscountSystemViewIds = new ConcurrentHashMap<String, IViewPart>();

    static {
        log = LoggerFactory.getLogger(ViewHolder.class);
    }

    public IWorkbenchPart getActiveViewPart() {
        return this.activeViewPart.get();
    }

    public void addLoadedDiscountSystemView(String discountSystemViewId, IViewPart discountSystemView) {
        this.loadedDiscountSystemViewIds.put(discountSystemViewId, discountSystemView);
    }

    public void removeLoadedDiscountSystemView(String discountSystemViewId) {
        this.loadedDiscountSystemViewIds.remove(discountSystemViewId);
    }

    public void setActiveViewPart(IWorkbenchPart activeViewPart) {
        Boolean localDBEditValue = true;
        CustomSystemTreeViewer treeViewer = (CustomSystemTreeViewer)activeViewPart.getSite().getSelectionProvider();
        DiscountSystemContentProvider contentProvider = (DiscountSystemContentProvider)treeViewer.getContentProvider();
        localDBEditValue = this.activeViewPart.get() == null || ((CustomSystemTreeViewer)this.activeViewPart.get().getSite().getSelectionProvider()).getContentProvider() == null ? Boolean.valueOf(contentProvider.isLocalDBEdit()) : Boolean.valueOf(((DiscountSystemContentProvider)((CustomSystemTreeViewer)this.activeViewPart.get().getSite().getSelectionProvider()).getContentProvider()).isLocalDBEdit());
        if (this.activeViewPart.get() != null && this.activeViewPart.get().getSite().getSelectionProvider() instanceof CustomSystemTreeViewer && !activeViewPart.getClass().equals(this.activeViewPart.get().getClass()) && !((CustomSystemTreeViewer)this.activeViewPart.get().getSite().getSelectionProvider()).checkAndSaveDiscountTree(activeViewPart)) {
            return;
        }
        this.activeViewPart.set(activeViewPart);
        contentProvider.setLocalDBEdit(localDBEditValue);
        ChangeOwnerDbAction.getInstance().setChecked(contentProvider.isLocalDBEdit());
    }

    public List<String> getLoadedDiscountSystemViewIds() {
        return new ArrayList<String>(this.loadedDiscountSystemViewIds.keySet());
    }

    public IViewPart getViewPart(String viewId) {
        IViewPart viewPart = (IViewPart)this.loadedDiscountSystemViewIds.get(viewId);
        if (PlatformUI.isWorkbenchRunning() && viewPart != null) {
            if (!viewPart.getViewSite().getShell().isDisposed()) {
                return viewPart;
            }
            log.warn("View part with ID: {} is disposed", (Object)viewId);
        }
        return null;
    }

    public Object getSelectionElementFromActiveView() {
        ISelectionProvider selectionProvider = this.getActiveViewPart().getSite().getSelectionProvider();
        if (selectionProvider != null) {
            StructuredSelection selection = (StructuredSelection)selectionProvider.getSelection();
            return selection.getFirstElement();
        }
        return null;
    }

    public StructuredSelection getSelectionFromActiveView() {
        ISelectionProvider selectionProvider = this.getActiveViewPart().getSite().getSelectionProvider();
        if (selectionProvider != null) {
            return (StructuredSelection)selectionProvider.getSelection();
        }
        return null;
    }

    public IWorkbenchPart getActiveSystemViewPart() {
        return this.activeSystemViewPart.get();
    }

    public void setActiveSystemViewPart(IWorkbenchPart activeSystemViewPart) {
        this.activeSystemViewPart.set(activeSystemViewPart);
    }
}

