/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.tags;

import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.providers.discountsystem.TagContentProvider;
import su.artix.discountmanager.tags.DiscountTreeTagFilter;
import su.artix.discountmanager.tags.ViewTagLabelProvider;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;

public class TagFilterView
extends ViewPart {
    private static final Logger log = LoggerFactory.getLogger(TagFilterView.class);
    public static final String ID = "su.artix.discountmanager.views.tagfilter";
    private DiscountTreeTagFilter filter;

    public void createPartControl(Composite parent) {
        final CheckboxTreeViewer tagsTreeViewer = new CheckboxTreeViewer(parent, 2048);
        tagsTreeViewer.setContentProvider((IContentProvider)new TagContentProvider(false, false));
        tagsTreeViewer.setLabelProvider((IBaseLabelProvider)new ViewTagLabelProvider());
        tagsTreeViewer.setInput(new ArrayList());
        this.filter = new DiscountTreeTagFilter();
        CustomSystemTreeViewer discountTreeViewer = this.getSystemViewer();
        discountTreeViewer.addFilter(this.filter);
        tagsTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    tagsTreeViewer.setSubtreeChecked(event.getElement(), true);
                } else {
                    tagsTreeViewer.setSubtreeChecked(event.getElement(), false);
                    if (event.getElement() instanceof ShopLabel) {
                        tagsTreeViewer.setChecked((Object)((ShopLabel)event.getElement()).getShopGroupLabel(), false);
                    }
                }
                ArrayList<ShopLabel> tags = new ArrayList<ShopLabel>();
                Object[] objectArray = tagsTreeViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ShopLabel) {
                        tags.add((ShopLabel)obj);
                    }
                    ++n2;
                }
                TagFilterView.this.filter.setSelected(tags);
                CustomSystemTreeViewer discountTreeViewer = TagFilterView.this.getSystemViewer();
                Object[] expandElements = discountTreeViewer.getExpandedElements();
                discountTreeViewer.refresh();
                discountTreeViewer.setExpandedElements(expandElements);
            }
        });
        Tree tagsTree = tagsTreeViewer.getTree();
        tagsTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    protected CustomSystemTreeViewer getSystemViewer() {
        CustomSystemTreeViewer discountTreeViewer = (CustomSystemTreeViewer)ViewHolder.INSTANCE.getActiveSystemViewPart().getSite().getSelectionProvider();
        return discountTreeViewer;
    }

    public void setFocus() {
        log.debug("set focus active view={}", (Object)ViewHolder.INSTANCE.getActiveSystemViewPart());
        CustomSystemTreeViewer discountTreeViewer = this.getSystemViewer();
        if (!ArrayUtils.contains((Object[])discountTreeViewer.getFilters(), (Object)((Object)this.filter))) {
            discountTreeViewer.addFilter(this.filter);
        }
    }
}

