/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ScalableLayeredPane
extends LayeredPane
implements ScalableFigure {
    private double scale = 1.0;

    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        rect.width = (int)((double)rect.width / this.scale);
        rect.height = (int)((double)rect.height / this.scale);
        rect.x = (int)((double)rect.x / this.scale);
        rect.y = (int)((double)rect.y / this.scale);
        return rect;
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension d = super.getMinimumSize((int)((double)wHint / this.getScale()), (int)((double)hHint / this.getScale()));
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.scale).expand(w, h);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize((int)((double)wHint / this.getScale()), (int)((double)hHint / this.getScale()));
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.scale).expand(w, h);
    }

    public double getScale() {
        return this.scale;
    }

    public boolean isCoordinateSystem() {
        return true;
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        if (this.scale == 1.0) {
            super.paintClientArea(graphics);
        } else {
            boolean optimizeClip;
            ScaledGraphics g = new ScaledGraphics(graphics);
            boolean bl = optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
            if (!optimizeClip) {
                g.clipRect(this.getBounds().getCropped(this.getInsets()));
            }
            g.scale(this.scale);
            g.pushState();
            this.paintChildren(g);
            g.dispose();
            graphics.restoreState();
        }
    }

    public void setScale(double newZoom) {
        if (this.scale == newZoom) {
            return;
        }
        this.scale = newZoom;
        this.fireMoved();
        this.revalidate();
        this.repaint();
    }

    public void translateFromParent(Translatable t) {
        t.performScale(1.0 / this.scale);
    }

    public void translateToParent(Translatable t) {
        t.performScale(this.scale);
    }
}

