/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.hash;

public class HashIntObjNS {
    static final float LOAD_FACTOR = 0.75f;
    private int count = 0;
    private int step = 499979;
    public int[] keys;
    public Object[] values;
    public int[] next;
    private int limit;
    private double loadFactor;

    public HashIntObjNS() {
        this(101, 0.75);
    }

    public HashIntObjNS(int capacity) {
        this(capacity, 0.75);
    }

    public HashIntObjNS(int capacity, double lf) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid hashtable capacity: " + capacity + ".");
        }
        if (capacity == 0) {
            capacity = 101;
        }
        if (lf < 0.0) {
            throw new IllegalArgumentException("Invalid load factor: " + lf + ".");
        }
        if (lf > 1.0) {
            lf = 1.0;
        }
        this.loadFactor = lf;
        this.limit = (int)((double)capacity * lf);
        this.count = 0;
        this.keys = new int[capacity];
        this.values = new Object[capacity];
        this.next = new int[capacity];
        int i = 0;
        while (i < capacity) {
            this.keys[i] = 0;
            this.next[i] = -1;
            ++i;
        }
    }

    public void put(int key, Object value) {
        if (this.count >= this.limit) {
            this.rehash();
        }
        if (this._put(key, value)) {
            ++this.count;
        }
    }

    public Object get(int key) {
        int pos = this.find(key);
        return pos == -1 ? null : this.values[pos];
    }

    public Object remove(int key) {
        int pos = this.find(key);
        if (pos == -1) {
            return null;
        }
        int n = pos;
        this.next[n] = this.next[n] + this.next.length;
        --this.count;
        Object tmp = this.values[pos];
        this.values[pos] = null;
        return tmp;
    }

    public void removeAll() {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = null;
            this.keys[i] = 0;
            this.next[i] = -1;
            ++i;
        }
        this.count = 0;
    }

    public void rehash() {
        int[] tmpKeys = this.keys;
        Object[] tmpValues = this.values;
        int[] tmpNext = this.next;
        int capacity = this.keys.length * 2 + 1;
        int[] keys = new int[capacity];
        Object[] values = new Object[capacity];
        int[] next = new int[capacity];
        int i = 0;
        while (i < next.length) {
            next[i] = -1;
            ++i;
        }
        this.keys = keys;
        this.values = values;
        this.next = next;
        i = 0;
        while (i < tmpNext.length) {
            if (tmpNext[i] >= 0 && tmpNext[i] < tmpNext.length) {
                this._put(tmpKeys[i], tmpValues[i]);
            }
            ++i;
        }
        this.limit = (int)((double)capacity * this.loadFactor);
    }

    public int size() {
        return this.count;
    }

    private int find(int key) {
        int pos = (key & Integer.MAX_VALUE) % this.keys.length;
        int i = 0;
        while (this.next[pos] >= 0) {
            if (this.keys[pos] == key && this.next[pos] < this.next.length) {
                return pos;
            }
            if ((pos = this.next[pos]) >= this.next.length) {
                pos -= this.next.length;
            }
            if (++i <= this.next.length) continue;
            return -1;
        }
        return -1;
    }

    private boolean _put(int key, Object value) {
        int index = this.find(key);
        if (index != -1) {
            this.values[index] = value;
            return false;
        }
        int pos = (key & Integer.MAX_VALUE) % this.keys.length;
        while (this.next[pos] >= 0 && this.next[pos] < this.next.length) {
            pos = this.next[pos];
        }
        this.keys[pos] = key;
        this.values[pos] = value;
        if (this.next[pos] < 0) {
            this.next[pos] = (pos + this.step) % this.next.length;
        } else {
            int n = pos;
            this.next[n] = this.next[n] - this.next.length;
        }
        return true;
    }
}

