/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.domain.java.discountsystem;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.loyaltylib.domain.java.observable.DiscountTreeTypeAction;
import su.artix.loyaltylib.domain.java.observable.Named;

public class DiscountCampaign
extends AbstractDiscountModel
implements Serializable,
Named {
    private static final long serialVersionUID = 1L;
    @NotNull
    private Long id;
    @NotNull
    private String name;
    private Date beginDate;
    private Date endDate;
    private List<Discount> discounts = new ArrayList<Discount>();
    private String discountInteraction;
    private Boolean active = true;
    private Boolean manualActivate;
    private String beginTime;
    private Date beginTimeAsDate;
    private String endTime;
    private Date endTimeAsDate;
    private List<Integer> daysOfWeek = new ArrayList<Integer>();
    private Integer daysOfWeekInt;
    private List<List<String>> checkedTags = new ArrayList<List<String>>();
    private boolean tagsIsAllowed = false;
    private int weight;
    private boolean weightNotSet = true;
    private Date beginRangeDate;
    private Date endRangeDate;
    private String beginBonusesIntervalCondition;
    private int beginBonusesIntervalValue;
    private String beginBonusesIntervalMetric;
    private String beginDateWithBeginNextMetric;
    private String beginDateWithBeginCurrentMetric;
    private String beginBonusesDateCalculate;
    private String endBonusesIntervalCondition;
    private int endBonusesIntervalValue = 30;
    private String endBonusesIntervalMetric;
    private String endBonusesDateCalculate;
    private Set<String> labels;
    private Integer priority;
    private Set<String> qualifiers;

    public DiscountCampaign(String name, String discountInteraction) {
        this.name = name;
        this.discountInteraction = discountInteraction;
        this.active = true;
    }

    public DiscountCampaign() {
        this("", "all");
    }

    public DiscountCampaign(String name) {
        this(name, "all");
    }

    public void addDiscount(Discount discount) {
        discount.setParent(this);
        this.discounts.add(discount);
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), null, discount);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long code) {
        if (!ObjectUtils.equals((Object)this.id, (Object)code)) {
            this.id = code;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!StringUtils.equals((CharSequence)this.name, (CharSequence)name)) {
            this.name = name;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        boolean fire = false;
        if (beginDate != null) {
            Date converted = DiscountCampaign.convertFromDateTimeFormatWithTime(beginDate, 0, 0, 0);
            if (!ObjectUtils.equals((Object)this.beginDate, (Object)converted)) {
                this.beginDate = converted;
                fire = true;
            }
        } else if (this.beginDate != null) {
            this.beginDate = null;
            fire = true;
        }
        if (fire) {
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        boolean fire = false;
        if (endDate != null) {
            Date converted = DiscountCampaign.convertFromDateTimeFormatWithTime(endDate, 23, 59, 59);
            if (!ObjectUtils.equals((Object)this.endDate, (Object)converted)) {
                this.endDate = converted;
                fire = true;
            }
        } else if (this.endDate != null) {
            this.endDate = null;
            fire = true;
        }
        if (fire) {
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getDiscountInteraction() {
        return this.discountInteraction;
    }

    public void setDiscountInteraction(String discountInteraction) {
        if (!ObjectUtils.equals((Object)this.discountInteraction, (Object)discountInteraction)) {
            this.discountInteraction = discountInteraction;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public List<Discount> getDiscounts() {
        return this.discounts;
    }

    public String getBeginDateString() {
        if (this.getBeginDate() == null) {
            return "\u041d\u0430\u0447\u0430\u043b\u043e: \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e";
        }
        return "\u041d\u0430\u0447\u0430\u043b\u043e:" + new SimpleDateFormat("dd.MM.yyyy").format(this.getBeginDate());
    }

    public String getEndDateString() {
        if (this.getEndDate() == null) {
            return "\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435: \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e";
        }
        return "\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435:" + new SimpleDateFormat("dd.MM.yyyy").format(this.endDate);
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean activated) {
        if (!ObjectUtils.equals((Object)this.active, (Object)activated)) {
            this.active = activated;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public int isActiveBetween(Calendar begin, Calendar end) {
        Date beginCampaignDate = this.getBeginDate() == null ? new Date(0L) : this.getBeginDate();
        Date endCampaignDate = this.getEndDate() == null ? new Date() : this.getEndDate();
        Integer ret = 0;
        if (begin == null) {
            begin = Calendar.getInstance();
            begin.setTimeInMillis(0L);
        }
        if (end == null) {
            end = Calendar.getInstance();
        }
        Date leftBound = begin.getTime();
        Date rightBound = end.getTime();
        if (endCampaignDate.compareTo(leftBound) < 0) {
            ret = -1;
        } else if (beginCampaignDate.compareTo(rightBound) > 0) {
            ret = 1;
        } else {
            Boolean flag = beginCampaignDate.compareTo(rightBound) <= 0 && endCampaignDate.compareTo(leftBound) >= 0 && beginCampaignDate.compareTo(endCampaignDate) <= 0;
            if (flag.booleanValue()) {
                ret = 0;
            }
        }
        return ret;
    }

    public boolean isActiveAtDate(Calendar calendar) {
        if (this.getBeginDate() == null && this.getEndDate() == null) {
            return true;
        }
        if (this.getBeginDate() != null && this.getEndDate() != null) {
            Calendar begin = Calendar.getInstance();
            begin.setTime(this.getBeginDate());
            Calendar end = Calendar.getInstance();
            end.setTime(this.getEndDate());
            return DateUtils.truncatedCompareTo((Calendar)calendar, (Calendar)begin, (int)5) >= 0 && DateUtils.truncatedCompareTo((Calendar)calendar, (Calendar)end, (int)5) <= 0;
        }
        if (this.getBeginDate() == null) {
            Calendar end = Calendar.getInstance();
            end.setTime(this.getEndDate());
            return DateUtils.truncatedCompareTo((Calendar)calendar, (Calendar)end, (int)5) <= 0;
        }
        Calendar begin = Calendar.getInstance();
        begin.setTime(this.getBeginDate());
        return DateUtils.truncatedCompareTo((Calendar)calendar, (Calendar)begin, (int)5) >= 0;
    }

    public boolean isActiveNow() {
        return this.isActiveAtDate(Calendar.getInstance());
    }

    public void delete(Discount deletedElement) {
        this.discounts.remove(deletedElement);
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), null, deletedElement);
    }

    public void refresh() {
        this.firePropertyChange(DiscountTreeTypeAction.REFRESH.toString(), null, this);
    }

    @Override
    public String getNameTreeNode() {
        return "[" + this.name + "], [" + this.getBeginDateString() + " - " + this.getEndDateString() + "]";
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        if (!ObjectUtils.equals((Object)this.weight, (Object)weight)) {
            this.weight = weight;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public boolean isWeightNotSet() {
        return this.weightNotSet;
    }

    public void setWeightNotSet(boolean weightNotSet) {
        if (!ObjectUtils.equals((Object)this.weightNotSet, (Object)weightNotSet)) {
            this.weightNotSet = weightNotSet;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Date getBeginRangeDate() {
        return this.beginRangeDate;
    }

    public void setBeginRangeDate(Date beginRangeDate) {
        if (!ObjectUtils.equals((Object)this.beginRangeDate, (Object)beginRangeDate)) {
            this.beginRangeDate = beginRangeDate;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Date getEndRangeDate() {
        return this.endRangeDate;
    }

    public void setEndRangeDate(Date endRangeDate) {
        if (!ObjectUtils.equals((Object)this.endRangeDate, (Object)endRangeDate)) {
            this.endRangeDate = endRangeDate;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getBeginBonusesIntervalCondition() {
        return this.beginBonusesIntervalCondition;
    }

    public void setBeginBonusesIntervalCondition(String beginBonusesIntervalCondition) {
        if (!ObjectUtils.equals((Object)this.beginBonusesIntervalCondition, (Object)beginBonusesIntervalCondition)) {
            this.beginBonusesIntervalCondition = beginBonusesIntervalCondition;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public int getBeginBonusesIntervalValue() {
        return this.beginBonusesIntervalValue;
    }

    public void setBeginBonusesIntervalValue(int beginBonusesIntervalValue) {
        if (!ObjectUtils.equals((Object)this.beginBonusesIntervalValue, (Object)beginBonusesIntervalValue)) {
            this.beginBonusesIntervalValue = beginBonusesIntervalValue;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getBeginBonusesIntervalMetric() {
        return this.beginBonusesIntervalMetric;
    }

    public void setBeginBonusesIntervalMetric(String beginBonusesIntervalMetric) {
        if (!ObjectUtils.equals((Object)this.beginBonusesIntervalMetric, (Object)beginBonusesIntervalMetric)) {
            this.beginBonusesIntervalMetric = beginBonusesIntervalMetric;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getEndBonusesIntervalCondition() {
        return this.endBonusesIntervalCondition;
    }

    public void setEndBonusesIntervalCondition(String endBonusesIntervalCondition) {
        if (!ObjectUtils.equals((Object)this.endBonusesIntervalCondition, (Object)endBonusesIntervalCondition)) {
            this.endBonusesIntervalCondition = endBonusesIntervalCondition;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public int getEndBonusesIntervalValue() {
        return this.endBonusesIntervalValue;
    }

    public void setEndBonusesIntervalValue(int endBonusesIntervalValue) {
        if (!ObjectUtils.equals((Object)this.endBonusesIntervalValue, (Object)endBonusesIntervalValue)) {
            this.endBonusesIntervalValue = endBonusesIntervalValue;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getEndBonusesIntervalMetric() {
        return this.endBonusesIntervalMetric;
    }

    public void setEndBonusesIntervalMetric(String endBonusesIntervalMetric) {
        if (!ObjectUtils.equals((Object)this.endBonusesIntervalMetric, (Object)endBonusesIntervalMetric)) {
            this.endBonusesIntervalMetric = endBonusesIntervalMetric;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getBeginDateWithBeginNextMetric() {
        return this.beginDateWithBeginNextMetric;
    }

    public void setBeginDateWithBeginNextMetric(String beginDateWithBeginNextMetric) {
        if (!ObjectUtils.equals((Object)this.beginDateWithBeginNextMetric, (Object)beginDateWithBeginNextMetric)) {
            this.beginDateWithBeginNextMetric = beginDateWithBeginNextMetric;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getBeginDateWithBeginCurrentMetric() {
        return this.beginDateWithBeginCurrentMetric;
    }

    public void setBeginDateWithBeginCurrentMetric(String beginDateWithBeginCurrentMetric) {
        if (!ObjectUtils.equals((Object)this.beginDateWithBeginCurrentMetric, (Object)beginDateWithBeginCurrentMetric)) {
            this.beginDateWithBeginCurrentMetric = beginDateWithBeginCurrentMetric;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getBeginBonusesDateCalculate() {
        return this.beginBonusesDateCalculate;
    }

    public void setBeginBonusesDateCalculate(String beginBonusesDateCalculate) {
        if (!ObjectUtils.equals((Object)this.beginBonusesDateCalculate, (Object)beginBonusesDateCalculate)) {
            this.beginBonusesDateCalculate = beginBonusesDateCalculate;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getEndBonusesDateCalculate() {
        return this.endBonusesDateCalculate;
    }

    public void setEndBonusesDateCalculate(String endBonusesDateCalculate) {
        if (!ObjectUtils.equals((Object)this.endBonusesDateCalculate, (Object)endBonusesDateCalculate)) {
            this.endBonusesDateCalculate = endBonusesDateCalculate;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DiscountCampaign [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", beginDate=");
        builder.append(this.beginDate);
        builder.append(", endDate=");
        builder.append(this.endDate);
        builder.append(", discounts=");
        builder.append(this.discounts);
        builder.append(", discountInteraction=");
        builder.append(this.discountInteraction);
        builder.append(", active=");
        builder.append(this.active);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active == null ? 0 : this.active.hashCode());
        result = 31 * result + (this.beginDate == null ? 0 : this.beginDate.hashCode());
        result = 31 * result + (this.discountInteraction == null ? 0 : this.discountInteraction.hashCode());
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
        result = 31 * result + (this.qualifiers == null ? 0 : this.qualifiers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscountCampaign other = (DiscountCampaign)obj;
        if (this.active == null ? other.active != null : !this.active.equals(other.active)) {
            return false;
        }
        if (this.beginDate == null ? other.beginDate != null : !this.beginDate.equals(other.beginDate)) {
            return false;
        }
        if (this.discountInteraction == null ? other.discountInteraction != null : !this.discountInteraction.equals(other.discountInteraction)) {
            return false;
        }
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
            return false;
        }
        return !(this.qualifiers == null ? other.qualifiers != null : !this.qualifiers.equals(other.qualifiers));
    }

    public static final Date convertFromDateTimeFormatWithTime(Date date, int hours, int minutes, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), hours, minutes, seconds);
        return calendar.getTime();
    }

    public List<List<String>> getCheckedTags() {
        return this.checkedTags;
    }

    public void setCheckedTags(List<List<String>> checkedTags) {
        if (!ObjectUtils.equals(this.checkedTags, checkedTags)) {
            this.checkedTags = checkedTags;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public boolean isTagsIsAllowed() {
        return this.tagsIsAllowed;
    }

    public void setTagsIsAllowed(boolean tagsIsAllowed) {
        if (!ObjectUtils.equals((Object)this.tagsIsAllowed, (Object)tagsIsAllowed)) {
            this.tagsIsAllowed = tagsIsAllowed;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Boolean getManualActivate() {
        return this.manualActivate;
    }

    public void setManualActivate(Boolean manualActivate) {
        if (!ObjectUtils.equals((Object)this.manualActivate, (Object)manualActivate)) {
            this.manualActivate = manualActivate;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(String beginTime) {
        if (!ObjectUtils.equals((Object)this.beginTime, (Object)beginTime)) {
            this.beginTime = beginTime;
            try {
                this.beginTimeAsDate = new SimpleDateFormat("HH:mm").parse(beginTime);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Date getBeginTimeAsDate() {
        return this.beginTimeAsDate;
    }

    public void setBeginTimeAsDate(Date beginTimeAsDate) {
        if (!ObjectUtils.equals((Object)this.beginTimeAsDate, (Object)beginTimeAsDate)) {
            this.beginTimeAsDate = beginTimeAsDate;
            this.beginTime = beginTimeAsDate == null ? null : new SimpleDateFormat("HH:mm").format(beginTimeAsDate);
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        if (!ObjectUtils.equals((Object)this.endTime, (Object)endTime)) {
            this.endTime = endTime;
            try {
                this.endTimeAsDate = new SimpleDateFormat("HH:mm").parse(endTime);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Date getEndTimeAsDate() {
        return this.endTimeAsDate;
    }

    public void setEndTimeAsDate(Date endTimeAsDate) {
        if (!ObjectUtils.equals((Object)this.endTimeAsDate, (Object)endTimeAsDate)) {
            this.endTimeAsDate = endTimeAsDate;
            this.endTime = endTimeAsDate == null ? null : new SimpleDateFormat("HH:mm").format(endTimeAsDate);
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public List<Integer> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(List<Integer> daysOfWeek) {
        if (!ObjectUtils.equals(this.daysOfWeek, daysOfWeek)) {
            this.daysOfWeek = daysOfWeek;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<String> labels) {
        if (!ObjectUtils.equals(this.labels, labels)) {
            this.labels = labels;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Integer getDaysOfWeekInt() {
        return this.daysOfWeekInt;
    }

    public void setDaysOfWeekInt(Integer daysOfWeekInt) {
        this.daysOfWeekInt = daysOfWeekInt;
    }

    public void setPriority(Integer priority) {
        if (!ObjectUtils.equals((Object)this.priority, (Object)priority)) {
            this.priority = priority;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public void setQualifiers(Set<String> qualifiers) {
        if (!ObjectUtils.equals(this.qualifiers, qualifiers)) {
            this.qualifiers = qualifiers;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Set<String> getQualifiers() {
        return this.qualifiers;
    }
}

