/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

class ClassWriter {
    int verbose;
    Package pkg;
    Package.Class cls;
    DataOutputStream out;
    ConstantPool.Index cpIndex;
    ConstantPool.Index bsmIndex;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    DataOutputStream bufOut = new DataOutputStream(this.buf);

    ClassWriter(Package.Class clazz, OutputStream outputStream) throws IOException {
        this.pkg = clazz.getPackage();
        this.cls = clazz;
        this.verbose = this.pkg.verbose;
        this.out = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.cpIndex = ConstantPool.makeIndex(clazz.toString(), clazz.getCPMap());
        this.cpIndex.flattenSigs = true;
        if (clazz.hasBootstrapMethods()) {
            this.bsmIndex = ConstantPool.makeIndex(this.cpIndex.debugName + ".BootstrapMethods", clazz.getBootstrapMethodMap());
        }
        if (this.verbose > 1) {
            Utils.log.fine("local CP=" + (this.verbose > 2 ? this.cpIndex.dumpString() : this.cpIndex.toString()));
        }
    }

    private void writeShort(int n) throws IOException {
        this.out.writeShort(n);
    }

    private void writeInt(int n) throws IOException {
        this.out.writeInt(n);
    }

    private void writeRef(ConstantPool.Entry entry) throws IOException {
        this.writeRef(entry, this.cpIndex);
    }

    private void writeRef(ConstantPool.Entry entry, ConstantPool.Index index) throws IOException {
        int n = entry == null ? 0 : index.indexOf(entry);
        this.writeShort(n);
    }

    void write() throws IOException {
        boolean bl = false;
        try {
            if (this.verbose > 1) {
                Utils.log.fine("...writing " + this.cls);
            }
            this.writeMagicNumbers();
            this.writeConstantPool();
            this.writeHeader();
            this.writeMembers(false);
            this.writeMembers(true);
            this.writeAttributes(0, this.cls);
            this.out.flush();
            bl = true;
        }
        finally {
            if (!bl) {
                Utils.log.warning("Error on output of " + this.cls);
            }
        }
    }

    void writeMagicNumbers() throws IOException {
        this.writeInt(this.cls.magic);
        this.writeShort(this.cls.version.minor);
        this.writeShort(this.cls.version.major);
    }

    void writeConstantPool() throws IOException {
        ConstantPool.Entry[] entryArray = this.cls.cpMap;
        this.writeShort(entryArray.length);
        block13: for (int i = 0; i < entryArray.length; ++i) {
            ConstantPool.Entry entry = entryArray[i];
            assert (entry == null == (i == 0 || entryArray[i - 1] != null && entryArray[i - 1].isDoubleWord()));
            if (entry == null) continue;
            byte by = entry.getTag();
            if (this.verbose > 2) {
                Utils.log.fine("   CP[" + i + "] = " + entry);
            }
            this.out.write(by);
            switch (by) {
                case 13: {
                    throw new AssertionError((Object)"CP should have Signatures remapped to Utf8");
                }
                case 1: {
                    this.out.writeUTF(entry.stringValue());
                    continue block13;
                }
                case 3: {
                    this.out.writeInt(((ConstantPool.NumberEntry)entry).numberValue().intValue());
                    continue block13;
                }
                case 4: {
                    float f = ((ConstantPool.NumberEntry)entry).numberValue().floatValue();
                    this.out.writeInt(Float.floatToRawIntBits(f));
                    continue block13;
                }
                case 5: {
                    this.out.writeLong(((ConstantPool.NumberEntry)entry).numberValue().longValue());
                    continue block13;
                }
                case 6: {
                    double d = ((ConstantPool.NumberEntry)entry).numberValue().doubleValue();
                    this.out.writeLong(Double.doubleToRawLongBits(d));
                    continue block13;
                }
                case 7: 
                case 8: 
                case 16: {
                    this.writeRef(entry.getRef(0));
                    continue block13;
                }
                case 15: {
                    ConstantPool.MethodHandleEntry methodHandleEntry = (ConstantPool.MethodHandleEntry)entry;
                    this.out.writeByte(methodHandleEntry.refKind);
                    this.writeRef(methodHandleEntry.getRef(0));
                    continue block13;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.writeRef(entry.getRef(0));
                    this.writeRef(entry.getRef(1));
                    continue block13;
                }
                case 18: {
                    this.writeRef(entry.getRef(0), this.bsmIndex);
                    this.writeRef(entry.getRef(1));
                    continue block13;
                }
                case 17: {
                    throw new AssertionError((Object)"CP should have BootstrapMethods moved to side-table");
                }
                default: {
                    throw new IOException("Bad constant pool tag " + by);
                }
            }
        }
    }

    void writeHeader() throws IOException {
        this.writeShort(this.cls.flags);
        this.writeRef(this.cls.thisClass);
        this.writeRef(this.cls.superClass);
        this.writeShort(this.cls.interfaces.length);
        for (int i = 0; i < this.cls.interfaces.length; ++i) {
            this.writeRef(this.cls.interfaces[i]);
        }
    }

    void writeMembers(boolean bl) throws IOException {
        List<Package.Class.Member> list = !bl ? this.cls.getFields() : this.cls.getMethods();
        this.writeShort(list.size());
        for (Package.Class.Member member : list) {
            this.writeMember(member, bl);
        }
    }

    void writeMember(Package.Class.Member member, boolean bl) throws IOException {
        if (this.verbose > 2) {
            Utils.log.fine("writeMember " + member);
        }
        this.writeShort(member.flags);
        this.writeRef(member.getDescriptor().nameRef);
        this.writeRef(member.getDescriptor().typeRef);
        this.writeAttributes(!bl ? 1 : 2, member);
    }

    private void reorderBSMandICS(Attribute.Holder holder) {
        int n;
        Attribute attribute = holder.getAttribute(Package.attrBootstrapMethodsEmpty);
        if (attribute == null) {
            return;
        }
        Attribute attribute2 = holder.getAttribute(Package.attrInnerClassesEmpty);
        if (attribute2 == null) {
            return;
        }
        int n2 = holder.attributes.indexOf(attribute);
        if (n2 > (n = holder.attributes.indexOf(attribute2))) {
            holder.attributes.remove(attribute);
            holder.attributes.add(n, attribute);
        }
    }

    void writeAttributes(int n, Attribute.Holder holder) throws IOException {
        if (holder.attributes == null) {
            this.writeShort(0);
            return;
        }
        if (holder instanceof Package.Class) {
            this.reorderBSMandICS(holder);
        }
        this.writeShort(holder.attributes.size());
        for (Attribute attribute : holder.attributes) {
            attribute.finishRefs(this.cpIndex);
            this.writeRef(attribute.getNameRef());
            if (attribute.layout() == Package.attrCodeEmpty || attribute.layout() == Package.attrBootstrapMethodsEmpty || attribute.layout() == Package.attrInnerClassesEmpty) {
                DataOutputStream dataOutputStream = this.out;
                assert (this.out != this.bufOut);
                this.buf.reset();
                this.out = this.bufOut;
                if ("Code".equals(attribute.name())) {
                    Package.Class.Method method = (Package.Class.Method)holder;
                    this.writeCode(method.code);
                } else if ("BootstrapMethods".equals(attribute.name())) {
                    assert (holder == this.cls);
                    this.writeBootstrapMethods(this.cls);
                } else if ("InnerClasses".equals(attribute.name())) {
                    assert (holder == this.cls);
                    this.writeInnerClasses(this.cls);
                } else {
                    throw new AssertionError();
                }
                this.out = dataOutputStream;
                if (this.verbose > 2) {
                    Utils.log.fine("Attribute " + attribute.name() + " [" + this.buf.size() + "]");
                }
                this.writeInt(this.buf.size());
                this.buf.writeTo(this.out);
                continue;
            }
            if (this.verbose > 2) {
                Utils.log.fine("Attribute " + attribute.name() + " [" + attribute.size() + "]");
            }
            this.writeInt(attribute.size());
            this.out.write(attribute.bytes());
        }
    }

    void writeCode(Code code) throws IOException {
        code.finishRefs(this.cpIndex);
        this.writeShort(code.max_stack);
        this.writeShort(code.max_locals);
        this.writeInt(code.bytes.length);
        this.out.write(code.bytes);
        int n = code.getHandlerCount();
        this.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.writeShort(code.handler_start[i]);
            this.writeShort(code.handler_end[i]);
            this.writeShort(code.handler_catch[i]);
            this.writeRef(code.handler_class[i]);
        }
        this.writeAttributes(3, code);
    }

    void writeBootstrapMethods(Package.Class clazz) throws IOException {
        List<ConstantPool.BootstrapMethodEntry> list = clazz.getBootstrapMethods();
        this.writeShort(list.size());
        for (ConstantPool.BootstrapMethodEntry bootstrapMethodEntry : list) {
            this.writeRef(bootstrapMethodEntry.bsmRef);
            this.writeShort(bootstrapMethodEntry.argRefs.length);
            for (ConstantPool.Entry entry : bootstrapMethodEntry.argRefs) {
                this.writeRef(entry);
            }
        }
    }

    void writeInnerClasses(Package.Class clazz) throws IOException {
        List<Package.InnerClass> list = clazz.getInnerClasses();
        this.writeShort(list.size());
        for (Package.InnerClass innerClass : list) {
            this.writeRef(innerClass.thisClass);
            this.writeRef(innerClass.outerClass);
            this.writeRef(innerClass.name);
            this.writeShort(innerClass.flags);
        }
    }
}

