/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.utils.JaxbUtil;
import ru.ssa.cashadmin.domain.utils.RefreshUtil;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.view.XMLFileDialog;

public class DirectoryExportAllAction<E>
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String ID = "ru.ssa.artixadmin.action.DirectoryExportAllAction";
    private static final Logger log = LoggerFactory.getLogger(DirectoryExportAllAction.class);
    private static final int MAX_COUNT = 1000;
    private final Class<E> cl;

    public DirectoryExportAllAction(Class<E> cl) {
        super("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u0444\u0430\u0439\u043b");
        this.setId(ID);
        this.cl = cl;
        ArtixAdminImages images = ArtixAdminImages.getDefault();
        this.setImageDescriptor(images.getImageDescriptor("plane/16x16/export"));
        this.setToolTipText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u0444\u0430\u0439\u043b");
        this.setEnabled(true);
    }

    public void run() {
        Long count = ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.cl).getItemCount(null);
        if (count > 1000L) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", (String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u044d\u043a\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435 1000 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.");
        } else {
            String xmlFileName = new XMLFileDialog(8192).open();
            if (xmlFileName != null) {
                GuiActivator.getDefault().setLoadCursor(true);
                try {
                    SessionManager.openSession(this.cl);
                    List selection = ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.cl).getList();
                    ArrayList<Object> collection = new ArrayList<Object>();
                    for (Object object : selection) {
                        Object e = RefreshUtil.refresh(object);
                        collection.add(e);
                    }
                    DomainCollections domainCollections = new DomainCollections(collection);
                    JaxbUtil.INSTANCE.exportToXML(xmlFileName, domainCollections);
                    SessionManager.closeSession(this.cl);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                GuiActivator.getDefault().setLoadCursor(false);
            }
        }
    }

    public void dispose() {
    }
}

