/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.cashserver.security.SecurityAction;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.ModelActivator;

public class DirectorySelectRemoveAction<E>
extends Action
implements ISelectionChangedListener,
SecurityAction {
    public static final String ID = "ru.ssa.artixadmin.action.DirectorySelectRemoveAction";
    private static final Logger log = LoggerFactory.getLogger(DirectorySelectRemoveAction.class);
    private static final String PLUGIN_ID = "yuki.directory.gui";
    private boolean securityEnabled = true;
    private IStructuredSelection structuredSelection;
    private Class<E> clazz;

    public DirectorySelectRemoveAction(Class<E> cl) {
        super("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        this.clazz = cl;
        this.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/delete"));
        this.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        this.setEnabled(false);
        this.setId(ID);
    }

    public void run() {
        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435...", (String)"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442?")) {
            for (Object obj : this.structuredSelection.toList()) {
                try {
                    ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz).doRemove(obj);
                }
                catch (ExecuteQueryException e) {
                    log.error("Couldn't remove.", (Throwable)e);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c.", (String)("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c." + e.getMessage()), (IStatus)new Status(4, PLUGIN_ID, "Error", (Throwable)e));
                }
            }
            ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz).doRefresh();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            this.structuredSelection = (IStructuredSelection)event.getSelection();
            this.setEnabled(this.securityEnabled && this.structuredSelection.size() >= 1 && (this.structuredSelection.getFirstElement().getClass() == this.clazz || this.clazz.isAssignableFrom(this.structuredSelection.getFirstElement().getClass())));
        } else {
            this.setEnabled(false);
        }
    }

    public void setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }
}

