/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.utils.FilterRestriction;
import su.artix.artixadmin.format.ArtixFormatter;
import su.artix.yuki.converter.IntegerToKeyValueConverter;
import su.artix.yuki.converter.KeyValueToIntegerConverter;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.DirectoryLabelProvider;

public class DirectoryFilterDialog
extends Dialog {
    private static final Logger log = LoggerFactory.getLogger(DirectoryFilterDialog.class);
    private FilterRestriction modelRestrictions;
    private DataBindingContext bindingContext;
    private Text inputField;
    private ComboViewer logicComboViewer;
    private Button okButton;
    private Button cancelButton;
    private final Class clazz;
    private static final int WIDTH = 300;
    private static final int HEIGHT = 250;

    protected DirectoryFilterDialog(Shell parentShell, Class clazz) {
        super(parentShell);
        this.setShellStyle(65616);
        this.clazz = clazz;
        this.bindingContext = new DataBindingContext();
    }

    protected Control createDialogArea(Composite parent) {
        String title = "";
        switch (this.modelRestrictions.getOpType()) {
            case eq: {
                title = "";
                break;
            }
            case gt: {
                title = ">";
                break;
            }
            case ge: {
                title = ">";
                break;
            }
            case le: {
                title = "<";
                break;
            }
            case like: {
                title = "\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442";
                break;
            }
            case lt: {
                title = "<";
                break;
            }
            case ne: {
                title = "!";
                break;
            }
            case like_end: {
                title = "\u0417\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f";
                break;
            }
            case like_start: {
                title = "\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f";
                break;
            }
            case in: {
                title = "in";
                break;
            }
        }
        parent.setSize(300, 250);
        GridLayout gridLayout = new GridLayout(2, false);
        Label inputFieldLabel = new Label(parent, 0);
        inputFieldLabel.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        this.inputField = new Text(parent, 2048);
        GridData gridData = new GridData(4, 0, false, false);
        gridData.horizontalSpan = 2;
        this.inputField.setLayoutData((Object)gridData);
        this.logicComboViewer = new ComboViewer(parent, 8);
        this.logicComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.logicComboViewer.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
        this.logicComboViewer.setInput((Object)Directory.directoryFilterLogic);
        gridData = new GridData(4, 0, false, false);
        gridData.horizontalSpan = 2;
        this.logicComboViewer.getCombo().setLayoutData((Object)gridData);
        parent.setLayout((Layout)gridLayout);
        this.getShell().setText("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0444\u0438\u043b\u044c\u0442\u0440\u0430:" + title);
        return parent;
    }

    public void bindValues() {
        Object object = null;
        IObservableValue observableValue = null;
        if (this.modelRestrictions.getState() == null) {
            Constructor<?>[] constructors;
            Constructor<?>[] constructorArray = constructors = this.clazz.getConstructors();
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                Type[] types = constructor.getGenericParameterTypes();
                try {
                    if (types.length == 0) {
                        object = constructor.newInstance(new Object[0]);
                    } else if (types.length == 1) {
                        if (types[0].equals(Integer.class)) {
                            object = constructor.newInstance(0);
                        } else if (types[0].equals(String.class)) {
                            object = constructor.newInstance("0");
                        }
                    }
                }
                catch (Exception e) {
                    log.trace(e.getMessage());
                }
                ++n2;
            }
            this.modelRestrictions.setState(object);
        }
        IObservableValue inputValue = PojoObservables.observeValue((Object)this.modelRestrictions, (String)"state");
        String subPropertyName = null;
        String propertyName = this.modelRestrictions.getProperty();
        int index = propertyName.indexOf(46);
        if (index != -1) {
            subPropertyName = propertyName.substring(index + 1);
        }
        final String searchField = subPropertyName;
        if (subPropertyName != null) {
            try {
                IObservableFactory factory = new IObservableFactory(){

                    public IObservable createObservable(Object target) {
                        return PojoObservables.observeValue((Object)target, (String)searchField);
                    }
                };
                observableValue = MasterDetailObservables.detailValue((IObservableValue)inputValue, (IObservableFactory)factory, null);
            }
            catch (Exception e) {
                observableValue = null;
                log.trace(e.getLocalizedMessage());
            }
        }
        if (observableValue == null) {
            observableValue = inputValue;
        }
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeText((Control)this.inputField, (int)24), observableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(new IConverter(){

            public Object getToType() {
                return DirectoryFilterDialog.this.modelRestrictions.getClass();
            }

            public Object getFromType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                Object o = ((String)fromObject).trim();
                Class<?> clazz = DirectoryFilterDialog.this.modelRestrictions.getState().getClass();
                if (!clazz.equals(String.class)) {
                    if (DirectoryFilterDialog.this.modelRestrictions.getState() instanceof java.util.Date) {
                        if (clazz.equals(Timestamp.class)) {
                            o = ArtixFormatter.INSTANCE.stringToTimestamp((String)fromObject);
                        } else if (clazz.equals(Date.class)) {
                            o = ArtixFormatter.INSTANCE.stringToDate((String)fromObject);
                        } else if (clazz.equals(Time.class)) {
                            o = ArtixFormatter.INSTANCE.stringToTime((String)fromObject);
                        } else if (clazz.equals(java.util.Date.class)) {
                            o = ArtixFormatter.INSTANCE.stringToDate((String)fromObject);
                        }
                        if (o == null) {
                            o = DirectoryFilterDialog.this.modelRestrictions.getState();
                        }
                    } else {
                        Constructor<?> constructor = null;
                        try {
                            constructor = clazz.getDeclaredConstructor(String.class);
                            o = constructor.newInstance(fromObject);
                            DirectoryFilterDialog.this.okButton.setEnabled(true);
                        }
                        catch (Exception e) {
                            log.trace("Filter can't convert from String to " + clazz.getCanonicalName() + e.getMessage());
                            DirectoryFilterDialog.this.inputField.setEnabled(true);
                            DirectoryFilterDialog.this.okButton.setEnabled(true);
                            return fromObject;
                        }
                    }
                }
                return o;
            }
        }), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return Object.class;
            }

            public Object convert(Object fromObject) {
                Class<?> clazz = DirectoryFilterDialog.this.modelRestrictions.getState().getClass();
                String result = String.valueOf(fromObject);
                if (DirectoryFilterDialog.this.modelRestrictions.getState() instanceof java.util.Date) {
                    if (clazz.equals(Date.class) || clazz.equals(java.util.Date.class)) {
                        result = ArtixFormatter.INSTANCE.dateToString((java.util.Date)fromObject);
                    } else if (clazz.equals(Time.class)) {
                        result = ArtixFormatter.INSTANCE.timeToString((java.util.Date)fromObject);
                    } else if (clazz.equals(Timestamp.class)) {
                        result = ArtixFormatter.INSTANCE.timestampToString((java.util.Date)fromObject);
                    }
                }
                return result;
            }
        }));
        this.getBindingContext().bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.logicComboViewer), PojoObservables.observeValue((Object)this.modelRestrictions, (String)"linkConditionCode"), new UpdateValueStrategy().setConverter((IConverter)new KeyValueToIntegerConverter()), new UpdateValueStrategy().setConverter((IConverter)new IntegerToKeyValueConverter()));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        log.trace("");
        this.okButton = this.createUserButton(parent, 0, "Ok", true);
        this.okButton.setFocus();
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DirectoryFilterDialog.this.doFilter();
            }
        });
        this.cancelButton = this.createUserButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryFilterDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
    }

    public void create() {
        super.create();
        this.bindValues();
    }

    protected void doFilter() {
        this.setReturnCode(0);
        this.close();
    }

    private Button createUserButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        ((GridData)parent.getLayoutData()).horizontalSpan = 2;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    public void setBindingContext(DataBindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void setFilterRestriction(FilterRestriction filterRestriction) {
        this.modelRestrictions = filterRestriction;
    }

    public FilterRestriction getFilterRestriction() {
        return this.modelRestrictions;
    }
}

