/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.calculator;

import org.mihalis.opal.calculator.CalculatorButtonsComposite;
import org.mihalis.opal.calculator.DivideByZeroException;
import org.mihalis.opal.utils.ResourceManager;

class CalculatorEngine {
    static final String OPERATOR_PLUS = "+";
    static final String OPERATOR_MINUS = "-";
    static final String OPERATOR_MULTIPLY = "*";
    static final String OPERATOR_DIVIDE = "/";
    static final String CHARACTER_ZERO = "0";
    static final String DOT_CHARACTER = ".";
    static final String EMPTY_STRING = "";
    private DISPLAY_MODE displayMode;
    private boolean clearOnNextDigit;
    private double lastNumber;
    private String lastOperator;
    private final CalculatorButtonsComposite composite;

    CalculatorEngine(CalculatorButtonsComposite calculatorButtonsComposite) {
        this.composite = calculatorButtonsComposite;
    }

    void addDecimalPoint() {
        String string;
        this.displayMode = DISPLAY_MODE.INPUT;
        if (this.clearOnNextDigit) {
            this.setDisplayString(EMPTY_STRING);
        }
        if ((string = this.getDisplayString()).indexOf(DOT_CHARACTER) < 0) {
            this.setDisplayString(string + DOT_CHARACTER);
        }
    }

    private void setDisplayString(String string) {
        this.composite.getDisplayArea().setText(string);
        this.composite.fireModifyListeners();
    }

    void addDigitToDisplay(int n) {
        String string;
        if (this.clearOnNextDigit) {
            this.setDisplayString(EMPTY_STRING);
        }
        if ((string = this.getDisplayString()).indexOf(CHARACTER_ZERO) == 0) {
            string = string.substring(1);
        }
        if (!string.equals(CHARACTER_ZERO) || n > 0) {
            this.setDisplayString(string + n);
        }
        this.displayMode = DISPLAY_MODE.INPUT;
        this.clearOnNextDigit = false;
    }

    void clearWholeContent() {
        this.setDisplayString(CHARACTER_ZERO);
        this.lastOperator = CHARACTER_ZERO;
        this.lastNumber = 0.0;
        this.displayMode = DISPLAY_MODE.INPUT;
        this.clearOnNextDigit = true;
    }

    void clearResult() {
        this.setDisplayString(CHARACTER_ZERO);
        this.clearOnNextDigit = true;
        this.displayMode = DISPLAY_MODE.INPUT;
    }

    void processBackSpace() {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            this.setDisplayString(this.getDisplayString().substring(0, this.getDisplayString().length() - 1));
            if (this.getDisplayString().length() < 1) {
                this.setDisplayString(CHARACTER_ZERO);
            }
        }
    }

    private String getDisplayString() {
        return this.composite.getDisplayArea().getText();
    }

    void processEquals() {
        double d = 0.0;
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            try {
                d = this.processLastOperator();
                this.displayResult(d);
            }
            catch (DivideByZeroException divideByZeroException) {
                this.displayErrorMessage("calculator.dividebyzero");
            }
            this.lastOperator = CHARACTER_ZERO;
        }
    }

    private double processLastOperator() throws DivideByZeroException {
        double d = 0.0;
        double d2 = this.getDisplayedNumber();
        if (this.lastOperator.equals(OPERATOR_DIVIDE)) {
            if (d2 == 0.0) {
                throw new DivideByZeroException();
            }
            d = this.lastNumber / d2;
        }
        if (this.lastOperator.equals(OPERATOR_MULTIPLY)) {
            d = this.lastNumber * d2;
        }
        if (this.lastOperator.equals(OPERATOR_MINUS)) {
            d = this.lastNumber - d2;
        }
        if (this.lastOperator.equals(OPERATOR_PLUS)) {
            d = this.lastNumber + d2;
        }
        return d;
    }

    private void displayResult(double d) {
        if (Math.floor(d) == d) {
            this.setDisplayString(Integer.toString((int)d));
        } else {
            this.setDisplayString(Double.toString(d));
        }
        this.lastNumber = d;
        this.displayMode = DISPLAY_MODE.RESULT;
        this.clearOnNextDigit = true;
    }

    private void displayErrorMessage(String string) {
        this.setDisplayString(ResourceManager.getLabel(string));
        this.lastNumber = 0.0;
        this.displayMode = DISPLAY_MODE.ERROR;
        this.clearOnNextDigit = true;
    }

    void processInverseOperation() {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            try {
                if (this.getDisplayedNumber() == 0.0) {
                    this.displayErrorMessage("calculator.dividebyzero");
                    return;
                }
                double d = 1.0 / this.getDisplayedNumber();
                this.displayResult(d);
            }
            catch (Exception exception) {
                this.displayErrorMessage("calculator.dividebyzero");
                this.displayMode = DISPLAY_MODE.ERROR;
            }
        }
    }

    private double getDisplayedNumber() {
        String string = this.getDisplayString();
        return Double.parseDouble(string);
    }

    void processOperation(String string) {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            double d = this.getDisplayedNumber();
            if (this.lastOperator != null && !this.lastOperator.equals(CHARACTER_ZERO)) {
                try {
                    double d2 = this.processLastOperator();
                    this.displayResult(d2);
                    this.lastNumber = d2;
                }
                catch (DivideByZeroException divideByZeroException) {}
            } else {
                this.lastNumber = d;
            }
            this.clearOnNextDigit = true;
            this.lastOperator = string;
        }
    }

    void processPerCentageOperation() {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            try {
                double d = this.getDisplayedNumber() / 100.0;
                this.displayResult(d);
            }
            catch (Exception exception) {
                this.displayErrorMessage("calculator.invalid");
                this.displayMode = DISPLAY_MODE.ERROR;
            }
        }
    }

    void processSignChange() {
        double d;
        if (this.displayMode == DISPLAY_MODE.INPUT) {
            String string = this.getDisplayString();
            if (string.length() > 0 && !string.equals(CHARACTER_ZERO)) {
                if (string.indexOf(OPERATOR_MINUS) == 0) {
                    this.setDisplayString(string.substring(1));
                } else {
                    this.setDisplayString(OPERATOR_MINUS + string);
                }
            }
        } else if (this.displayMode == DISPLAY_MODE.RESULT && (d = this.getDisplayedNumber()) != 0.0) {
            this.displayResult(-d);
        }
    }

    void processSquareRootOperation() {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            try {
                if (this.getDisplayString().indexOf(OPERATOR_MINUS) == 0) {
                    this.displayErrorMessage("calculator.invalid");
                }
                double d = Math.sqrt(this.getDisplayedNumber());
                this.displayResult(d);
            }
            catch (Exception exception) {
                this.displayErrorMessage("calculator.invalid");
                this.displayMode = DISPLAY_MODE.ERROR;
            }
        }
    }

    private static enum DISPLAY_MODE {
        INPUT,
        RESULT,
        ERROR;

    }
}

