/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.systemMonitor;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.mihalis.opal.systemMonitor.Sample;

public class PhysicalMemorySample
implements Sample {
    private static final String TOTAL_PHYSICAL_MEMORY_SIZE = "TotalPhysicalMemorySize";
    private static final String FREE_PHYSICAL_MEMORY_SIZE = "FreePhysicalMemorySize";
    private static final String OBJECT_NAME_ATTRIBUTE = "java.lang:type=OperatingSystem";
    private final MBeanServerConnection mBeanServerConnection = ManagementFactory.getPlatformMBeanServer();
    private ObjectName objectName;

    PhysicalMemorySample() {
        try {
            this.objectName = new ObjectName(OBJECT_NAME_ATTRIBUTE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double getValue() {
        try {
            double d = (double)((Long)this.mBeanServerConnection.getAttribute(this.objectName, FREE_PHYSICAL_MEMORY_SIZE)).longValue() / 1024.0 / 1024.0;
            return this.getMaxValue() - d;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double getMaxValue() {
        try {
            return (double)((Long)this.mBeanServerConnection.getAttribute(this.objectName, TOTAL_PHYSICAL_MEMORY_SIZE)).longValue() / 1024.0 / 1024.0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

