/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.tipOfTheDay;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.header.Header;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class TipOfTheDay {
    private static final String BLUE_LIGHT_BULB = "images/light1.png";
    private static final String YELLOW_LIGHT_BULB = "images/light2.png";
    private static final String DEFAULT_FONT = "Arial";
    private final List<String> tips = new ArrayList<String>();
    private boolean displayShowOnStartup = true;
    private boolean showOnStartup = true;
    private Shell shell;
    private Button close;
    private int index = -1;
    private Browser tipArea;
    private String fontName;
    private TipStyle style;
    private Image image;

    public TipOfTheDay() {
        Font font = Display.getDefault().getSystemFont();
        FontData[] fontDataArray = font.getFontData();
        this.fontName = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0].getName() : DEFAULT_FONT;
        this.style = TipStyle.TWO_COLUMNS;
    }

    public void open(Shell shell) {
        if (this.index == -1) {
            this.index = new Random().nextInt(this.tips.size());
        }
        this.buildShell(shell);
        if (this.style == TipStyle.HEADER) {
            this.buildHeader();
        } else {
            this.buildLeftColumn();
        }
        this.buildTip();
        this.buildButtons();
        this.openShell();
    }

    private void buildShell(Shell shell) {
        this.shell = new Shell(shell, 133232);
        this.shell.setText(ResourceManager.getLabel("tipOfTheDay"));
        this.shell.setLayout((Layout)new GridLayout(this.style == TipStyle.HEADER ? 1 : 2, false));
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        TipOfTheDay.this.shell.dispose();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
    }

    private void buildHeader() {
        Header header = new Header((Composite)this.shell, 0);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.heightHint = 80;
        header.setLayoutData(gridData);
        header.setTitle(ResourceManager.getLabel("didYouKnow"));
        if (this.image == null) {
            Image image = SWTGraphicUtil.createImageFromFile(YELLOW_LIGHT_BULB);
            header.setImage(image);
            SWTGraphicUtil.addDisposer((Widget)this.shell, (Resource)image);
        } else {
            header.setImage(this.image);
        }
    }

    private void buildLeftColumn() {
        Composite composite = new Composite((Composite)this.shell, 0);
        int n = 1;
        if (this.style == TipStyle.TWO_COLUMNS_LARGE) {
            n = this.displayShowOnStartup ? 5 : 4;
        }
        GridData gridData = new GridData(4, 1, false, true, 1, n);
        composite.setLayoutData((Object)gridData);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 2;
        composite.setLayout((Layout)fillLayout);
        Label label = new Label(composite, 0);
        if (this.image == null) {
            Image image = SWTGraphicUtil.createImageFromFile(BLUE_LIGHT_BULB);
            label.setImage(image);
            SWTGraphicUtil.addDisposer((Widget)this.shell, (Resource)image);
        } else {
            label.setImage(this.image);
        }
    }

    private void buildTip() {
        if (this.style == TipStyle.TWO_COLUMNS) {
            Group group = new Group((Composite)this.shell, 0);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = 300;
            gridData.heightHint = 120;
            group.setLayoutData((Object)gridData);
            group.setText(ResourceManager.getLabel("didYouKnow"));
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginWidth = 15;
            group.setLayout((Layout)fillLayout);
            this.tipArea = new Browser((Composite)group, 2048);
        } else if (this.style == TipStyle.TWO_COLUMNS_LARGE) {
            Label label = new Label((Composite)this.shell, 0);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.verticalIndent = 15;
            label.setLayoutData((Object)gridData);
            Font font = SWTGraphicUtil.buildFontFrom((Control)label, 1, 16);
            label.setText(ResourceManager.getLabel("tipOfTheDay"));
            label.setFont(font);
            SWTGraphicUtil.addDisposer((Widget)this.shell, (Resource)font);
            Label label2 = new Label((Composite)this.shell, 258);
            label2.setLayoutData((Object)new GridData(4, 4, true, false));
            this.tipArea = new Browser((Composite)this.shell, 2048);
            GridData gridData2 = new GridData(4, 4, true, true);
            gridData2.heightHint = 120;
            this.tipArea.setLayoutData((Object)gridData2);
        } else {
            this.tipArea = new Browser((Composite)this.shell, 2048);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.heightHint = 120;
            this.tipArea.setLayoutData((Object)gridData);
        }
        this.fillTipArea();
    }

    private void fillTipArea() {
        this.tipArea.setText("<html><body bgcolor=\"#ffffff\" text=\"#000000\"><p style=\"font-family:" + this.fontName + ";font-size=12px\">" + this.tips.get(this.index) + "</p></body></html>");
    }

    private void buildButtons() {
        GridData gridData;
        GridData gridData2;
        GridData gridData3;
        GridData gridData4;
        Composite composite = new Composite((Composite)this.shell, 0);
        int n = this.style == TipStyle.HEADER ? 1 : (this.style == TipStyle.TWO_COLUMNS ? 2 : 1);
        GridData gridData5 = new GridData(4, 1, false, false, n, 1);
        composite.setLayoutData((Object)gridData5);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 2;
        if (this.style == TipStyle.TWO_COLUMNS_LARGE) {
            composite.setLayout((Layout)new GridLayout(3, false));
        } else {
            composite.setLayout((Layout)new GridLayout(this.displayShowOnStartup ? 4 : 3, false));
        }
        if (this.style == TipStyle.TWO_COLUMNS_LARGE) {
            gridData4 = new GridData(1, 1, true, false, 3, 1);
            gridData3 = new GridData(3, 2, true, false);
            gridData3.widthHint = 120;
            gridData2 = new GridData(2, 2, false, false);
            gridData2.widthHint = 120;
            gridData = new GridData(1, 2, true, false);
            gridData.widthHint = 120;
        } else {
            gridData4 = new GridData(1, 2, true, false);
            gridData3 = new GridData(3, 2, !this.showOnStartup, false);
            gridData3.widthHint = 120;
            gridData2 = new GridData(4, 2, false, false);
            gridData2.widthHint = 120;
            gridData = new GridData(4, 2, false, false);
            gridData.widthHint = 120;
        }
        if (this.displayShowOnStartup) {
            this.buildShowOnStartup(composite, gridData4);
        }
        this.buildPreviousButton(composite, gridData3);
        this.buildNextButton(composite, gridData2);
        this.buildCloseButton(composite, gridData);
    }

    private void buildShowOnStartup(Composite composite, GridData gridData) {
        final Button button = new Button(composite, 32);
        button.setLayoutData((Object)gridData);
        button.setText(ResourceManager.getLabel("showTipAtStartup"));
        button.setSelection(this.showOnStartup);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TipOfTheDay.this.showOnStartup = button.getSelection();
            }
        });
    }

    private void buildPreviousButton(Composite composite, GridData gridData) {
        Button button = new Button(composite, 8);
        button.setText(ResourceManager.getLabel("previousTip"));
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TipOfTheDay.this.index == 0) {
                    TipOfTheDay.this.setIndex(TipOfTheDay.this.tips.size() - 1);
                } else {
                    TipOfTheDay.this.setIndex(TipOfTheDay.this.index - 1);
                }
            }
        });
    }

    private void buildNextButton(Composite composite, GridData gridData) {
        Button button = new Button(composite, 8);
        button.setText(ResourceManager.getLabel("nextTip"));
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TipOfTheDay.this.index == TipOfTheDay.this.tips.size() - 1) {
                    TipOfTheDay.this.setIndex(0);
                } else {
                    TipOfTheDay.this.setIndex(TipOfTheDay.this.index + 1);
                }
            }
        });
    }

    private void buildCloseButton(Composite composite, GridData gridData) {
        this.close = new Button(composite, 8);
        this.close.setText(ResourceManager.getLabel("Close"));
        this.close.setLayoutData((Object)gridData);
        this.close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TipOfTheDay.this.shell.dispose();
            }
        });
    }

    private void openShell() {
        this.shell.setDefaultButton(this.close);
        this.shell.pack();
        this.shell.open();
        SWTGraphicUtil.centerShell(this.shell);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public TipOfTheDay addTip(String string) {
        this.tips.add(string);
        return this;
    }

    public Image getImage() {
        return this.image;
    }

    public int getIndex() {
        return this.index;
    }

    public TipStyle getStyle() {
        return this.style;
    }

    public List<String> getTips() {
        return this.tips;
    }

    public boolean isDisplayShowOnStartup() {
        return this.displayShowOnStartup;
    }

    public boolean isShowOnStartup() {
        return this.showOnStartup;
    }

    public void setDisplayShowOnStartup(boolean bl) {
        this.displayShowOnStartup = bl;
    }

    public void setIndex(int n) {
        if (n < 0 || n >= this.tips.size() || this.tips.get(n) == null) {
            throw new IllegalArgumentException("Index should be between 0 and " + (this.tips.size() - 1) + " (entered value:" + n + ")");
        }
        this.index = n;
        if (this.tipArea != null && !this.tipArea.isDisposed()) {
            this.fillTipArea();
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setShowOnStartup(boolean bl) {
        this.showOnStartup = bl;
    }

    public void setStyle(TipStyle tipStyle) {
        this.style = tipStyle;
    }

    public static enum TipStyle {
        TWO_COLUMNS,
        TWO_COLUMNS_LARGE,
        HEADER;

    }
}

