/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.figures.AbstractLinearMarkedFigure;
import org.eclipse.nebula.visualization.widgets.util.GraphicsUtil;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaledMarker;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class ProgressBarFigure
extends AbstractLinearMarkedFigure {
    private Color fillColor = BLUE_COLOR;
    private Color fillBackgroundColor = GRAY_COLOR;
    private boolean effect3D = true;
    private boolean horizontal = false;
    private boolean indicatorMode = false;
    private static final Color WHITE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
    private static final Color GRAY_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
    private static final Color BLUE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLUE);
    private Track track;
    private Label label;
    private Thumb thumb;
    private double origin = 0.0;
    private boolean originIgnored;

    public ProgressBarFigure() {
        this.scale.setScaleLineVisible(false);
        this.scale.setTickLableSide(AbstractScale.LabelSide.Secondary);
        if (this.horizontal) {
            ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.HORIZONTAL);
            this.scale.setTickLableSide(AbstractScale.LabelSide.Primary);
            this.marker.setLabelSide(AbstractScale.LabelSide.Secondary);
        } else {
            ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.VERTICAL);
            this.scale.setTickLableSide(AbstractScale.LabelSide.Primary);
            this.marker.setLabelSide(AbstractScale.LabelSide.Secondary);
        }
        this.track = new Track();
        this.label = new Label();
        this.label.setOpaque(false);
        this.thumb = new Thumb();
        this.thumb.setVisible(this.indicatorMode);
        this.setLayoutManager((LayoutManager)new ProgressBarLayout());
        this.add((IFigure)this.scale, "scale");
        this.add((IFigure)this.marker, "markers");
        this.add((IFigure)this.track, "track");
        this.add((IFigure)this.thumb, "thumb");
        this.add((IFigure)this.label, "label");
        this.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                ProgressBarFigure.this.revalidate();
            }
        });
    }

    public Color getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public double getOrigin() {
        return this.origin;
    }

    public boolean isEffect3D() {
        return this.effect3D;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public boolean isIndicatorMode() {
        return this.indicatorMode;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public boolean isOriginIgnored() {
        return this.originIgnored;
    }

    public void setEffect3D(boolean effect3D) {
        if (this.effect3D == effect3D) {
            return;
        }
        this.effect3D = effect3D;
        this.repaint();
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.repaint();
    }

    public void setFillBackgroundColor(Color fillBackgroundColor) {
        if (this.fillBackgroundColor != null && this.fillBackgroundColor.equals((Object)fillBackgroundColor)) {
            return;
        }
        this.fillBackgroundColor = fillBackgroundColor;
        this.repaint();
    }

    public void setFillColor(Color fillColor) {
        if (this.fillColor != null && this.fillColor.equals((Object)fillColor)) {
            return;
        }
        this.fillColor = fillColor;
        this.repaint();
    }

    public void setHorizontal(boolean horizontal) {
        if (this.horizontal == horizontal) {
            return;
        }
        this.horizontal = horizontal;
        if (horizontal) {
            ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.HORIZONTAL);
            this.scale.setTickLableSide(AbstractScale.LabelSide.Primary);
            this.marker.setLabelSide(AbstractScale.LabelSide.Secondary);
        } else {
            ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.VERTICAL);
            this.scale.setTickLableSide(AbstractScale.LabelSide.Primary);
            this.marker.setLabelSide(AbstractScale.LabelSide.Secondary);
        }
        this.revalidate();
    }

    public void setIndicatorMode(boolean indicatorMode) {
        if (this.indicatorMode == indicatorMode) {
            return;
        }
        this.indicatorMode = indicatorMode;
        this.thumb.setVisible(indicatorMode);
        this.revalidate();
        this.repaint();
    }

    public void setOrigin(double origin) {
        if (this.origin == origin) {
            return;
        }
        this.origin = origin;
        this.repaint();
    }

    public void setOriginIgnored(boolean originIgnored) {
        if (this.originIgnored == originIgnored) {
            return;
        }
        this.originIgnored = originIgnored;
        this.repaint();
    }

    @Override
    public void setRange(double min, double max) {
        super.setRange(min, max);
        this.updateLabelText();
    }

    public void setShowLabel(boolean visible) {
        this.label.setVisible(visible);
        this.repaint();
    }

    @Override
    public void setValue(double value) {
        super.setValue(value);
        this.updateLabelText();
        this.revalidate();
    }

    private void updateLabelText() {
        this.label.setText(this.getValueText());
    }

    class ProgressBarLayout
    extends AbstractLayout {
        private static final int ADDITIONAL_MARGIN = 1;
        public static final String SCALE = "scale";
        public static final String TRACK = "track";
        public static final String MARKERS = "markers";
        public static final String THUMB = "thumb";
        public static final String LABEL = "label";
        private LinearScale scale;
        private LinearScaledMarker marker;
        private Track track;
        private Label label;
        private Thumb thumb;

        ProgressBarLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int w, int h) {
            Insets insets = container.getInsets();
            Dimension d = new Dimension(64, 256);
            d.expand(insets.getWidth(), insets.getHeight());
            return d;
        }

        private void horizontalLayout(IFigure container) {
            Rectangle area = container.getClientArea().getCopy();
            ++area.x;
            area.width -= 2;
            Dimension scaleSize = new Dimension(0, 0);
            Dimension markerSize = new Dimension(0, 0);
            Rectangle trackBounds = area;
            if (this.scale != null) {
                if (this.scale.isVisible()) {
                    scaleSize = this.scale.getPreferredSize(area.width, -1);
                    this.scale.setBounds(new Rectangle(area.x, area.y + area.height - scaleSize.height, scaleSize.width, scaleSize.height));
                    ++scaleSize.height;
                } else {
                    scaleSize.width = area.width + 2 * this.scale.getMargin();
                    scaleSize.height = 0;
                    this.scale.setBounds(new Rectangle(area.x - this.scale.getMargin(), area.y + area.height - scaleSize.height, scaleSize.width, scaleSize.height));
                    scaleSize.width = 0;
                }
            }
            if (this.marker != null && this.marker.isVisible()) {
                markerSize = this.marker.getPreferredSize();
                this.marker.setBounds(new Rectangle(this.marker.getScale().getBounds().x, area.y, markerSize.width, markerSize.height));
            }
            if (this.track != null) {
                trackBounds = new Rectangle(this.scale.getValuePosition(this.scale.getRange().getLower(), false), area.y + markerSize.height, this.scale.getTickLength() + this.track.getLineWidth(), area.height - markerSize.height - scaleSize.height);
                this.track.setBounds(trackBounds);
            }
            if (this.thumb != null && this.thumb.isVisible()) {
                int h = this.track.getBounds().height;
                int b = 13;
                int[] nArray = new int[8];
                nArray[0] = b / 2;
                nArray[2] = b;
                nArray[3] = h / 2;
                nArray[4] = b / 2;
                nArray[5] = h - 1;
                nArray[7] = h / 2;
                PointList newPointList = new PointList(nArray);
                newPointList.translate(this.scale.getValuePosition(ProgressBarFigure.this.getCoercedValue(), false) - 6, this.track.getBounds().y);
                this.thumb.setPoints(newPointList);
            }
            if (this.label != null) {
                Dimension labelSize = this.label.getPreferredSize();
                this.label.setBounds(new Rectangle(trackBounds.x + trackBounds.width / 2 - labelSize.width / 2, trackBounds.y + trackBounds.height / 2 - labelSize.height / 2, labelSize.width, labelSize.height));
            }
        }

        public void layout(IFigure container) {
            if (ProgressBarFigure.this.horizontal) {
                this.horizontalLayout(container);
            } else {
                this.verticalLayout(container);
            }
        }

        public void setConstraint(IFigure child, Object constraint) {
            if (constraint.equals(SCALE)) {
                this.scale = (LinearScale)child;
            } else if (constraint.equals(MARKERS)) {
                this.marker = (LinearScaledMarker)child;
            } else if (constraint.equals(TRACK)) {
                this.track = (Track)child;
            } else if (constraint.equals(THUMB)) {
                this.thumb = (Thumb)child;
            } else if (constraint.equals(LABEL)) {
                this.label = (Label)child;
            }
        }

        private void verticalLayout(IFigure container) {
            Rectangle area = container.getClientArea().getCopy();
            ++area.y;
            area.height -= 2;
            Dimension scaleSize = new Dimension(0, 0);
            Dimension markerSize = new Dimension(0, 0);
            Rectangle trackBounds = area;
            if (this.scale != null) {
                if (this.scale.isVisible()) {
                    scaleSize = this.scale.getPreferredSize(-1, area.height);
                    this.scale.setBounds(new Rectangle(area.x + 1, area.y, scaleSize.width, scaleSize.height));
                    ++scaleSize.width;
                } else {
                    scaleSize.width = 0;
                    scaleSize.height = area.height + 2 * this.scale.getMargin();
                    this.scale.setBounds(new Rectangle(area.x, area.y - this.scale.getMargin(), scaleSize.width, scaleSize.height));
                    scaleSize.height = 0;
                }
            }
            if (this.marker != null && this.marker.isVisible()) {
                markerSize = this.marker.getPreferredSize();
                this.marker.setBounds(new Rectangle(area.x + area.width - markerSize.width - 1, this.marker.getScale().getBounds().y, markerSize.width, markerSize.height));
            }
            if (this.track != null) {
                trackBounds = new Rectangle(area.x + scaleSize.width, this.scale.getValuePosition(this.scale.getRange().getUpper(), false), area.width - markerSize.width - scaleSize.width, this.scale.getTickLength() + this.track.getLineWidth());
                this.track.setBounds(trackBounds);
            }
            if (this.thumb != null && this.thumb.isVisible()) {
                int h = this.track.getBounds().width;
                int b = 13;
                int[] nArray = new int[8];
                nArray[1] = b / 2;
                nArray[2] = h / 2;
                nArray[4] = h - 1;
                nArray[5] = b / 2;
                nArray[6] = h / 2;
                nArray[7] = b;
                PointList newPointList = new PointList(nArray);
                newPointList.translate(this.track.getBounds().x, this.scale.getValuePosition(ProgressBarFigure.this.getCoercedValue(), false) - 6);
                this.thumb.setPoints(newPointList);
            }
            if (this.label != null && this.label.isVisible()) {
                Dimension labelSize = this.label.getPreferredSize();
                this.label.setBounds(new Rectangle(trackBounds.x + trackBounds.width / 2 - labelSize.width / 2, trackBounds.y + trackBounds.height / 2 - labelSize.height / 2, labelSize.width, labelSize.height));
            }
        }
    }

    class Thumb
    extends Polygon {
        public static final int LENGTH = 20;
        public static final int BREADTH = 13;
        public final PointList horizontalThumbPointList;
        public final PointList verticalThumbPointList;

        public Thumb() {
            int[] nArray = new int[10];
            nArray[3] = 13;
            nArray[4] = 16;
            nArray[5] = 13;
            nArray[6] = 20;
            nArray[7] = 6;
            nArray[8] = 16;
            this.horizontalThumbPointList = new PointList(nArray);
            int[] nArray2 = new int[10];
            nArray2[3] = 16;
            nArray2[4] = 6;
            nArray2[5] = 20;
            nArray2[6] = 13;
            nArray2[7] = 16;
            nArray2[8] = 13;
            this.verticalThumbPointList = new PointList(nArray2);
            this.setFill(true);
            this.setForegroundColor(GRAY_COLOR);
            this.setLineWidth(1);
        }

        protected void fillShape(Graphics g) {
            g.setAntialias(1);
            g.setClip(new Rectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height));
            g.setBackgroundColor(WHITE_COLOR);
            super.fillShape(g);
            Point leftPoint = this.getPoints().getPoint(0);
            Point rightPoint = this.getPoints().getPoint(2);
            Pattern thumbPattern = null;
            boolean support3D = GraphicsUtil.testPatternSupported(g);
            this.setOutline(ProgressBarFigure.this.effect3D && support3D);
            if (ProgressBarFigure.this.effect3D && support3D) {
                thumbPattern = GraphicsUtil.createScaledPattern(g, (Device)Display.getCurrent(), leftPoint.x, leftPoint.y, rightPoint.x, rightPoint.y, WHITE_COLOR, 0, ProgressBarFigure.this.fillColor, 255);
                g.setBackgroundPattern(thumbPattern);
            } else {
                g.setBackgroundColor(ProgressBarFigure.this.fillColor);
            }
            g.fillPolygon(this.getPoints());
            if (ProgressBarFigure.this.effect3D && support3D) {
                thumbPattern.dispose();
            }
        }
    }

    class Track
    extends RectangleFigure {
        public Track() {
            this.setForegroundColor(GRAY_COLOR);
            this.setOutline(false);
        }

        protected void fillShape(Graphics graphics) {
            graphics.setAntialias(1);
            int valuePosition = ((LinearScale)ProgressBarFigure.this.scale).getValuePosition(ProgressBarFigure.this.getCoercedValue(), false);
            double tempOrigin = ProgressBarFigure.this.originIgnored ? ProgressBarFigure.this.minimum : ProgressBarFigure.this.origin;
            int originPosition = ((LinearScale)ProgressBarFigure.this.scale).getValuePosition(tempOrigin, false);
            int fillLength = valuePosition - originPosition;
            boolean support3D = GraphicsUtil.testPatternSupported(graphics);
            if (ProgressBarFigure.this.effect3D && support3D) {
                graphics.setBackgroundColor(ProgressBarFigure.this.fillBackgroundColor);
                super.fillShape(graphics);
                Pattern backGroundPattern = ProgressBarFigure.this.horizontal ? GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.y + this.bounds.height, WHITE_COLOR, 255, ProgressBarFigure.this.fillBackgroundColor, 0) : GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y, WHITE_COLOR, 255, ProgressBarFigure.this.fillBackgroundColor, 0);
                graphics.setBackgroundPattern(backGroundPattern);
                super.fillShape(graphics);
                backGroundPattern.dispose();
                if (!ProgressBarFigure.this.indicatorMode) {
                    backGroundPattern = ProgressBarFigure.this.horizontal ? GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.y + this.bounds.height, WHITE_COLOR, 255, ProgressBarFigure.this.fillColor, 0) : GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y, WHITE_COLOR, 255, ProgressBarFigure.this.fillColor, 0);
                    graphics.setBackgroundColor(ProgressBarFigure.this.fillColor);
                    graphics.setForegroundColor(ProgressBarFigure.this.fillColor);
                    if (ProgressBarFigure.this.horizontal) {
                        Rectangle valueRectangle = new Rectangle(originPosition, this.bounds.y + 1, fillLength, this.bounds.height - 2);
                        graphics.fillRectangle(valueRectangle);
                        graphics.setBackgroundPattern(backGroundPattern);
                        graphics.fillRectangle(valueRectangle);
                    } else {
                        Rectangle valueRectangle = new Rectangle(this.bounds.x + 1, originPosition, this.bounds.width - 2, fillLength);
                        graphics.fillRectangle(valueRectangle);
                        graphics.setBackgroundPattern(backGroundPattern);
                        graphics.fillRectangle(valueRectangle);
                    }
                    backGroundPattern.dispose();
                }
                graphics.setForegroundColor(GRAY_COLOR);
                this.outlineShape(graphics);
            } else {
                graphics.setBackgroundColor(ProgressBarFigure.this.fillBackgroundColor);
                if (!ProgressBarFigure.this.indicatorMode) {
                    if (ProgressBarFigure.this.horizontal) {
                        graphics.fillRectangle(this.bounds.x, this.bounds.y, this.bounds.width - this.getLineWidth(), this.bounds.height);
                        graphics.setBackgroundColor(ProgressBarFigure.this.fillColor);
                        graphics.fillRectangle(new Rectangle(originPosition, this.bounds.y, fillLength, this.bounds.height));
                    } else {
                        graphics.fillRectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height - this.getLineWidth());
                        graphics.setBackgroundColor(ProgressBarFigure.this.fillColor);
                        graphics.fillRectangle(new Rectangle(this.bounds.x, originPosition, this.bounds.width, fillLength));
                    }
                } else {
                    graphics.fillRectangle(this.getBounds());
                }
            }
        }
    }
}

