/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.domain.java.discountsystem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.loyaltylib.domain.java.observable.DiscountTreeTypeAction;
import su.artix.loyaltylib.domain.java.observable.Named;

public class DiscountCampaignGroup
extends AbstractDiscountModel
implements Serializable,
Named {
    private static final long serialVersionUID = 1L;
    private String version;
    @NotNull
    private String name;
    private List<DiscountCampaignGroup> subGroups = new ArrayList<DiscountCampaignGroup>();
    private List<DiscountCampaign> discountCampaigns = new ArrayList<DiscountCampaign>();
    private String campaignInteraction;
    private Integer priority;

    public DiscountCampaignGroup(String version) {
        this.version = version;
        this.campaignInteraction = "all";
    }

    public List<DiscountCampaignGroup> getSubGroups() {
        return this.subGroups;
    }

    public void setSubGroups(List<DiscountCampaignGroup> subGroups) {
        this.subGroups = subGroups;
    }

    public String getCampaignInteraction() {
        return this.campaignInteraction;
    }

    public void setCampaignInteraction(String campaignInteraction) {
        if (!StringUtils.equals((CharSequence)campaignInteraction, (CharSequence)this.campaignInteraction)) {
            this.campaignInteraction = campaignInteraction;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public List<DiscountCampaign> getDiscountCampaigns() {
        return this.discountCampaigns;
    }

    public void addSubGroup(DiscountCampaignGroup subGroup) {
        subGroup.setParent(this);
        this.subGroups.add(subGroup);
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), null, subGroup);
    }

    public void addDiscountCampaign(DiscountCampaign discountCampaign) {
        discountCampaign.setParent(this);
        this.discountCampaigns.add(discountCampaign);
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), null, discountCampaign);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!StringUtils.equals((CharSequence)name, (CharSequence)this.name)) {
            this.name = name;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public void deleteGroup(DiscountCampaignGroup deletedElement) {
        this.subGroups.remove(deletedElement);
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), null, deletedElement);
    }

    public void deleteDiscountCampaign(DiscountCampaign deletedElement) {
        this.discountCampaigns.remove(deletedElement);
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), null, deletedElement);
    }

    public void refresh() {
        this.firePropertyChange(DiscountTreeTypeAction.REFRESH.toString(), null, this);
    }

    @Override
    public String getNameTreeNode() {
        return "[" + this.name + "]";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DiscountCampaignGroup [version=");
        builder.append(this.version);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", subGroups=");
        builder.append(this.subGroups);
        builder.append(", discountCampaigns=");
        builder.append(this.discountCampaigns);
        builder.append(", campaignInteraction=");
        builder.append(this.campaignInteraction);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscountCampaignGroup other = (DiscountCampaignGroup)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void setPriority(Integer priority) {
        if (!ObjectUtils.equals((Object)this.priority, (Object)priority)) {
            this.priority = priority;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Integer getPriority() {
        return this.priority;
    }
}

