/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.directory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.yuki.model.ModelExceptionNotifier;
import su.artix.yuki.model.directory.DirectoryModelFactory;

public class DirectoryInvocationHandler<T>
implements InvocationHandler {
    private AtomicBoolean timeCloseApp = new AtomicBoolean(false);
    private static Logger log = LoggerFactory.getLogger(DirectoryInvocationHandler.class);
    private int waitTimeout = Integer.getInteger("yuki.base.recive.data.wait_timeout", 10);
    private Object directoryModel;

    public DirectoryInvocationHandler(Object directoryModel) {
        this.directoryModel = directoryModel;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        log.trace("method name: {}", (Object)method.getName());
        if (!method.getName().contains("PropertyChange") && !method.getName().equals("setClazz")) {
            if (this.timeCloseApp.get()) {
                log.info("User want close this app...");
                DirectoryModelFactory.getExceptionNotifier().sendCloseEvent();
                throw new RuntimeException("The application must be closed");
            }
            final String connectionId = ArtixAdminContextHolder.getConnectionId();
            DirectoryThread thread = new DirectoryThread(this, "DAOThread"){

                @Override
                public void run() {
                    ArtixAdminContextHolder.setConnectionId((String)connectionId);
                    try {
                        Object result = null;
                        result = method.invoke(directoryModel, args);
                        this.setResult(result);
                    }
                    catch (InvocationTargetException exception) {
                        this.setException(exception.getTargetException());
                    }
                    catch (Exception e) {
                        log.error("{}", (Throwable)e);
                    }
                    this.setSuccessOperation(true);
                }
            };
            thread.start();
            int counter = 1;
            while (!thread.isSuccessOperation()) {
                ModelExceptionNotifier.UserAnswer answer;
                Thread.sleep(100L);
                if (counter++ % (this.waitTimeout * 10) != 0 || DirectoryModelFactory.getExceptionNotifier() == null || !ModelExceptionNotifier.UserAnswer.CLOSE_APP.equals((Object)(answer = DirectoryModelFactory.getExceptionNotifier().sendMessage(new RuntimeException("\u0414\u043e\u043b\u0433\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f"))))) continue;
                this.timeCloseApp.set(true);
                DirectoryModelFactory.getExceptionNotifier().sendCloseEvent();
                break;
            }
            if (thread.getException() != null) {
                throw thread.getException();
            }
            return thread.getResult();
        }
        return method.invoke(this.directoryModel, args);
    }

    class DirectoryThread
    extends Thread {
        private boolean successOperation;
        private Object result;
        private Throwable exception;

        public DirectoryThread(String name) {
            super(name);
            this.successOperation = false;
            this.result = null;
            this.exception = null;
        }

        public Object getResult() {
            return this.result;
        }

        public Throwable getException() {
            return this.exception;
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public boolean isSuccessOperation() {
            return this.successOperation;
        }

        public void setSuccessOperation(boolean successOperation) {
            this.successOperation = successOperation;
        }
    }
}

