/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.repository.Near;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoParameters
extends Parameters {
    private final Integer distanceIndex;
    private Integer nearIndex;

    public MongoParameters(Method method, boolean isGeoNearMethod) {
        super(method);
        List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
        this.distanceIndex = parameterTypes.indexOf(Distance.class);
        if (this.nearIndex == null && isGeoNearMethod) {
            this.nearIndex = this.getNearIndex(parameterTypes);
        } else if (this.nearIndex == null) {
            this.nearIndex = -1;
        }
    }

    private final int getNearIndex(List<Class<?>> parameterTypes) {
        for (Class reference : Arrays.asList(Point.class, double[].class)) {
            int nearIndex = parameterTypes.indexOf(reference);
            if (nearIndex == -1) continue;
            if (nearIndex == parameterTypes.lastIndexOf(reference)) {
                return nearIndex;
            }
            throw new IllegalStateException("Multiple Point parameters found but none annotated with @Near!");
        }
        return -1;
    }

    protected Parameter createParameter(MethodParameter parameter) {
        MongoParameter mongoParameter = new MongoParameter(parameter);
        if (this.nearIndex == null && mongoParameter.isManuallyAnnotatedNearParameter()) {
            this.nearIndex = mongoParameter.getIndex();
        } else if (mongoParameter.isManuallyAnnotatedNearParameter()) {
            throw new IllegalStateException(String.format("Found multiple @Near annotations ond method %s! Only one allowed!", parameter.getMethod().toString()));
        }
        return mongoParameter;
    }

    public int getDistanceIndex() {
        return this.distanceIndex;
    }

    public int getNearIndex() {
        return this.nearIndex;
    }

    class MongoParameter
    extends Parameter {
        private final MethodParameter parameter;

        MongoParameter(MethodParameter parameter) {
            super(parameter);
            this.parameter = parameter;
            if (!this.isPoint() && this.hasNearAnnotation()) {
                throw new IllegalArgumentException("Near annotation is only allowed at Point parameter!");
            }
        }

        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || this.getType().equals(Distance.class) || this.isNearParameter();
        }

        private boolean isNearParameter() {
            Integer nearIndex = MongoParameters.this.nearIndex;
            return nearIndex != null && nearIndex.equals(this.getIndex());
        }

        private boolean isManuallyAnnotatedNearParameter() {
            return this.isPoint() && this.hasNearAnnotation();
        }

        private boolean isPoint() {
            return this.getType().equals(Point.class) || this.getType().equals(double[].class);
        }

        private boolean hasNearAnnotation() {
            return this.parameter.getParameterAnnotation(Near.class) != null;
        }
    }
}

