/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import ru.ssa.cashadmin.domain.BarcodesV45;
import ru.ssa.cashadmin.domain.Units;

@Entity
@Table(name="barcodes")
@MappedSuperclass
public class BarcodesV50
extends BarcodesV45 {
    private static final long serialVersionUID = 1L;
    @Min(value=0L)
    @Digits(integer=15, fraction=2)
    private BigDecimal packingprice;
    @ManyToOne
    @JoinColumn(name="packingmeasure")
    @NotFound(action=NotFoundAction.IGNORE)
    private Units packingmeasure;
    @Column(name="packingmeasure", insertable=false, updatable=false)
    private Integer packingmeasurecode;

    protected BarcodesV50() {
    }

    public BigDecimal getPackingprice() {
        return this.packingprice;
    }

    public void setPackingprice(BigDecimal packingprice) {
        this.packingprice = packingprice;
    }

    public Units getPackingmeasure() {
        return this.packingmeasure;
    }

    public void setPackingmeasure(Units packingmeasure) {
        this.packingmeasure = packingmeasure;
        this.packingmeasurecode = packingmeasure != null ? packingmeasure.getCode() : null;
    }

    public Integer getPackingmeasurecode() {
        return this.packingmeasurecode;
    }

    public void setPackingmeasurecode(Integer packingmeasurecode) {
        this.packingmeasurecode = packingmeasurecode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.packingmeasurecode == null ? 0 : this.packingmeasurecode.hashCode());
        result = 31 * result + (this.packingprice == null ? 0 : this.packingprice.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BarcodesV50 other = (BarcodesV50)obj;
        if (this.packingmeasurecode == null ? other.packingmeasurecode != null : !this.packingmeasurecode.equals(other.packingmeasurecode)) {
            return false;
        }
        return !(this.packingprice == null ? other.packingprice != null : !this.packingprice.equals(other.packingprice));
    }
}

