/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.NotEmpty;
import ru.ssa.cashadmin.domain.Aspectscheme;
import ru.ssa.cashadmin.domain.Aspectvalueset;
import ru.ssa.cashadmin.domain.Dept;
import ru.ssa.cashadmin.domain.InventGroup;
import ru.ssa.cashadmin.domain.Sprices;
import ru.ssa.cashadmin.domain.Units;
import ru.ssa.cashadmin.domain.Valut;
import ru.ssa.cashadmin.domain.Vat;

@Entity
@Table(name="tmc")
@MappedSuperclass
public class Invent
implements Serializable {
    @NotNull
    @NotEmpty
    @Size(max=20)
    @Id
    private String bcode;
    @NotNull
    @NotEmpty
    @Size(max=100)
    private String code;
    @Size(max=200)
    private String name;
    @Size(max=200)
    private String articul;
    @Min(value=0L)
    @Digits(integer=15, fraction=3)
    private BigDecimal cquant;
    @Min(value=0L)
    @Digits(integer=15, fraction=4)
    private BigDecimal price;
    @Min(value=0L)
    @Digits(integer=15, fraction=4)
    private BigDecimal minprice;
    @Min(value=0L)
    @Digits(integer=15, fraction=3)
    private BigDecimal quantdefault;
    @Min(value=0L)
    @Digits(integer=15, fraction=3)
    private BigDecimal quantlimit;
    private Integer ostat;
    private Integer links;
    @Column(name="quant_mode")
    private Integer quantMode;
    @Column(name="bcode_mode")
    private Integer bcodeMode;
    @Column(name="op_mode")
    private Integer opMode;
    @Column(name="dept_mode")
    private Integer deptMode;
    @Column(name="price_mode")
    private Integer priceMode;
    @Min(value=0L)
    @Digits(integer=15, fraction=3)
    @Column(name="unit_weight")
    private BigDecimal unitWeight;
    @Transient
    @NotFound(action=NotFoundAction.IGNORE)
    private String groupName;
    @Column(name="vatcode1", insertable=false, updatable=false)
    private Integer vatcode1code;
    @Column(name="vatcode2", insertable=false, updatable=false)
    private Integer vatcode2code;
    @Column(name="vatcode3", insertable=false, updatable=false)
    private Integer vatcode3code;
    @Column(name="vatcode4", insertable=false, updatable=false)
    private Integer vatcode4code;
    @Column(name="vatcode5", insertable=false, updatable=false)
    private Integer vatcode5code;
    @ManyToOne
    @JoinColumn(name="vatcode1")
    @NotFound(action=NotFoundAction.IGNORE)
    private Vat vatcode1;
    @ManyToOne
    @JoinColumn(name="vatcode2")
    @NotFound(action=NotFoundAction.IGNORE)
    private Vat vatcode2;
    @ManyToOne
    @JoinColumn(name="vatcode3")
    @NotFound(action=NotFoundAction.IGNORE)
    private Vat vatcode3;
    @ManyToOne
    @JoinColumn(name="vatcode4")
    @NotFound(action=NotFoundAction.IGNORE)
    private Vat vatcode4;
    @ManyToOne
    @JoinColumn(name="vatcode5")
    @NotFound(action=NotFoundAction.IGNORE)
    private Vat vatcode5;
    @ManyToOne
    @JoinColumn(name="measure")
    @NotFound(action=NotFoundAction.IGNORE)
    private Units measure;
    @Column(name="measure", insertable=false, updatable=false)
    private Integer measurecode;
    @ManyToOne
    @JoinColumn(name="valcode")
    @NotFound(action=NotFoundAction.IGNORE)
    private Valut valcode;
    @Column(name="valcode", insertable=false, updatable=false)
    private Integer valcodecode;
    @ManyToOne
    @JoinColumn(name="dcode")
    @NotFound(action=NotFoundAction.IGNORE)
    private Dept dcode;
    @Column(name="dcode", insertable=false, updatable=false)
    private Integer dcodecode;
    @ManyToOne
    @JoinColumn(name="pricetype")
    @NotFound(action=NotFoundAction.IGNORE)
    private Sprices pricetype;
    @Column(name="pricetype", insertable=false, updatable=false)
    private Integer pricetypecode;
    @ManyToOne
    @JoinColumn(name="groupcode")
    @NotFound(action=NotFoundAction.IGNORE)
    private InventGroup group;
    @Column(insertable=false, updatable=false)
    private String groupcode;
    @Min(value=0L)
    @Digits(integer=13, fraction=3)
    @Column(name="remain")
    private BigDecimal remain;
    @Column(name="remainDate")
    private Date remainDate;
    @ManyToOne
    @JoinColumn(name="aspectschemecode")
    @NotFound(action=NotFoundAction.IGNORE)
    private Aspectscheme aspectscheme;
    @Column(insertable=false, updatable=false)
    private Integer aspectschemecode;
    @ManyToOne
    @JoinColumn(name="aspectvaluesetcode")
    @NotFound(action=NotFoundAction.IGNORE)
    private Aspectvalueset aspectvaluesetcode;
    @Column(name="aspectvaluesetcode", insertable=false, updatable=false)
    private Integer aspectvaluesetcodecode;
    @Column(name="extendetoptions")
    private String extendedoptions;
    @Column(name="tara_mode")
    private Integer tara_mode;
    private static final long serialVersionUID = 1L;

    protected Invent() {
    }

    public String getBcode() {
        return this.bcode;
    }

    public void setBcode(String bcode) {
        this.bcode = bcode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getArticul() {
        return this.articul;
    }

    public void setArticul(String articul) {
        this.articul = articul;
    }

    public BigDecimal getCquant() {
        return this.cquant;
    }

    public void setCquant(BigDecimal cquant) {
        this.cquant = cquant;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMinprice() {
        return this.minprice;
    }

    public void setMinprice(BigDecimal minprice) {
        this.minprice = minprice;
    }

    public BigDecimal getQuantdefault() {
        return this.quantdefault;
    }

    public void setQuantdefault(BigDecimal quantdefault) {
        this.quantdefault = quantdefault;
    }

    public BigDecimal getQuantlimit() {
        return this.quantlimit;
    }

    public void setQuantlimit(BigDecimal quantlimit) {
        this.quantlimit = quantlimit;
    }

    public BigDecimal getUnitWeight() {
        return this.unitWeight;
    }

    public void setUnitWeight(BigDecimal unitWeight) {
        this.unitWeight = unitWeight;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Units getMeasure() {
        return this.measure;
    }

    public void setMeasure(Units measure) {
        this.measure = measure;
    }

    public Valut getValcode() {
        return this.valcode;
    }

    public void setValcode(Valut valcode) {
        this.valcode = valcode;
    }

    public Dept getDcode() {
        return this.dcode;
    }

    public void setDcode(Dept dcode) {
        this.dcode = dcode;
    }

    public BigDecimal getRemain() {
        return this.remain;
    }

    public Date getRemainDate() {
        return this.remainDate;
    }

    public void setRemain(BigDecimal remain) {
        this.remain = remain;
    }

    public void setRemainDate(Date remainDate) {
        this.remainDate = remainDate;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bcode == null ? 0 : this.bcode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Invent other = (Invent)obj;
        return !(this.bcode == null ? other.getBcode() != null : !this.bcode.equals(other.getBcode()));
    }

    public Sprices getPricetype() {
        return this.pricetype;
    }

    public void setPricetype(Sprices pricetype) {
        this.pricetype = pricetype;
    }

    public Integer getOstat() {
        return this.ostat;
    }

    public void setOstat(Integer ostat) {
        this.ostat = ostat;
    }

    public Integer getLinks() {
        return this.links;
    }

    public void setLinks(Integer links) {
        this.links = links;
    }

    public Integer getQuantMode() {
        return this.quantMode;
    }

    public void setQuantMode(Integer quantMode) {
        this.quantMode = quantMode;
    }

    public Integer getBcodeMode() {
        return this.bcodeMode;
    }

    public void setBcodeMode(Integer bcodeMode) {
        this.bcodeMode = bcodeMode;
    }

    public Integer getOpMode() {
        return this.opMode;
    }

    public void setOpMode(Integer opMode) {
        this.opMode = opMode;
    }

    public Integer getDeptMode() {
        return this.deptMode;
    }

    public void setDeptMode(Integer deptMode) {
        this.deptMode = deptMode;
    }

    public InventGroup getGroup() {
        return this.group;
    }

    public Integer getPriceMode() {
        return this.priceMode;
    }

    public void setPriceMode(Integer priceMode) {
        this.priceMode = priceMode;
    }

    public void setGroupName(String group) {
        this.groupName = group;
    }

    public String getGroupName() {
        return this.getGroup() != null ? this.getGroup().getGroupname() : "";
    }

    public void setGroup(InventGroup group) {
        this.group = group;
        if (group != null) {
            this.groupcode = group.getGroupcode();
        }
    }

    public Aspectvalueset getAspectvaluesetcode() {
        return this.aspectvaluesetcode;
    }

    public void setAspectvaluesetcode(Aspectvalueset aspectvaluesetcode) {
        this.aspectvaluesetcode = aspectvaluesetcode;
    }

    public boolean isAspectschemeNotNull() {
        return this.aspectschemecode != null || this.aspectscheme != null;
    }

    public void setAspectschemeNotNull(boolean value) {
    }

    public void setExtendedoptions(String extendedoptions) {
        this.extendedoptions = extendedoptions;
    }

    public String getExtendedoptions() {
        return this.extendedoptions;
    }

    public void setTara_mode(Integer tara_mode) {
        this.tara_mode = tara_mode;
    }

    public Integer getTara_mode() {
        return this.tara_mode;
    }

    public Aspectscheme getAspectscheme() {
        return this.aspectscheme;
    }

    public void setAspectscheme(Aspectscheme aspectscheme) {
        this.aspectscheme = aspectscheme;
    }

    public Integer getAspectschemecode() {
        return this.aspectschemecode;
    }

    public void setAspectschemecode(Integer aspectschemecode) {
        this.aspectschemecode = aspectschemecode;
    }

    public Integer getPricetypecode() {
        return this.pricetypecode;
    }

    public void setPricetypecode(Integer pricetypecode) {
        this.pricetypecode = pricetypecode;
    }

    public String getGroupcode() {
        return this.groupcode;
    }

    public void setGroupcode(String groupcode) {
        this.groupcode = groupcode;
    }

    public Integer getVatcode1code() {
        return this.vatcode1code;
    }

    public void setVatcode1code(Integer vatcode1code) {
        this.vatcode1code = vatcode1code;
    }

    public Integer getVatcode2code() {
        return this.vatcode2code;
    }

    public void setVatcode2code(Integer vatcode2code) {
        this.vatcode2code = vatcode2code;
    }

    public Integer getVatcode3code() {
        return this.vatcode3code;
    }

    public void setVatcode3code(Integer vatcode3code) {
        this.vatcode3code = vatcode3code;
    }

    public Integer getVatcode4code() {
        return this.vatcode4code;
    }

    public void setVatcode4code(Integer vatcode4code) {
        this.vatcode4code = vatcode4code;
    }

    public Integer getVatcode5code() {
        return this.vatcode5code;
    }

    public void setVatcode5code(Integer vatcode5code) {
        this.vatcode5code = vatcode5code;
    }

    public Vat getVatcode1() {
        return this.vatcode1;
    }

    public void setVatcode1(Vat vatcode1) {
        this.vatcode1 = vatcode1;
    }

    public Vat getVatcode2() {
        return this.vatcode2;
    }

    public void setVatcode2(Vat vatcode2) {
        this.vatcode2 = vatcode2;
    }

    public Vat getVatcode3() {
        return this.vatcode3;
    }

    public void setVatcode3(Vat vatcode3) {
        this.vatcode3 = vatcode3;
    }

    public Vat getVatcode4() {
        return this.vatcode4;
    }

    public void setVatcode4(Vat vatcode4) {
        this.vatcode4 = vatcode4;
    }

    public Vat getVatcode5() {
        return this.vatcode5;
    }

    public void setVatcode5(Vat vatcode5) {
        this.vatcode5 = vatcode5;
    }

    public Integer getValcodecode() {
        return this.valcodecode;
    }

    public void setValcodecode(Integer valcodecode) {
        this.valcodecode = valcodecode;
    }

    public Integer getDcodecode() {
        return this.dcodecode;
    }

    public void setDcodecode(Integer dcodecode) {
        this.dcodecode = dcodecode;
    }

    public Integer getAspectvaluesetcodecode() {
        return this.aspectvaluesetcodecode;
    }

    public void setAspectvaluesetcodecode(Integer aspectvaluesetcodecode) {
        this.aspectvaluesetcodecode = aspectvaluesetcodecode;
    }

    public Integer getMeasurecode() {
        return this.measurecode;
    }

    public void setMeasurecode(Integer measurecode) {
        this.measurecode = measurecode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Invent [bcode=");
        builder.append(this.bcode);
        builder.append(", code=");
        builder.append(this.code);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", cquant=");
        builder.append(this.cquant);
        builder.append(", price=");
        builder.append(this.price);
        builder.append(", minprice=");
        builder.append(this.minprice);
        builder.append("]");
        return builder.toString();
    }

    public void initDefault() {
    }
}

