/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.providers.accounting;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.SWTResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.accounting.domain.Asset;
import su.artix.accounting.domain.AssetGroup;
import su.artix.accounting.domain.AssetTransactionStatus;
import su.artix.accounting.domain.TransactionStatus;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.utils.ItemsText;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.EarnBonusSystemDAO;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;

public class AccountingLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final Logger log = LoggerFactory.getLogger(AccountingLabelProvider.class);
    private SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Map<Long, String> groupNames = null;
    private static final int NUM_ICO = 0;
    private static final int NUM_SUM = 1;
    private static final int NUM_TYPE = 2;
    private static final int NUM_STATUS = 3;
    private static final int NUM_DATE = 4;
    private static final int NUM_TERMINAL = 10;
    private static final int NUM_SESSION = 9;
    private static final int NUM_REASON = 11;
    private static final int NUM_SOURCE = 12;
    private static final int NUM_GROUP = 13;
    private static final int NUM_SHOP = 5;
    private static final int NUM_CASH = 6;
    private static final int NUM_SHIFT = 7;
    private static final int NUM_CHECK = 8;

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof Asset) {
            return ImagesFactory.INSTANCE.getImage("16x16/plane/asset.png");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                if (element instanceof Asset) {
                    return String.format("%.2f", Float.valueOf((float)((Asset)element).getAmount() / 100.0f));
                }
                if (!(element instanceof AssetTransactionStatus)) break;
                return "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438:";
            }
            case 2: {
                if (!(element instanceof Asset)) break;
                if (((Asset)element).getStatus() == null) {
                    return "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
                }
                return ItemsText.accountingAssetTypeItem.get(((Asset)element).getStatus());
            }
            case 3: {
                TransactionStatus status = null;
                if (element instanceof Asset) {
                    status = ((Asset)element).getLastStatus();
                } else if (element instanceof AssetTransactionStatus) {
                    status = ((AssetTransactionStatus)element).getTransactionStatus();
                }
                if (status == null) break;
                return ItemsText.accountingTransactionStatusItem.get(status);
            }
            case 4: {
                if (element instanceof Asset) {
                    return this.f.format(((Asset)element).getDate());
                }
                if (!(element instanceof AssetTransactionStatus)) break;
                return this.f.format(((AssetTransactionStatus)element).getDate());
            }
            case 9: {
                if (!(element instanceof Asset)) break;
                return ((Asset)element).getSessionId();
            }
            case 10: {
                if (element instanceof Asset) {
                    return ((Asset)element).getTerminal().getTerminalId();
                }
                if (!(element instanceof AssetTransactionStatus)) break;
                return ((AssetTransactionStatus)element).getTerminal().getTerminalId();
            }
            case 11: {
                if (!(element instanceof AssetTransactionStatus)) break;
                return ((AssetTransactionStatus)element).getTransactionReason();
            }
            case 12: {
                if (!(element instanceof AssetTransactionStatus)) break;
                return ((AssetTransactionStatus)element).getTransactionSource();
            }
            case 13: {
                if (!(element instanceof Asset) || ((Asset)element).getAssetGroup() == null || ((Asset)element).getAssetGroup().getGroupId() == null) break;
                StringBuilder sb = new StringBuilder();
                AssetGroup group = ((Asset)element).getAssetGroup();
                sb.append(this.getGroupName(group.getGroupId()));
                if (group.getBegin() != null) {
                    sb.append(", \u043d\u0430\u0447\u0430\u043b\u043e: ");
                    sb.append(this.f.format(group.getBegin()));
                }
                if (group.getEnd() != null) {
                    sb.append(", \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435: ");
                    sb.append(this.f.format(group.getEnd()));
                }
                sb.append(", \u0432\u0435\u0441: ");
                sb.append(group.getWeight());
                return sb.toString();
            }
            case 5: {
                if (!(element instanceof Asset)) break;
                return Activator.getDefault().getBonusInfoProvider().getShop(((Asset)element).getSessionId());
            }
            case 6: {
                if (!(element instanceof Asset)) break;
                return Activator.getDefault().getBonusInfoProvider().getCash(((Asset)element).getSessionId());
            }
            case 7: {
                if (!(element instanceof Asset)) break;
                return Activator.getDefault().getBonusInfoProvider().getShift(((Asset)element).getSessionId());
            }
            case 8: {
                if (!(element instanceof Asset)) break;
                return Activator.getDefault().getBonusInfoProvider().getCheck(((Asset)element).getSessionId());
            }
        }
        return null;
    }

    public static boolean isNumeric(String str) {
        try {
            Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private String getGroupName(String key) {
        String groupName = null;
        if (AccountingLabelProvider.isNumeric(key)) {
            try {
                if (this.groupNames == null) {
                    this.groupNames = new HashMap<Long, String>();
                    DiscountCampaignGroup campaignGroup = Activator.getDefault().getBeanByClass(EarnBonusSystemDAO.class, "earnDao").getDiscountSystem(DiscountSystemDAO.SystemType.EARN_BONUS_SYSTEM).getCampaignGroup();
                    for (DiscountCampaign group : campaignGroup.getDiscountCampaigns()) {
                        this.groupNames.put(group.getId(), group.getName());
                    }
                }
                groupName = this.groupNames.get(Long.parseLong(key));
            }
            catch (Exception e) {
                log.error("can't load discount bonus system: {}", (Object)e.getMessage());
                groupName = null;
            }
        }
        groupName = groupName == null ? "" : ": " + groupName;
        return String.valueOf(key) + groupName;
    }

    private BalanceType getAssetType(Asset asset, Date currentTime) {
        long current;
        long begin = Long.MIN_VALUE;
        long end = Long.MAX_VALUE;
        if (asset.getAssetGroup() != null) {
            if (asset.getAssetGroup().getBegin() != null) {
                begin = asset.getAssetGroup().getBegin().getTime();
            }
            if (asset.getAssetGroup().getEnd() != null) {
                end = asset.getAssetGroup().getEnd().getTime();
            }
        }
        if ((current = currentTime.getTime()) < begin) {
            return BalanceType.INACTIVE;
        }
        if (current <= end) {
            return BalanceType.ACTIVE;
        }
        return BalanceType.OVERPAST;
    }

    public Color getBackground(Object arg0, int arg1) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (element instanceof Asset) {
            switch (this.getAssetType((Asset)element, new Date())) {
                case OVERPAST: {
                    return SWTResourceManager.getColor(15);
                }
                case INACTIVE: {
                    return SWTResourceManager.getColor(6);
                }
                case ACTIVE: {
                    TransactionStatus lastStatus = ((Asset)element).getLastStatus();
                    if (lastStatus == null) break;
                    switch (lastStatus) {
                        case CANCELLED: {
                            return SWTResourceManager.getColor(16);
                        }
                        case NON_CONFIRMED: {
                            return SWTResourceManager.getColor(9);
                        }
                    }
                }
            }
        }
        return SWTResourceManager.getColor(2);
    }

    private static enum BalanceType {
        ACTIVE,
        INACTIVE,
        OVERPAST;

    }
}

