/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.binding.BindingKey;

public class FieldsUtils {
    private static Logger log = LoggerFactory.getLogger(FieldsUtils.class);

    public static Map<Field, List<Field>> getAssociatedFields(List<Field> fields, String prefix) {
        ArrayList<Field> localFildsArray = new ArrayList<Field>();
        HashMap<Field, List<Field>> splittedFields = new HashMap<Field, List<Field>>();
        HashMap<String, Field> lowerNameForFields = new HashMap<String, Field>();
        for (Field field : fields) {
            if (field.getName().startsWith(prefix)) {
                splittedFields.put(field, new ArrayList());
                lowerNameForFields.put(field.getName().toLowerCase().substring(prefix.length()), field);
                continue;
            }
            localFildsArray.add(field);
        }
        Set mainFieldsName = lowerNameForFields.keySet();
        block1: for (Field field : localFildsArray) {
            String name = field.getName();
            for (String mainFieldName : mainFieldsName) {
                if (!StringUtils.endsWithIgnoreCase((String)name, (String)mainFieldName)) continue;
                ((List)splittedFields.get(lowerNameForFields.get(mainFieldName))).add(field);
                continue block1;
            }
        }
        return splittedFields;
    }

    public static List<Field> getFilteredFields(List<Field> fields, String regex) {
        ArrayList<Field> filteredFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (!field.getName().matches(regex)) continue;
            filteredFields.add(field);
        }
        return filteredFields;
    }

    public static void copyOnlyAnnotatedProperties(Object source, Object target, Class panel) {
        if (source != null && target != null && source.getClass().equals(target.getClass())) {
            Field[] fields;
            Class<?> modelClazz = source.getClass();
            Field[] fieldArray = fields = panel.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                try {
                    SecurityKey annotation = field.getAnnotation(SecurityKey.class);
                    BindingKey bindingKey = field.getAnnotation(BindingKey.class);
                    if (!(annotation == null || bindingKey != null && bindingKey.ignore())) {
                        PropertyDescriptor pd = new PropertyDescriptor(annotation.id(), modelClazz);
                        pd.getWriteMethod().invoke(target, pd.getReadMethod().invoke(source, new Object[0]));
                    }
                }
                catch (Exception e) {
                    log.warn("exception while copy value for {}: {}", (Object)modelClazz.getName(), (Object)e.getMessage());
                }
                ++n2;
            }
        }
    }

    public static <T> T createDiscountObjectByClassName(String className, Class<T> clazz) {
        T disObject = null;
        String fullClassName = "su.artix.loyaltylib.domain.java.discountsystem." + className;
        try {
            disObject = (T)Class.forName(fullClassName).newInstance();
        }
        catch (Exception e) {
            log.warn("Can't create class by className: {} because: {}", (Object)className, (Object)e.getMessage());
        }
        return disObject;
    }

    public static String getDiscountClassNameByObject(Object disObject) {
        String className = null;
        if (disObject != null) {
            className = disObject.getClass().getSimpleName();
        }
        return className;
    }
}

