/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.OptimisticTreeCache;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TransactionManagerLookup;
import org.jboss.cache.TreeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimisticTreeCacheProvider
implements CacheProvider {
    public static final String CONFIG_RESOURCE = "hibernate.cache.opt_tree_cache.config";
    public static final String DEFAULT_CONFIG = "treecache-optimistic.xml";
    private static final String NODE_LOCKING_SCHEME = "OPTIMISTIC";
    private static final Logger log = LoggerFactory.getLogger((Class)OptimisticTreeCacheProvider.class);
    private TreeCache cache;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        return new OptimisticTreeCache(this.cache, regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) {
        String resource = properties.getProperty("hibernate.cache.provider_configuration_file_resource_path");
        if (resource == null) {
            resource = properties.getProperty(CONFIG_RESOURCE);
        }
        if (resource == null) {
            resource = DEFAULT_CONFIG;
        }
        log.debug("Configuring TreeCache from resource [" + resource + "]");
        try {
            this.cache = new TreeCache();
            PropertyConfigurator config = new PropertyConfigurator();
            config.configure((Object)this.cache, resource);
            org.hibernate.transaction.TransactionManagerLookup transactionManagerLookup = TransactionManagerLookupFactory.getTransactionManagerLookup(properties);
            if (transactionManagerLookup == null) {
                throw new CacheException("JBossCache only supports optimisitc locking with a configured TransactionManagerLookup (hibernate.transaction.manager_lookup_class)");
            }
            this.cache.setTransactionManagerLookup((TransactionManagerLookup)new TransactionManagerLookupAdaptor(transactionManagerLookup, properties));
            if (!NODE_LOCKING_SCHEME.equalsIgnoreCase(this.cache.getNodeLockingScheme())) {
                log.info("Overriding node-locking-scheme to : OPTIMISTIC");
                this.cache.setNodeLockingScheme(NODE_LOCKING_SCHEME);
            }
            this.cache.start();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void stop() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public TreeCache getUnderlyingCache() {
        return this.cache;
    }

    static final class TransactionManagerLookupAdaptor
    implements TransactionManagerLookup {
        private final org.hibernate.transaction.TransactionManagerLookup tml;
        private final Properties props;

        TransactionManagerLookupAdaptor(org.hibernate.transaction.TransactionManagerLookup tml, Properties props) {
            this.tml = tml;
            this.props = props;
        }

        public TransactionManager getTransactionManager() throws Exception {
            return this.tml.getTransactionManager(this.props);
        }
    }
}

