/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.menutree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import ru.ssa.artixadmin.action.menutree.AddMenuAction;
import ru.ssa.artixadmin.action.menutree.AddMenuActionFromList;
import ru.ssa.artixadmin.action.menutree.AddRootMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.AddSubMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.DeleteMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.DownAction;
import ru.ssa.artixadmin.action.menutree.EditMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.MenuTreeActionGroup;
import ru.ssa.artixadmin.action.menutree.UpAction;
import ru.ssa.artixadmin.action.menutree.dnd.CopyAction;
import ru.ssa.artixadmin.action.menutree.dnd.MenuTreeTransfer;
import ru.ssa.artixadmin.action.menutree.dnd.PasteAction;
import ru.ssa.artixadmin.provider.menutree.MenuTreeContentProvider;
import ru.ssa.artixadmin.provider.menutree.MenuTreeLabelProvider;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuAbstract;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;
import ru.ssa.cashadmin.excep.MenuNotFoundException;
import ru.ssa.cashadmin.excep.SubMenuNotFoundException;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.menutree.MenuTreeModel;
import su.artix.yuki.view.sort.TableComparator;
import su.artix.yuki.view.sort.TableSorter;

public class MenuTreeView
extends ViewPart
implements PropertyChangeListener,
ISelectionListener {
    public static final String ID = "ru.ssa.artixadmin.view.menutree.MenuTreeView";
    private MenuTreeModel model;
    private MenuTreeActionGroup menuTreeActionGroup;
    private IAction addRootMenuTreeAction;
    private IAction addSubMenuTreeAction;
    private IAction addMenuAction;
    private IAction addMenuActionFromList;
    private IAction editMenuTreeAction;
    private IAction deleteMenuTreeAction;
    private IAction copyAction;
    private IAction pasteAction;
    private IAction upAction;
    private IAction downAction;
    private TreeViewer treeViewer;
    private TreeColumn nameTreeColumn;
    private TableSorter<HierarchicalMenuItem> tableSorter;
    private final TableComparator<HierarchicalMenuItem> tableComparator = new TableComparator<HierarchicalMenuItem>(){

        public int compare(HierarchicalMenuItem o1, HierarchicalMenuItem o2) {
            if (o1.getParent() == null && o2.getParent() == null) {
                if (this.getCurrentTreeColumn().equals(MenuTreeView.this.nameTreeColumn) && (o1.getParent() == null || o2.getParent() == null)) {
                    String str1 = o1.getName();
                    String str2 = o2.getName();
                    return super.stringCompare(str1, str2);
                }
            } else {
                Integer value1 = o1.getOrder();
                Integer value2 = o2.getOrder();
                return super.intCompare(value1, value2);
            }
            return 0;
        }
    };
    private final SelectionAdapter sortSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuTreeView.this.tableSorter.setSortTreeColumn((TreeColumn)e.getSource());
            MenuTreeView.this.treeViewer.refresh();
        }
    };

    private void enabledPopupMenu(boolean value) {
        this.addRootMenuTreeAction.setEnabled(true);
        this.addSubMenuTreeAction.setEnabled(value);
        this.addMenuAction.setEnabled(value);
        this.addMenuActionFromList.setEnabled(value);
        this.editMenuTreeAction.setEnabled(value);
        this.deleteMenuTreeAction.setEnabled(value);
        this.copyAction.setEnabled(value);
        this.pasteAction.setEnabled(value);
        this.upAction.setEnabled(value);
        this.downAction.setEnabled(value);
        if (value) {
            this.menuTreeActionGroup.setEnabledAll();
        } else {
            this.menuTreeActionGroup.setDisabledAll();
        }
    }

    public void createPartControl(Composite parent) {
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.model = ModelActivator.getDefault().getModelProvider().getHierarchicalMenuItemModel();
        if (this.model.getHierarchicalMenu().getRoots().size() > 0) {
            this.model.setDefaultModel((HierarchicalMenuItem)this.model.getHierarchicalMenu().getRoots().get(0));
        }
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
        this.treeViewer = new TreeViewer(parent, 67584);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MenuTreeView.this.editMenuTreeAction.run();
            }
        });
        Tree tree = this.treeViewer.getTree();
        tree.setSortDirection(1024);
        tree.setHeaderVisible(true);
        TreeViewerColumn nameTreeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        this.nameTreeColumn = nameTreeViewerColumn.getColumn();
        this.nameTreeColumn.addSelectionListener((SelectionListener)this.sortSelectionAdapter);
        this.nameTreeColumn.setWidth(300);
        this.nameTreeColumn.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MenuTreeLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new MenuTreeContentProvider());
        try {
            this.model.getHierarchicalMenu().loadData();
        }
        catch (MenuNotFoundException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)("\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0430 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0445. \u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0435 \u043c\u0435\u043d\u044e \u0441 \u043a\u043e\u0434\u043e\u043c: \"" + e.getMenuCode() + "\", \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e. \u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u043e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e \u043c\u0435\u043d\u044e."));
        }
        catch (SubMenuNotFoundException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)("\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0430 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0445. \u041f\u043e\u0434\u043c\u0435\u043d\u044e \u0441 \u043a\u043e\u0434\u043e\u043c: \"" + e.getSubMenuCode() + "\", \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e. \u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u043e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e \u043c\u0435\u043d\u044e."));
        }
        this.treeViewer.setInput((Object)this.model.getHierarchicalMenu().getRoots());
        this.tableSorter = new TableSorter(this.tableComparator, null, this.nameTreeColumn);
        this.treeViewer.setSorter(this.tableSorter);
        this.menuTreeActionGroup = new MenuTreeActionGroup(true);
        this.menuTreeActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.addRootMenuTreeAction = new AddRootMenuTreeAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/root_add"));
        this.addSubMenuTreeAction = new AddSubMenuTreeAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/child_add"));
        this.editMenuTreeAction = new EditMenuTreeAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/edit"));
        this.deleteMenuTreeAction = new DeleteMenuTreeAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/delete"));
        this.addMenuAction = new AddMenuAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/action_add"));
        this.addMenuActionFromList = new AddMenuActionFromList(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/action_add"));
        this.copyAction = new CopyAction(ArtixAdminImages.getDefault().getImageDescriptor("copy"));
        this.pasteAction = new PasteAction(ArtixAdminImages.getDefault().getImageDescriptor("paste"));
        this.upAction = new UpAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/up"));
        this.downAction = new DownAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/down"));
        MenuManager popupMenu = new MenuManager();
        Menu menu = popupMenu.createContextMenu((Control)this.treeViewer.getTree());
        popupMenu.add(this.addRootMenuTreeAction);
        popupMenu.add(this.addSubMenuTreeAction);
        popupMenu.add(this.addMenuAction);
        popupMenu.add(this.addMenuActionFromList);
        popupMenu.add((IContributionItem)new Separator());
        popupMenu.add(this.editMenuTreeAction);
        popupMenu.add(this.deleteMenuTreeAction);
        popupMenu.add((IContributionItem)new Separator());
        popupMenu.add(this.upAction);
        popupMenu.add(this.downAction);
        popupMenu.add((IContributionItem)new Separator());
        popupMenu.add(this.copyAction);
        popupMenu.add(this.pasteAction);
        this.treeViewer.getTree().setMenu(menu);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.model.removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("REFRESH") && evt.getOldValue().equals(false)) {
            this.treeViewer.setInput((Object)this.model.getHierarchicalMenu().getRoots());
        }
        this.treeViewer.refresh();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection selectionIn = (IStructuredSelection)selection;
        if (selectionIn.getFirstElement() != null) {
            this.enabledPopupMenu(true);
            if (part instanceof MenuTreeView && selectionIn.getFirstElement() instanceof HierarchicalMenuItem) {
                HierarchicalMenuItem selectedItem = (HierarchicalMenuItem)selectionIn.getFirstElement();
                this.model.setCurrentModel(selectedItem);
                this.model.setDefaultModel(selectedItem);
                this.menuTreeActionGroup.setEnabledAll();
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                HierarchicalMenuItem clipboardItem = (HierarchicalMenuItem)clipboard.getContents((Transfer)MenuTreeTransfer.getInstance());
                this.pasteAction.setEnabled(clipboardItem != null);
                if (this.isRootMenu((HierarchicalMenuAbstract)selectedItem)) {
                    this.menuTreeActionGroup.getUpAction().setEnabled(false);
                    this.menuTreeActionGroup.getDownAction().setEnabled(false);
                    this.upAction.setEnabled(false);
                    this.downAction.setEnabled(false);
                    if (selectedItem.equals((Object)clipboardItem) || clipboardItem != null && selectedItem.equals((Object)clipboardItem.getParent())) {
                        this.pasteAction.setEnabled(false);
                    }
                }
                if (this.isSubMenu((HierarchicalMenuAbstract)selectedItem) && (selectedItem.equals((Object)clipboardItem) || clipboardItem != null && selectedItem.equals((Object)clipboardItem.getParent()))) {
                    this.pasteAction.setEnabled(false);
                }
                if (this.isActionMenu((HierarchicalMenuAbstract)selectedItem)) {
                    this.menuTreeActionGroup.getAddSubMenuTreeAction().setEnabled(false);
                    this.menuTreeActionGroup.getAddMenuActionFromList().setEnabled(false);
                    this.addSubMenuTreeAction.setEnabled(false);
                    this.addMenuAction.setEnabled(false);
                    this.addMenuActionFromList.setEnabled(false);
                    this.pasteAction.setEnabled(false);
                }
            }
        } else {
            this.enabledPopupMenu(false);
        }
    }

    private boolean isRootMenu(HierarchicalMenuAbstract item) {
        return item.getMenu() != null && item.getMenuitem() == null && item.getCmaction() != null;
    }

    private boolean isSubMenu(HierarchicalMenuAbstract item) {
        return item.getMenu() != null && item.getMenuitem() != null && item.getCmaction() != null;
    }

    private boolean isActionMenu(HierarchicalMenuAbstract item) {
        return item.getMenu() == null && item.getMenuitem() != null && item.getCmaction() != null;
    }
}

