/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.SecurityPermissionInfo;

public class SecurityPermissionsRestClient {
    private static final String SECURITY_PERMISSIONS_URL = "securityPermissions";
    private final RestInvokerManager restInvokerManager;

    public SecurityPermissionsRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    private static SecurityPermissionInfo convertSecurityPermissionToSecurityPermissionInfo(SecurityPermission securityPermission) {
        SecurityPermissionInfo info = new SecurityPermissionInfo();
        info.setSecurityObjectId(securityPermission.getSecurityObject().getId());
        info.setPermission(securityPermission.getPermission());
        return info;
    }

    public Long countSecurityPermissions() {
        return this.restInvokerManager.getRestInvoker().invokeGet("securityPermissions/count", Long.class);
    }

    public Boolean existsSecurityPermission(Integer id) {
        return this.restInvokerManager.getRestInvoker().invokeGet("securityPermissions/" + id + "/exists", Boolean.class);
    }

    public List<SecurityPermission> getSecurityPermissions() {
        ParameterizedTypeReference<List<SecurityPermission>> returnTypeRef = new ParameterizedTypeReference<List<SecurityPermission>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(SECURITY_PERMISSIONS_URL, returnTypeRef);
    }

    public void addSecurityPermission(SecurityPermission securityPermission) {
        this.restInvokerManager.getRestInvoker().invokePost(SECURITY_PERMISSIONS_URL, SecurityPermissionsRestClient.convertSecurityPermissionToSecurityPermissionInfo(securityPermission));
    }

    public SecurityPermission getSecurityPermission(Integer id) {
        return this.restInvokerManager.getRestInvoker().invokeGet("securityPermissions/" + id, SecurityPermission.class);
    }

    public void updateSecurityPermission(Integer id, SecurityPermission securityPermission) {
        this.restInvokerManager.getRestInvoker().invokePut("securityPermissions/" + id, SecurityPermissionsRestClient.convertSecurityPermissionToSecurityPermissionInfo(securityPermission));
    }

    public void removeSecurityPermission(Integer id) {
        this.restInvokerManager.getRestInvoker().invokeDelete("securityPermissions/" + id);
    }
}

