/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.goods;

import java.util.Map;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.editors.directory.goods.MultiSelectCheckBoxTableViewer;
import ru.ssa.artixadmin.editors.directory.goods.ValutEditPanel;
import ru.ssa.artixadmin.view.directory.goods.DeptViewPanel;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Dept;
import ru.ssa.cashadmin.domain.PayForbiddance;
import ru.ssa.cashadmin.domain.Valut;
import ru.ssa.cashadmin.utils.ArtixFilter;
import su.artix.cashserver.security.SecurityKey;
import su.artix.widgets.FilterElement;
import su.artix.widgets.SimpleFilterElement;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.view.DirectoryTableViewPanel;

@SecurityKey(title="\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0435 \u043e\u0442\u0434\u0435\u043b\u044b", parent=ValutEditPanel.class)
public class ValutForbiddenDeptEditPanel
extends EditorComposite<Valut> {
    private static final Logger log = LoggerFactory.getLogger(ValutForbiddenDeptEditPanel.class);
    private static final String DEPT_NOT_FOUND_IN_DB_MESSAGE = "<\u041e\u0442\u0434\u0435\u043b \u0441 \u0442\u0430\u043a\u0438\u043c \u043a\u043e\u0434\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>";
    private MultiSelectCheckBoxTableViewer<PayForbiddance, Valut, Dept> composite;

    public ValutForbiddenDeptEditPanel(Composite parent, int style, Valut model) {
        super(parent, style, Valut.class, (Object)model);
    }

    public ValutForbiddenDeptEditPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
    }

    private void createDeptValutListComposite(Composite parent) {
        this.composite = new MultiSelectCheckBoxTableViewer<PayForbiddance, Valut, Dept>(4, this.getParentDialog().getDialogMode(), (Valut)this.getModel(), PayForbiddance.class, Dept.class){

            @Override
            public Valut getPrimaryFromJoiting(PayForbiddance joiting) {
                return joiting.getValut();
            }

            @Override
            public Dept getSecondaryFromJoiting(PayForbiddance joiting) {
                return joiting.getDept();
            }

            @Override
            public PayForbiddance setPrimary(PayForbiddance joiting, Valut primary) {
                joiting.setValut(primary);
                return joiting;
            }

            @Override
            public PayForbiddance setSecondary(PayForbiddance joiting, Dept secondary) {
                joiting.setDept(secondary);
                return joiting;
            }

            @Override
            public String getTextForSelectedCheckBox() {
                return "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0435 \u043e\u0442\u0434\u0435\u043b\u044b";
            }

            @Override
            public String getTextForTopLabel() {
                return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0442\u0434\u0435\u043b\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043d\u0443\u0436\u043d\u043e \u0437\u0430\u043f\u0440\u0435\u0442\u0438\u0442\u044c \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0432\u0430\u043b\u044e\u0442\u044b:";
            }

            @Override
            public Dept createEmptySecondary(PayForbiddance payForbiddance) {
                Dept dept = (Dept)LibActivator.getDefault().getActualClassResolver().getInstance(Dept.class);
                dept.setCode(payForbiddance.getDeptcode());
                dept.setName(ValutForbiddenDeptEditPanel.DEPT_NOT_FOUND_IN_DB_MESSAGE);
                return dept;
            }

            @Override
            public boolean checkSecondaryOnEmpty(Dept secondary) {
                return secondary != null && ValutForbiddenDeptEditPanel.DEPT_NOT_FOUND_IN_DB_MESSAGE.equals(secondary.getName());
            }

            @Override
            public DirectoryTableViewPanel<Dept> getSecondaryPanel(Composite composite) {
                return new DeptViewPanel(composite, 2048, true){

                    protected int getSelectionStyle() {
                        return super.getSelectionStyle() | 0x20;
                    }

                    protected void createFilterMenu(Menu parent, Class<Dept> clazz, TableViewer viewer) {
                        this.setFilter(new ArtixFilter(clazz));
                    }

                    @Override
                    protected FilterElement getFilterElement() {
                        SimpleFilterElement secondaryFilterElement = new SimpleFilterElement(new String[]{"name"});
                        this.setFilterElement((FilterElement)secondaryFilterElement);
                        return secondaryFilterElement;
                    }
                };
            }
        };
        try {
            this.composite.createDeptValutListComposite(parent);
        }
        catch (Exception e) {
            log.error("cannot create table viewer composite: {}", (Throwable)e);
        }
        parent.layout(true, true);
    }

    public void initialize() {
        this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.setLayout((Layout)new GridLayout(1, false));
        this.createDeptValutListComposite((Composite)this);
    }

    public void bindValues() {
        this.initDefaulBinding();
    }

    public Valut getActualModel(Valut model) {
        return model;
    }

    public Map<PayForbiddance, String> getPayForbiddancesMap() {
        Valut current = (Valut)this.getModel();
        return this.composite.getChangedMap(current);
    }
}

