/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.utils.ArtixFilter;
import ru.ssa.cashadmin.utils.FilterRestriction;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.widgets.SearchTextControl;
import su.artix.widgets.TextWithClearLabel;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.SearchResult;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.search.ExtendedProperty;
import su.artix.yuki.search.SearchElement;

public abstract class SearchPanel<T>
extends Composite
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(SearchPanel.class);
    private static final int MAX_SIZE = 50;
    private final Class<T> clazz;
    private TextWithClearLabel searchTextField;
    private Button beginBtn;
    private Button endBtn;
    private Button anywhereBtn;
    private Button fullBtn;
    private SearchElement searchElement;
    private Map<String, Button> searchBtns = new HashMap<String, Button>();
    private List<T> result = new ArrayList<T>();
    final AtomicBoolean end = new AtomicBoolean(true);

    public SearchPanel(Class<T> clazz, Composite parent, int style, SearchElement searchElement) {
        super(parent, style);
        this.clazz = clazz;
        this.searchElement = searchElement;
        this.createContent();
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(clazz).addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void createContent() {
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo((Composite)this);
        this.searchTextField = new SearchTextControl(this){

            protected void doSearch() {
                SearchPanel.this.search();
            }
        };
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.searchTextField);
        Group searchGroup = new Group((Composite)this, 4);
        searchGroup.setText("\u0418\u0441\u043a\u0430\u0442\u044c:");
        searchGroup.setLayout((Layout)new RowLayout(256));
        GridDataFactory.fillDefaults().span(1, 1).grab(false, false).applyTo((Control)searchGroup);
        for (ExtendedProperty property : this.searchElement.getExtendedProperties()) {
            Button searchBtn = new Button((Composite)searchGroup, 32);
            searchBtn.setText(property.getLabel());
            searchBtn.setSelection(property.isDefaultUse());
            this.searchBtns.put(property.getProperty(), searchBtn);
        }
        Group accordanceGroup = new Group((Composite)this, 4);
        accordanceGroup.setText("\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435:");
        accordanceGroup.setLayout((Layout)new RowLayout(256));
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)accordanceGroup);
        this.beginBtn = new Button((Composite)accordanceGroup, 16);
        this.beginBtn.setText("\u0412 \u043d\u0430\u0447\u0430\u043b\u0435");
        this.endBtn = new Button((Composite)accordanceGroup, 16);
        this.endBtn.setText("\u0412 \u043a\u043e\u043d\u0446\u0435");
        this.anywhereBtn = new Button((Composite)accordanceGroup, 16);
        this.anywhereBtn.setText("\u041f\u043e \u0447\u0430\u0441\u0442\u0438");
        this.fullBtn = new Button((Composite)accordanceGroup, 16);
        this.fullBtn.setText("\u041f\u043e\u043b\u043d\u043e\u0435");
        this.fullBtn.setSelection(true);
    }

    private void search() {
        log.debug("call seach");
        this.result.clear();
        if (this.end.get()) {
            if (this.isOneSelection()) {
                final ArtixFilter filter = new ArtixFilter(this.clazz);
                boolean first = true;
                for (ExtendedProperty property : this.searchElement.getExtendedProperties()) {
                    Button btn = this.searchBtns.get(property.getProperty());
                    if (btn == null || !btn.getSelection()) continue;
                    FilterRestriction.LinkCondition linkCondition = first ? FilterRestriction.LinkCondition.unique : FilterRestriction.LinkCondition.or;
                    FilterRestriction.Condition condition = this.beginBtn.getSelection() ? FilterRestriction.Condition.like_start : (this.endBtn.getSelection() ? FilterRestriction.Condition.like_end : (this.anywhereBtn.getSelection() ? FilterRestriction.Condition.like : FilterRestriction.Condition.eq));
                    filter.add(new FilterRestriction(property.getProperty(), (Object)this.getSearchText(), linkCondition, condition, Boolean.valueOf(false)));
                    first = false;
                }
                final String conn = ArtixAdminContextHolder.getConnectionId();
                final Display display = Display.getCurrent();
                IRunnableWithProgress job = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("\u041f\u043e\u0438\u0441\u043a...", -1);
                        SearchPanel.this.end.set(false);
                        ArtixAdminContextHolder.setConnectionId((String)conn);
                        SearchPanel.this.result = ModelActivator.getDefault().getModelProvider().getDirectoryModel(SearchPanel.this.clazz).getList(null, true, (Object)filter, Integer.valueOf(0), Integer.valueOf(50));
                        display.wake();
                        SearchPanel.this.end.set(true);
                        monitor.done();
                    }
                };
                try {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                    dialog.setCancelable(false);
                    dialog.run(true, false, job);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                if (this.result.isEmpty()) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", (String)"\u041d\u0438 \u043e\u0434\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438, \u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u044f\u044e\u0449\u0435\u0439 \u0412\u0430\u0448\u0435\u043c\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0443, \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e!");
                }
            } else {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", (String)"\u0427\u0442\u043e\u0431\u044b \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u0438\u0441\u043a, \u0437\u0430\u0434\u0430\u0439\u0442\u0435 \u043e\u0434\u0438\u043d, \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043a\u0440\u0438\u0442\u0435\u0440\u0438\u0435\u0432 \u043f\u043e\u0438\u0441\u043a\u0430.");
            }
        }
        this.doResult(new SearchResult(this.result));
    }

    protected abstract void doResult(SearchResult<T> var1);

    private String getSearchText() {
        return StringUtils.trim((String)this.searchTextField.getText());
    }

    private boolean isOneSelection() {
        boolean result = false;
        for (ExtendedProperty extendedProperty : this.searchElement.getExtendedProperties()) {
            Button btn = this.searchBtns.get(extendedProperty.getProperty());
            if (btn == null || !btn.getSelection()) continue;
            result = true;
        }
        return result;
    }

    public void dispose() {
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz).removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        final String connectionId = ArtixAdminContextHolder.getConnectionId();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArtixAdminContextHolder.setConnectionId((String)connectionId);
                if (DirectoryAction.UPDATE.toString().equals(evt.getPropertyName())) {
                    if (SearchPanel.this.result.contains(evt.getNewValue())) {
                        SearchPanel.this.result.set(SearchPanel.this.result.indexOf(evt.getNewValue()), evt.getNewValue());
                    } else {
                        SearchPanel.this.result.clear();
                    }
                    SearchPanel.this.doResult(new SearchResult(SearchPanel.this.result));
                } else if (DirectoryAction.CHANGE_ID.toString().equals(evt.getNewValue()) || DirectoryAction.REMOVE.toString().equals(evt.getNewValue())) {
                    SearchPanel.this.result.clear();
                    SearchPanel.this.doResult(new SearchResult(SearchPanel.this.result));
                }
            }
        });
    }
}

