/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Card;
import ru.ssa.cashadmin.domain.CardAudit;
import ru.ssa.cashadmin.domain.Certificate;
import ru.ssa.cashadmin.domain.Client;
import ru.ssa.cashadmin.domain.EnversRevEntity;
import su.artix.accounting.domain.AssetGroup;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.audit.compare.CardAuditDialog;
import su.artix.discountmanager.dialogs.assetgroup.AssetGroupDialog;
import su.artix.discountmanager.dialogs.cards.CardSelectDialog;
import su.artix.discountmanager.dialogs.cards.CertificateEditDialog;
import su.artix.discountmanager.dialogs.cards.DiscountCardDialog;
import su.artix.discountmanager.dialogs.clients.ClientDialog;
import su.artix.discountmanager.dialogs.clients.ClientSelectDialog;
import su.artix.discountmanager.discountsystem.compare.view.DiscountHistoryView;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.providers.accounting.ExctendedBonusInfoProvider;
import su.artix.discountmanager.providers.discountsystem.CachedTags;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;
import su.artix.discountmanager.views.DiscountSystemUndoRedoToolbar;
import su.artix.discountmanager.views.EarnBonusSystemView;
import su.artix.discountmanager.views.IViewPartCustomize;
import su.artix.discountmanager.views.LimitBonusSystemView;
import su.artix.discountmanager.views.PeriodicImpactsBonusSystemView;
import su.artix.discountmanager.views.SecondSystemView;
import su.artix.discountmanager.views.TreeUtils;
import su.artix.discountmanagercore.dao.accounting.AccountingDAO;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.EarnBonusSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.LimitBonusSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.PeriodicImpactsBonusSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.SecondSystemDAO;
import su.artix.loyaltylib.convertor.discountsystem.PythonInterpreterFactory;
import su.artix.yuki.bundle.ServiceUtils;
import su.artix.yuki.directory.GuiActivator;

public class Activator
extends AbstractUIPlugin {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "su.artix.discountmanager";
    private static Activator plugin;
    private BundleContext context;
    private ExctendedBonusInfoProvider bonusInfoProvider;
    private Long accountingVersion;
    private Job pythonInterpreterInitJob;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.context = context;
        log.trace("DiscountManager-2.1:start()");
        GuiActivator.getDefault().getCombinationService().put(Card.class, DiscountCardDialog.class, CardSelectDialog.class);
        GuiActivator.getDefault().getCombinationService().put(Client.class, ClientDialog.class, ClientSelectDialog.class);
        GuiActivator.getDefault().getCombinationService().put(AssetGroup.class, AssetGroupDialog.class, null);
        GuiActivator.getDefault().getCombinationService().put(EnversRevEntity.class, DiscountHistoryView.class, null);
        GuiActivator.getDefault().getCombinationService().put(CardAudit.class, CardAuditDialog.class, null);
        GuiActivator.getDefault().getCombinationService().put(Certificate.class, CertificateEditDialog.class, null);
        ArrayList<String> bundleLocations = new ArrayList<String>();
        bundleLocations.add(String.valueOf(Activator.locateBundle("loyaltylib-domain-python")) + "/Lib");
        bundleLocations.add(String.valueOf(Activator.locateBundle("jython")) + "/Lib");
        PythonInterpreterFactory.addBundleLocations(bundleLocations);
        this.pythonInterpreterInitJob = new Job("PythonInterpreterInitJob"){

            protected IStatus run(IProgressMonitor monitor) {
                PythonInterpreterFactory.resolveInterpreter();
                return Status.OK_STATUS;
            }
        };
        this.pythonInterpreterInitJob.schedule();
        if (LibActivator.getDefault().getDictionaryVersion() > 10) {
            LoadTagsJob loadTagsJob = new LoadTagsJob("Load tags", ArtixAdminContextHolder.getConnectionId());
            loadTagsJob.schedule();
        }
        if (ArtixAdminContextHolder.isCashserver()) {
            Job extendedBonusInfo = new Job("extendedBonusInfo"){

                protected IStatus run(IProgressMonitor monitor) {
                    Activator.this.bonusInfoProvider = new ExctendedBonusInfoProvider();
                    Activator.this.bonusInfoProvider.init();
                    return Status.OK_STATUS;
                }
            };
            extendedBonusInfo.schedule();
            Job accountingVersionJob = new Job("accountingVersion"){

                protected IStatus run(IProgressMonitor monitor) {
                    Activator.this.accountingVersion = Activator.this.getBeanByClass(AccountingDAO.class).getVersion();
                    return Status.OK_STATUS;
                }
            };
            accountingVersionJob.schedule();
        }
    }

    private static String locateBundle(String bundleName) {
        String locatePythonHome;
        Bundle bundle = Platform.getBundle((String)bundleName);
        try {
            locatePythonHome = FileLocator.getBundleFile((Bundle)bundle).getAbsolutePath();
        }
        catch (IOException iOException) {
            locatePythonHome = bundle.getLocation().replaceFirst("reference:file:/", "");
        }
        log.trace("pythonHome={}", (Object)locatePythonHome);
        return locatePythonHome;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        log.trace("DiscountManager-2.1:stop()");
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void setLoadCursor(final boolean value) {
        if (Display.getCurrent().getActiveShell() != null) {
            Display.getCurrent().syncExec(new Runnable(){

                @Override
                public void run() {
                    int type = 0;
                    type = value ? 1 : 0;
                    Display.getCurrent().getActiveShell().setCursor(new Cursor((Device)Display.getCurrent(), type));
                }
            });
        }
    }

    public <T> T getBeanByClass(Class<T> clazz) {
        return (T)ServiceUtils.getBeanByClass((BundleContext)this.context, clazz);
    }

    public <T> T getBeanByClass(Class<T> clazz, String beanName) {
        return (T)ServiceUtils.getBeanByClass((BundleContext)this.context, clazz, (String)beanName);
    }

    public boolean saveDiscountSystems() {
        IWorkbenchPart view = ViewHolder.INSTANCE.getActiveViewPart();
        if (view != null && view.getSite().getSelectionProvider() instanceof CustomSystemTreeViewer) {
            CustomSystemTreeViewer treeViewer = (CustomSystemTreeViewer)view.getSite().getSelectionProvider();
            return treeViewer.saveSystemTreeWithRequest();
        }
        return true;
    }

    public void refrashModels() {
        try {
            List<String> IDs = ViewHolder.INSTANCE.getLoadedDiscountSystemViewIds();
            for (String ID : IDs) {
                log.debug("System view {} reloading", (Object)ID);
                CustomSystemTreeViewer systemTree = null;
                IViewPart discountSystemView = ViewHolder.INSTANCE.getViewPart(ID);
                systemTree = (CustomSystemTreeViewer)discountSystemView.getSite().getSelectionProvider();
                DiscountSystemContentProvider provider = (DiscountSystemContentProvider)systemTree.getContentProvider();
                if (provider != null) {
                    provider.getMap().remove(ArtixAdminContextHolder.getConnectionId());
                    IViewPartCustomize dsView = (IViewPartCustomize)ViewHolder.INSTANCE.getViewPart(ID);
                    dsView.setIsChangedView(false);
                    boolean isCustomSystemTreeViewerHistoryInitialized = systemTree.isHistoryAlreadyInitialized();
                    provider.refresh(!isCustomSystemTreeViewerHistoryInitialized);
                    if (ViewHolder.INSTANCE.getActiveViewPart().equals(discountSystemView)) {
                        DiscountSystemUndoRedoToolbar.setItemPlace(systemTree.showCurrentChange());
                    }
                } else {
                    log.warn("Content provider for {} is null!!!", (Object)ID);
                }
                systemTree.refresh();
                TreeUtils.expandTreeToGroups(systemTree);
            }
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public AtomicLong next(DiscountSystemDAO.SystemType systemType) {
        DiscountSystemDAO dao = null;
        switch (systemType) {
            case DISCOUNT_SYSTEM: {
                dao = Activator.getDefault().getBeanByClass(DiscountSystemDAO.class);
                break;
            }
            case LIMIT_BONUS_SYSTEM: {
                dao = (DiscountSystemDAO)Activator.getDefault().getBeanByClass(LimitBonusSystemDAO.class);
                break;
            }
            case EARN_BONUS_SYSTEM: {
                dao = (DiscountSystemDAO)Activator.getDefault().getBeanByClass(EarnBonusSystemDAO.class);
                break;
            }
            case PERIODIC_IMPACTS_BONUS_SYSTEM: {
                dao = (DiscountSystemDAO)Activator.getDefault().getBeanByClass(PeriodicImpactsBonusSystemDAO.class);
                break;
            }
            case SECOND_SYSTEM: {
                dao = (DiscountSystemDAO)Activator.getDefault().getBeanByClass(SecondSystemDAO.class);
            }
        }
        AtomicLong next = dao.getMaxId(systemType);
        return next;
    }

    public DiscountSystemDAO.SystemType getTypeByView(Object obj) {
        if (obj instanceof EarnBonusSystemView) {
            return DiscountSystemDAO.SystemType.EARN_BONUS_SYSTEM;
        }
        if (obj instanceof LimitBonusSystemView) {
            return DiscountSystemDAO.SystemType.LIMIT_BONUS_SYSTEM;
        }
        if (obj instanceof PeriodicImpactsBonusSystemView) {
            return DiscountSystemDAO.SystemType.PERIODIC_IMPACTS_BONUS_SYSTEM;
        }
        if (obj instanceof SecondSystemView) {
            return DiscountSystemDAO.SystemType.SECOND_SYSTEM;
        }
        return DiscountSystemDAO.SystemType.DISCOUNT_SYSTEM;
    }

    public ExctendedBonusInfoProvider getBonusInfoProvider() {
        return this.bonusInfoProvider;
    }

    public Job getPythonInterpreterInitJob() {
        return this.pythonInterpreterInitJob;
    }

    public Long getAccountingVersion() {
        return this.accountingVersion;
    }

    private class LoadTagsJob
    extends Job {
        private static final int HIBERNATE_SESSION_WAIT_SLEEP_TIMEOUT = 500;
        private static final int HIBERNATE_SESSION_WAIT_ATTEMPT_COUNT = 20;
        private String connectionId;

        public LoadTagsJob(String name, String connectionId) {
            super(name);
            this.connectionId = connectionId;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ArtixAdminContextHolder.setConnectionId((String)this.connectionId);
            int attempts = 20;
            while (!ArtixAdminContextHolder.isHibernateSessionInited() && attempts-- > 0) {
                try {
                    log.trace("White while sessionManager inited...");
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            CachedTags.init();
            return Status.OK_STATUS;
        }
    }
}

