/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.cards;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.SWTResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import ru.ssa.cashadmin.domain.ICard;
import su.artix.accounting.domain.Asset;
import su.artix.accounting.domain.AssetGroup;
import su.artix.accounting.domain.AssetTransactionStatus;
import su.artix.accounting.domain.CardStatus;
import su.artix.accounting.domain.TransactionStatus;
import su.artix.accounting.rpc.logic.LocationNotFound;
import su.artix.cashserver.security.SecurityAction;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.accounting.AccountingDialog;
import su.artix.discountmanager.dialogs.cards.SecondTabBonusComposite;
import su.artix.discountmanager.handlers.cards.ChangeCardStatusAction;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanager.utils.ItemsText;
import su.artix.discountmanagercore.dao.accounting.AccountingDAO;
import su.artix.discountmanagercore.holders.PropertiesHolder;
import su.artix.discountmanagercore.model.accounting.Accounting;
import su.artix.discountmanagercore.model.accounting.AccountingResult;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.model.ModelActivator;

@SecurityKey(title="\u0411\u043e\u043d\u0443\u0441\u044b")
public class CardAccountingEditPanel
extends EditorComposite<ICard> {
    private static final String SERVER_IS_NOT_AVALIABLE_1 = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043e \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430,\n \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 \u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0435\u0442\u0438";
    private static final String SERVER_IS_NOT_AVALIABLE_2 = "\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u043e \u043f\u0440\u043e\u043f\u0430\u043b\u0430 \u0441\u0432\u044f\u0437\u044c \u0434\u043e \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430,\n \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u044c \u0441\u0435\u0442\u0438";
    private static final Logger log = LoggerFactory.getLogger(CardAccountingEditPanel.class);
    @SecurityKey(title="\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c")
    private IAction refreshAction;
    @SecurityKey(title="\u041d\u0430\u0447\u0438\u0441\u043b\u0438\u0442\u044c \u0431\u043e\u043d\u0443\u0441\u044b")
    private AddAssetAction addAction;
    @SecurityKey(title="\u0421\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u043e\u043d\u0443\u0441\u044b")
    private SubAssetAction subAction;
    @SecurityKey(title="\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c")
    private CancelAssetAction cancelAction;
    @SecurityKey(title="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u043a\u0430\u0440\u0442\u044b")
    private IAction changeCardStatusAction;
    @SecurityKey(title="\u0422\u0430\u0431\u043b\u0438\u0446\u0430")
    private SecondTabBonusComposite secondTabBonus;
    @SecurityKey(title="\u041f\u0435\u043d\u0435\u043b\u044c \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")
    private Composite locationNotFoundComposite = null;

    public CardAccountingEditPanel(Composite parent, int style, Class clazz, ICard model) {
        super(parent, style, clazz, (Object)model);
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        if (this.getModel() != null) {
            try {
                AccountingResult resultCardExist = Activator.getDefault().getBeanByClass(AccountingDAO.class).cardExists(((ICard)this.getModel()).getNumber());
                this.secondTabBonus = new SecondTabBonusComposite((Composite)this, 4);
                this.refreshAction = new RefreshBonusAction();
                this.addAction = new AddAssetAction();
                this.subAction = new SubAssetAction();
                this.cancelAction = new CancelAssetAction();
                this.changeCardStatusAction = new ChangeCardStatusAction(){

                    @Override
                    public void runAction() {
                        try {
                            log.trace("begin change card status [accounting]");
                            AccountingResult result = Activator.getDefault().getBeanByClass(AccountingDAO.class).setCardStatus(((ICard)CardAccountingEditPanel.this.getModel()).getNumber(), this.getCardStatus());
                            log.trace("end change card status [accounting]");
                            if (CardAccountingEditPanel.this.checkAccountingResult(result)) {
                                log.trace("begin change card status [db]");
                                ICard card = (ICard)CardAccountingEditPanel.this.getModel();
                                PropertyUtils.setProperty((Object)card, (String)"cardstatus", (Object)this.cardStatusConvert(this.getCardStatus()));
                                ModelActivator.getDefault().getModelProvider().getDirectoryModel(CardAccountingEditPanel.this.getClazz()).update((Object)card);
                                log.trace("end change card status [db]");
                            }
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        CardAccountingEditPanel.this.updateBonusPanel();
                    }
                };
                this.changeCardStatusAction.setEnabled(true);
                this.refreshAction.setEnabled(false);
                this.subAction.setEnabled(false);
                this.cancelAction.setEnabled(false);
                this.subAction.setEnabled(false);
                this.secondTabBonus.setToolBarActions(new IAction[]{this.refreshAction, this.addAction, this.subAction, this.cancelAction, this.changeCardStatusAction});
                this.secondTabBonus.getAccountingTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (CardAccountingEditPanel.this.cancelAction != null && CardAccountingEditPanel.this.cancelAction.isSecurityEnabled()) {
                            if (((StructuredSelection)event.getSelection()).getFirstElement() instanceof Asset) {
                                Asset asset = (Asset)((StructuredSelection)event.getSelection()).getFirstElement();
                                if (asset != null) {
                                    if (asset.getLastStatus() == TransactionStatus.CANCELLED) {
                                        CardAccountingEditPanel.this.cancelAction.setEnabled(false);
                                    } else {
                                        CardAccountingEditPanel.this.cancelAction.setEnabled(true);
                                    }
                                } else {
                                    CardAccountingEditPanel.this.cancelAction.setEnabled(false);
                                }
                            } else if (((StructuredSelection)event.getSelection()).getFirstElement() instanceof AssetTransactionStatus) {
                                CardAccountingEditPanel.this.cancelAction.setEnabled(false);
                            }
                        }
                    }
                });
                this.secondTabBonus.setBalanceText("\u0411\u0430\u043b\u0430\u043d\u0441: 0");
                this.secondTabBonus.getAccountingTreeViewer().setInput((Object)((ICard)this.getModel()).getNumber());
                this.activateControls(resultCardExist.isSuccess());
                this.updateBonusPanel();
            }
            catch (LocationNotFound e) {
                log.error(e.getMessage());
                this.createDummyComposite((Composite)this, SERVER_IS_NOT_AVALIABLE_1);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.createDummyComposite((Composite)this, SERVER_IS_NOT_AVALIABLE_2);
            }
        }
    }

    private void showLocationNotFoundExceptionMessage(Exception exception) {
        ErrorMessageFactory.generalErrorMessage("\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d", SERVER_IS_NOT_AVALIABLE_2, exception.getMessage());
    }

    protected void updateBonusPanel() {
        String cardStatus = "";
        String stringBalance = "\u0411\u0430\u043b\u0430\u043d\u0441: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
        try {
            AccountingDAO accountingDAO = Activator.getDefault().getBeanByClass(AccountingDAO.class);
            Long balance = 0L;
            balance = accountingDAO.balance(((ICard)this.getModel()).getNumber()).getBalance();
            CardStatus cardStatusInner = accountingDAO.getCardStatus(((ICard)this.getModel()).getNumber());
            if (cardStatusInner != null) {
                cardStatus = "\u0421\u0442\u0430\u0442\u0443\u0441 \u043a\u0430\u0440\u0442\u044b: " + ItemsText.accountingCardStatusItem.get(cardStatusInner);
            }
            stringBalance = "\u0411\u0430\u043b\u0430\u043d\u0441:" + String.format("%.2f", Float.valueOf((float)balance.longValue() / 100.0f));
        }
        catch (LocationNotFound e) {
            this.showLocationNotFoundExceptionMessage((Exception)((Object)e));
            log.warn("{}", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.warn("{}", (Object)e.getMessage());
        }
        this.secondTabBonus.setBalanceText(stringBalance);
        this.secondTabBonus.setStatusText(cardStatus);
        this.secondTabBonus.disposeContent();
        this.secondTabBonus.getAccountingTreeViewer().refresh();
    }

    private String getSource() {
        return PropertiesHolder.INSTANCE.getAccountingProperty("source");
    }

    public void dispose() {
        if (this.secondTabBonus != null) {
            this.secondTabBonus.dispose();
        }
        super.dispose();
    }

    protected ICard getActualModel(ICard model) {
        return model;
    }

    private boolean checkAccountingResult(AccountingResult accountingResult) {
        if (accountingResult == null) {
            ErrorMessageFactory.generalErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0430", "\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u043e\u0442\u0432\u0435\u0442\u0438\u043b \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441.");
            log.warn("Operation didn't execute on accounting server, may be operation didn't support on your version of accounting server");
            return false;
        }
        if (!accountingResult.isSuccess()) {
            log.debug("{}", (Object)accountingResult);
            String errorMessage = null;
            if (accountingResult.getSessionId() == null) {
                errorMessage = accountingResult.getDescription();
            } else {
                BigDecimal balance = new BigDecimal(accountingResult.getBalance());
                balance = balance.movePointLeft(2);
                errorMessage = "ID \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438: " + accountingResult.getSessionId() + "; \u0411\u0430\u043b\u0430\u043d\u0441: " + balance + "; \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: " + accountingResult.getDescription();
            }
            ErrorMessageFactory.generalErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0443\u0434\u0430\u043b\u0430\u0441\u044c.", errorMessage);
        }
        return accountingResult.isSuccess();
    }

    private void activateControls(boolean activate) {
        if (this.addAction != null) {
            this.refreshAction.setEnabled(activate);
            this.addAction.setEnabled(activate);
            this.subAction.setEnabled(activate);
            this.secondTabBonus.getAccountingTreeViewer().getTree().setEnabled(activate);
        }
    }

    private void createDummyComposite(Composite parent, String message) {
        if (this.locationNotFoundComposite == null) {
            this.locationNotFoundComposite = new Composite((Composite)this, 4);
            this.locationNotFoundComposite.setLayout((Layout)new RowLayout(512));
            Label labelWarinng = new Label(this.locationNotFoundComposite, 68);
            labelWarinng.setText(message);
            labelWarinng.setFont(SWTResourceManager.getFont("Tahoma", 12, 1));
            labelWarinng.setForeground(SWTResourceManager.getColor(14));
            Label labelParameters = new Label(this.locationNotFoundComposite, 68);
            AccountingDAO accountingDAO = Activator.getDefault().getBeanByClass(AccountingDAO.class);
            labelParameters.setText(String.format("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: \n%s", StringUtils.collectionToDelimitedString((Collection)accountingDAO.getConnectParameters(), (String)"\n", (String)" ", (String)"")));
        }
    }

    private AssetGroup getAssetGroup(Accounting model) {
        AssetGroup assetGroup = null;
        if (model.isRestriction()) {
            assetGroup = new AssetGroup();
            assetGroup.setGroupId(model.getGroupId());
            assetGroup.setBegin(model.getBeginDate());
            assetGroup.setEnd(model.getEndDate());
            assetGroup.setWeight(Integer.valueOf(model.getWeight() == null ? 0 : model.getWeight()));
        }
        return assetGroup;
    }

    private boolean isOldVersion() {
        return Activator.getDefault().getAccountingVersion() < 277L;
    }

    private class AddAssetAction
    extends Action {
        public AddAssetAction() {
            super("&\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0431\u043e\u043d\u0443\u0441", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/add.png"));
        }

        public void run() {
            AccountingDialog dialog = new AccountingDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0431\u043e\u043d\u0443\u0441\u0430", false);
            if (dialog.open() == 0) {
                try {
                    AccountingDAO accountingDAO = Activator.getDefault().getBeanByClass(AccountingDAO.class);
                    String sessionId = UUID.randomUUID().toString();
                    Accounting model = dialog.getActualModel();
                    AssetGroup assetGroup = CardAccountingEditPanel.this.getAssetGroup(model);
                    if (CardAccountingEditPanel.this.checkAccountingResult(accountingDAO.add(sessionId, ((ICard)CardAccountingEditPanel.this.getModel()).getNumber(), model.getAmount().longValue(), CardAccountingEditPanel.this.getSource(), model.getReason(), assetGroup))) {
                        if (CardAccountingEditPanel.this.isOldVersion()) {
                            CardAccountingEditPanel.this.checkAccountingResult(accountingDAO.setTransactionReason(sessionId, 0, model.getReason()));
                        }
                        CardAccountingEditPanel.this.updateBonusPanel();
                    }
                }
                catch (LocationNotFound e) {
                    CardAccountingEditPanel.this.showLocationNotFoundExceptionMessage((Exception)((Object)e));
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private class CancelAssetAction
    extends Action
    implements SecurityAction {
        private boolean securityEnabled;

        public CancelAssetAction() {
            super("&\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0431\u043e\u043d\u0443\u0441", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/delete.png"));
            this.securityEnabled = true;
        }

        public void run() {
            Object selectedElement = ((StructuredSelection)CardAccountingEditPanel.this.secondTabBonus.getAccountingTreeViewer().getSelection()).getFirstElement();
            if (selectedElement instanceof Asset) {
                Asset asset = (Asset)selectedElement;
                AccountingDialog dialog = new AccountingDialog("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0431\u043e\u043d\u0443\u0441", true);
                if (dialog.open() == 0) {
                    try {
                        AccountingDAO accountingDAO = Activator.getDefault().getBeanByClass(AccountingDAO.class);
                        Accounting model = dialog.getActualModel();
                        if (CardAccountingEditPanel.this.checkAccountingResult(Activator.getDefault().getBeanByClass(AccountingDAO.class).cancel(asset.getSessionId(), asset.getStatus(), CardAccountingEditPanel.this.getSource(), model.getReason()))) {
                            if (CardAccountingEditPanel.this.isOldVersion()) {
                                CardAccountingEditPanel.this.checkAccountingResult(accountingDAO.setTransactionReason(asset.getSessionId(), asset.getTransactionStatuses().size(), model.getReason()));
                            }
                            CardAccountingEditPanel.this.updateBonusPanel();
                        }
                    }
                    catch (LocationNotFound e) {
                        CardAccountingEditPanel.this.showLocationNotFoundExceptionMessage((Exception)((Object)e));
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        public boolean isSecurityEnabled() {
            return this.securityEnabled;
        }

        public void setSecurityEnabled(boolean securityEnabled) {
            this.securityEnabled = securityEnabled;
        }
    }

    private class RefreshBonusAction
    extends Action {
        public RefreshBonusAction() {
            super("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/refresh.png"));
        }

        public void run() {
            CardAccountingEditPanel.this.updateBonusPanel();
        }
    }

    private class SubAssetAction
    extends Action {
        public SubAssetAction() {
            super("&\u0421\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u043e\u043d\u0443\u0441", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/clear.png"));
        }

        public void run() {
            AccountingDialog dialog = new AccountingDialog("\u0421\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0431\u043e\u043d\u0443\u0441\u0430", false);
            if (dialog.open() == 0) {
                try {
                    AccountingDAO accountingDAO = Activator.getDefault().getBeanByClass(AccountingDAO.class);
                    String sessionId = UUID.randomUUID().toString();
                    Accounting model = dialog.getActualModel();
                    AssetGroup assetGroup = CardAccountingEditPanel.this.getAssetGroup(model);
                    if (CardAccountingEditPanel.this.checkAccountingResult(accountingDAO.sub(sessionId, ((ICard)CardAccountingEditPanel.this.getModel()).getNumber(), model.getAmount().longValue(), CardAccountingEditPanel.this.getSource(), model.getReason(), assetGroup))) {
                        if (CardAccountingEditPanel.this.isOldVersion()) {
                            CardAccountingEditPanel.this.checkAccountingResult(accountingDAO.setTransactionReason(sessionId, 0, model.getReason()));
                        }
                        CardAccountingEditPanel.this.updateBonusPanel();
                    }
                }
                catch (LocationNotFound e) {
                    CardAccountingEditPanel.this.showLocationNotFoundExceptionMessage((Exception)((Object)e));
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

