/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.controls;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControlListener;
import su.artix.discountmanager.images.ImagesFactory;

public abstract class DiscountConditionMultiControl
implements DiscountConditionControl {
    private List<Control> controls;
    private DiscountConditionControlListener listener;
    private ScrolledComposite scrolledPanel;
    private Composite mainPanel;
    private Composite innerPanel;
    private SelectionAdapter adapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionMultiControl.this.addControl(DiscountConditionMultiControl.this.innerPanel, false);
            DiscountConditionMultiControl.this.innerPanel.layout();
            DiscountConditionMultiControl.this.innerPanel.pack();
            DiscountConditionMultiControl.this.innerPanel.redraw();
            DiscountConditionMultiControl.this.innerPanel.getParent().layout();
            DiscountConditionMultiControl.this.innerPanel.getParent().pack();
            DiscountConditionMultiControl.this.innerPanel.getParent().redraw();
            if (DiscountConditionMultiControl.this.listener != null) {
                DiscountConditionMultiControl.this.listener.exec();
            }
            DiscountConditionMultiControl.this.scrolledPanel.setMinSize(DiscountConditionMultiControl.this.mainPanel.computeSize(-1, -1));
        }
    };

    public DiscountConditionMultiControl(Composite parent, String labelName, String defaultValue) {
        this.controls = new LinkedList<Control>();
        String defValue = defaultValue;
        this.scrolledPanel = new ScrolledComposite(parent, 512);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo((Composite)this.scrolledPanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.scrolledPanel);
        this.scrolledPanel.setExpandHorizontal(true);
        this.scrolledPanel.setExpandVertical(true);
        this.mainPanel = new Composite((Composite)this.scrolledPanel, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(this.mainPanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mainPanel);
        this.scrolledPanel.setContent((Control)this.mainPanel);
        Label label = new Label(this.mainPanel, 0);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        label.setText(labelName);
        this.innerPanel = new Composite(this.mainPanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.innerPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.innerPanel);
        if (defValue != null && !defValue.isEmpty()) {
            boolean first = true;
            if (defValue.startsWith("[") && defValue.endsWith("]")) {
                defValue = defValue.substring(1, defValue.length() - 1);
            }
            String[] stringArray = defValue.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                this.addControl(this.innerPanel, first, val);
                first = false;
                ++n2;
            }
        } else {
            this.addControl(this.innerPanel, true);
        }
        Button or = new Button(this.mainPanel, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)or);
        or.setText("\u0438\u043b\u0438");
        or.addSelectionListener((SelectionListener)this.adapter);
    }

    public abstract Control createControl(Composite var1, String var2);

    public abstract String getControlText(Control var1);

    private void addControl(Composite parent, boolean isFirst) {
        this.addControl(parent, isFirst, null);
    }

    private void addControl(Composite parent, boolean isFirst, String value) {
        Label label = null;
        if (!isFirst) {
            label = new Label(parent, 0);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
            label.setText("\u0438\u043b\u0438");
        }
        final Label forRemove = label;
        final Control control = this.createControl(parent, value);
        control.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (DiscountConditionMultiControl.this.listener != null) {
                    DiscountConditionMultiControl.this.listener.exec();
                }
            }
        });
        control.setFocus();
        this.controls.add(control);
        if (!isFirst) {
            final Button del = new Button(parent, 8);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)del);
            del.setImage(ImagesFactory.INSTANCE.getImage("16x16/plane/delete.png"));
            del.setData((Object)control);
            del.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    control.setVisible(false);
                    control.dispose();
                    forRemove.setVisible(false);
                    forRemove.dispose();
                    del.setVisible(false);
                    del.dispose();
                    DiscountConditionMultiControl.this.controls.remove(control);
                    DiscountConditionMultiControl.this.innerPanel.pack();
                    DiscountConditionMultiControl.this.innerPanel.getParent().pack();
                    if (DiscountConditionMultiControl.this.listener != null) {
                        DiscountConditionMultiControl.this.listener.exec();
                    }
                    DiscountConditionMultiControl.this.scrolledPanel.setMinSize(DiscountConditionMultiControl.this.mainPanel.computeSize(-1, -1));
                }
            });
        }
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Control control : this.controls) {
            String text = this.getControlText(control);
            if (text == null || text.isEmpty()) continue;
            sb.append(text);
            sb.append(",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getDesc() {
        return this.getText();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void addListener(DiscountConditionControlListener newLstener) {
        this.listener = newLstener;
    }
}

