/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.mihalis.opal.preferenceWindow.enabler.Enabler;

public abstract class PWWidget {
    private final String propertyKey;
    private final String label;
    protected Enabler enabler;
    private final List<Control> controls;
    private int alignment = 1;
    private int indent = 0;
    private int width = 100;
    private int height = -1;
    protected int numberOfColumns = 1;
    private boolean grabExcessSpace = false;
    private boolean singleWidget = false;

    protected PWWidget(String string, String string2, int n, boolean bl) {
        this.label = string;
        this.propertyKey = string2;
        this.numberOfColumns = n;
        this.singleWidget = bl;
        this.controls = new ArrayList<Control>();
    }

    protected abstract Control build(Composite var1);

    protected void buildLabel(Composite composite, int n) {
        if (this.getLabel() != null) {
            Label label = new Label(composite, 0);
            label.setText(this.getLabel());
            GridData gridData = new GridData(3, n, false, false);
            gridData.horizontalIndent = this.getIndent();
            label.setLayoutData((Object)gridData);
            this.addControl((Control)label);
        }
    }

    protected abstract void check();

    public Control checkAndBuild(Composite composite) {
        this.check();
        return this.build(composite);
    }

    public boolean enableOrDisable() {
        if (this.enabler == null) {
            return true;
        }
        boolean bl = this.enabler.isEnabled();
        for (Control control : this.controls) {
            if (control.isDisposed()) continue;
            control.setEnabled(bl);
        }
        return bl;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public boolean isGrabExcessSpace() {
        return this.grabExcessSpace;
    }

    public int getHeight() {
        return this.height;
    }

    public int getIndent() {
        return this.indent;
    }

    public String getLabel() {
        return this.label;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    String getPropertyKey() {
        return this.propertyKey;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isSingleWidget() {
        return this.singleWidget;
    }

    protected void addControl(Control control) {
        this.controls.add(control);
    }

    public PWWidget setAlignment(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new UnsupportedOperationException("Value should be one of the following :GridData.BEGINNING, GridData.CENTER, GridData.END, GridData.FILL");
        }
        this.alignment = n;
        return this;
    }

    public PWWidget setEnabler(Enabler enabler) {
        this.enabler = enabler;
        this.enabler.injectWidget(this);
        return this;
    }

    public PWWidget setGrabExcessSpace(boolean bl) {
        this.grabExcessSpace = bl;
        return this;
    }

    public PWWidget setHeight(int n) {
        this.height = n;
        return this;
    }

    public PWWidget setIndent(int n) {
        this.indent = n;
        return this;
    }

    public PWWidget setWidth(int n) {
        this.width = n;
        return this;
    }
}

