/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.security.GuiElementController;
import su.artix.yuki.binding.ReflectionDataBinding;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.editors.CommonEditorComposite;
import su.artix.yuki.editors.DirectoryEditDialog;

public abstract class EditorComposite<T>
extends CommonEditorComposite<T> {
    private static final Logger log = LoggerFactory.getLogger(EditorComposite.class);
    private DirectoryEditDialog<T> parentDialog;

    public EditorComposite(Composite parent, int style) {
        super(parent, style);
    }

    public EditorComposite(Composite parent, int style, Class<T> clazz, T model) {
        super(parent, style, clazz, model);
    }

    public void setParentDialog(DirectoryEditDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public PropertyChangeListener getValidatorListener() {
        if (this.getParentDialog() != null) {
            return this.getParentDialog().getValidatorListener();
        }
        return null;
    }

    public DirectoryEditDialog<T> getParentDialog() {
        return this.parentDialog;
    }

    public void switchID() {
        log.trace("switchID for autoChangedValue:{}", (Object)this.autoChangedValue);
        if (this.autoChangedValue != null) {
            this.autoChangedValue.setValue(this.getDirectoryModel().getNextId());
        }
    }

    public void applyRights() {
        this.applyRights(null);
        for (EditorComposite<T> child : this.getChildPanels()) {
            child.applyRights(null);
        }
    }

    public List<EditorComposite<T>> getChildPanels() {
        ArrayList<EditorComposite<T>> childPanels = new ArrayList<EditorComposite<T>>();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof TabFolder) {
                TabFolder tab = (TabFolder)control;
                this.findChildsForTab(childPanels, tab);
            }
            if (control instanceof Group) {
                Group group = (Group)control;
                this.findChildsForGroup(childPanels, group);
            }
            if (control instanceof EditorComposite) {
                childPanels.add((EditorComposite)control);
            }
            ++n2;
        }
        return childPanels;
    }

    private void findChildsForTab(List<EditorComposite<T>> childPanels, TabFolder tab) {
        Control[] controlArray = tab.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control controlOnTab = controlArray[n2];
            if (controlOnTab instanceof EditorComposite) {
                childPanels.add((EditorComposite)controlOnTab);
            }
            ++n2;
        }
    }

    private void findChildsForGroup(List<EditorComposite<T>> childPanels, Group group) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof TabFolder) {
                this.findChildsForTab(childPanels, (TabFolder)control);
            }
            ++n2;
        }
    }

    @Override
    public void bindValues() {
        super.bindValues();
        for (EditorComposite<T> child : this.getChildPanels()) {
            child.bindValues();
        }
    }

    @Override
    public void updateBind() {
        super.updateBind();
        for (EditorComposite<T> child : this.getChildPanels()) {
            child.updateBind();
        }
    }

    public void dispose() {
        for (EditorComposite<T> child : this.getChildPanels()) {
            child.dispose();
        }
        super.dispose();
    }

    @Override
    public void setModel(T model) {
        super.setModel(model);
        for (EditorComposite<T> child : this.getChildPanels()) {
            child.setModel(model);
        }
    }

    public void applyRights(String selector) {
        log.trace("begin apply rights");
        GuiActivator.getDefault().getBeanByClass(GuiElementController.class).applyRights(((Object)((Object)this)).getClass(), (Object)this, selector);
        log.trace("end apply rights");
    }

    protected void initDefaulBinding() {
        log.trace("init default binding");
        new ReflectionDataBinding(this.getClazz(), this.getModel(), this.getMasterValue(), this.getBindingContext(), this.getValidatorListener()).initDefaulBinding(this);
        log.trace("end default binding");
    }

    protected static String openDialogsForSelectImage(Shell shell) {
        FileDialog fileDialog = new FileDialog(shell);
        fileDialog.setText("Select File");
        fileDialog.setFilterExtensions(new String[]{"*.png", "*.jpg", "*.jpeg"});
        fileDialog.setFilterNames(new String[]{"Image(*.png)", "Image(*.jpg)", "Image(*.jpeg)"});
        String selected = fileDialog.open();
        return selected;
    }
}

