/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.multiChoice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.multiChoice.MultiChoiceDefaultLabelProvider;
import org.mihalis.opal.multiChoice.MultiChoiceLabelProvider;
import org.mihalis.opal.multiChoice.MultiChoiceSelectionListener;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SimpleSelectionAdapter;

public class MultiChoice<T>
extends Composite {
    private Text text;
    private Button arrow;
    private Shell popup;
    private ScrolledComposite scrolledComposite;
    private Listener listener;
    private Listener filter;
    private int numberOfColumns = 2;
    private List<T> elements;
    private Set<T> selection;
    private List<Button> checkboxes;
    private boolean hasFocus;
    private MultiChoiceSelectionListener<T> selectionListener;
    private T lastModified;
    private Color foreground;
    private Color background;
    private Font font;
    private String separator;
    private MultiChoiceLabelProvider labelProvider;
    private int preferredHeightOfPopup;

    public MultiChoice(Composite composite, int n) {
        this(composite, n, null);
    }

    public MultiChoice(Composite composite, int n, List<T> list) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        int n2 = (n & 8) == 8 ? 8 : 0;
        this.text = new Text((Composite)this, 4 | n2 | 0x800);
        this.text.setBackground(this.getDisplay().getSystemColor(25));
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.arrow = new Button((Composite)this, 131076);
        this.arrow.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createGlobalListener();
        this.addListeners();
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == MultiChoice.this.getShell()) {
                    MultiChoice.this.handleFocusEvents(16);
                }
            }
        };
        this.selection = new LinkedHashSet<T>();
        this.elements = list;
        this.separator = ",";
        this.labelProvider = new MultiChoiceDefaultLabelProvider();
        this.createPopup();
        this.setLabel();
    }

    private void createGlobalListener() {
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (MultiChoice.this.popup == event.widget) {
                    MultiChoice.this.handlePopupEvent(event);
                    return;
                }
                if (MultiChoice.this.arrow == event.widget) {
                    MultiChoice.this.handleButtonEvent(event);
                    return;
                }
                if (MultiChoice.this == event.widget) {
                    MultiChoice.this.handleMultiChoiceEvents(event);
                    return;
                }
                if (MultiChoice.this.getShell() == event.widget) {
                    MultiChoice.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (MultiChoice.this.isDisposed()) {
                                return;
                            }
                            MultiChoice.this.handleFocusEvents(16);
                        }
                    });
                }
            }
        };
    }

    private void addListeners() {
        int[] nArray;
        Object object = nArray = new int[]{12, 10, 11};
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            int n2 = object[i];
            this.addListener(n2, this.listener);
        }
        if ((this.getStyle() & 8) == 0) {
            object = new Listener(){

                public void handleEvent(Event event) {
                    if (!MultiChoice.this.popup.isDisposed() && !MultiChoice.this.popup.isVisible()) {
                        MultiChoice.this.validateEntry();
                    }
                }
            };
            this.text.addListener(16, (Listener)object);
        }
        for (int n3 : object = new int[]{13, 15}) {
            this.arrow.addListener(n3, this.listener);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void validateEntry() {
        void var4_7;
        String string = this.text.getText();
        String[] stringArray = string.split(this.separator);
        ArrayList<String> arrayList = new ArrayList<String>();
        this.selection.clear();
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if ("".equals(string3)) continue;
            T t = this.convertEntry(string3);
            if (t == null) {
                arrayList.add(string3);
                continue;
            }
            this.selection.add(t);
        }
        if (arrayList.size() == 0) {
            this.updateSelection();
            return;
        }
        if (arrayList.size() == 1) {
            String string4 = String.format(ResourceManager.getLabel("multichoice.message"), arrayList.get(0));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            String string5 = String.format(ResourceManager.getLabel("multichoice.message.plural"), stringBuilder.toString());
        }
        this.getDisplay().asyncExec(new Runnable((String)var4_7){
            final /* synthetic */ String val$messageToDisplay;
            {
                this.val$messageToDisplay = string;
            }

            @Override
            public void run() {
                MessageBox messageBox = new MessageBox(MultiChoice.this.getShell(), 33);
                messageBox.setMessage(this.val$messageToDisplay);
                messageBox.open();
                MultiChoice.this.text.forceFocus();
            }
        });
    }

    private T convertEntry(String string) {
        for (T t : this.elements) {
            if (!this.labelProvider.getText(t).trim().equals(string)) continue;
            return t;
        }
        return null;
    }

    public void add(T t) {
        this.checkWidget();
        if (t == null) {
            SWT.error((int)4);
        }
        if (this.elements == null) {
            this.elements = new ArrayList<T>();
        }
        this.elements.add(t);
        this.refresh();
    }

    public void add(T t, int n) {
        this.checkWidget();
        this.checkNullElement();
        if (t == null) {
            SWT.error((int)4);
        }
        this.checkRange(n);
        this.elements.add(n, t);
        this.refresh();
    }

    public void addAll(List<T> list) {
        this.checkWidget();
        if (list == null) {
            SWT.error((int)4);
        }
        if (this.elements == null) {
            this.elements = new ArrayList<T>();
        }
        this.elements.addAll(list);
        this.refresh();
    }

    public void addAll(T[] TArray) {
        this.checkWidget();
        if (TArray == null) {
            SWT.error((int)4);
        }
        if (this.elements == null) {
            this.elements = new ArrayList<T>();
        }
        for (T t : TArray) {
            this.elements.add(t);
        }
        this.refresh();
    }

    public T getItem(int n) {
        this.checkWidget();
        this.checkNullElement();
        this.checkRange(n);
        return this.elements.get(n);
    }

    public int getItemCount() {
        this.checkWidget();
        if (this.elements == null) {
            return 0;
        }
        return this.elements.size();
    }

    public List<T> getItems() {
        this.checkWidget();
        if (this.elements == null) {
            return null;
        }
        return new ArrayList<T>(this.elements);
    }

    public void removeAt(int n) {
        this.checkWidget();
        this.checkNullElement();
        this.checkRange(n);
        T t = this.elements.remove(n);
        this.selection.remove(t);
        this.refresh();
    }

    public void remove(T t) {
        if (t == null) {
            SWT.error((int)4);
        }
        this.checkWidget();
        this.checkNullElement();
        this.elements.remove(t);
        this.selection.remove(t);
        this.refresh();
    }

    public void removeAll() {
        this.checkWidget();
        this.checkNullElement();
        if (this.elements != null) {
            this.elements.clear();
        }
        this.selection.clear();
        this.refresh();
    }

    public void setLabelProvider(MultiChoiceLabelProvider multiChoiceLabelProvider) {
        this.labelProvider = multiChoiceLabelProvider;
    }

    public void setSelection(Set<T> set) {
        this.checkWidget();
        this.checkNullElement();
        if (set == null) {
            SWT.error((int)4);
        }
        this.selection = set;
        this.updateSelection();
    }

    public void selectAll() {
        this.checkWidget();
        this.checkNullElement();
        this.selection.addAll(this.elements);
        this.updateSelection();
    }

    public void selectAt(int n) {
        this.checkWidget();
        this.checkNullElement();
        this.checkRange(n);
        this.selection.add(this.elements.get(n));
        this.updateSelection();
    }

    public void select(T t) {
        this.checkWidget();
        this.checkNullElement();
        if (!this.elements.contains(t)) {
            throw new IllegalArgumentException("Value not present in the widget");
        }
        this.selection.add(t);
        this.updateSelection();
    }

    public void setSelectedIndex(int[] nArray) {
        this.checkWidget();
        this.checkNullElement();
        for (int n : nArray) {
            this.checkRange(n);
            this.selection.add(this.elements.get(n));
        }
        this.updateSelection();
    }

    public int[] getSelectedIndex() {
        this.checkWidget();
        this.checkNullElement();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!this.selection.contains(this.elements.get(i))) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public List<T> getSelection() {
        this.checkWidget();
        this.checkNullElement();
        return new ArrayList<T>(this.selection);
    }

    public void deselectAt(int n) {
        this.checkWidget();
        this.checkNullElement();
        if (n < 0 || n >= this.elements.size()) {
            SWT.error((int)6);
        }
        this.selection.remove(n);
        this.updateSelection();
    }

    public void deselect(T t) {
        this.checkWidget();
        this.checkNullElement();
        this.selection.remove(t);
        this.updateSelection();
    }

    public void deselectAll() {
        this.checkWidget();
        this.checkNullElement();
        this.selection.clear();
        this.updateSelection();
    }

    public int getNumberOfColumns() {
        this.checkWidget();
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int n) {
        this.checkWidget();
        this.numberOfColumns = n;
        this.popup.dispose();
        this.popup = null;
        this.createPopup();
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void refresh() {
        this.checkWidget();
        this.popup.dispose();
        this.popup = null;
        this.createPopup();
        this.updateSelection();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        GC gC = new GC((Drawable)this.text);
        int n5 = gC.stringExtent((String)" ").x;
        int n6 = gC.stringExtent((String)this.text.getText()).x;
        gC.dispose();
        Point point = this.text.computeSize(-1, -1, bl);
        Point point2 = this.arrow.computeSize(-1, -1, bl);
        int n7 = this.getBorderWidth();
        n4 = Math.max(point.y, point2.y);
        n3 = n6 + 2 * n5 + point2.x + 2 * n7;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3 + 2 * n7, n4 + 2 * n7);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.arrow.setEnabled(bl);
        this.text.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.text.setToolTipText(string);
    }

    public SelectionListener getSelectionListener() {
        this.checkWidget();
        return this.selectionListener;
    }

    public void setSelectionListener(MultiChoiceSelectionListener<T> multiChoiceSelectionListener) {
        this.checkWidget();
        this.selectionListener = multiChoiceSelectionListener;
        this.refresh();
    }

    public void updateSelection() {
        this.checkWidget();
        if (this.isDisposed()) {
            return;
        }
        if (this.popup == null || this.popup.isDisposed() || this.checkboxes == null) {
            return;
        }
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            Button button = this.checkboxes.get(i);
            if (button.isDisposed()) continue;
            Object object = button.getData();
            button.setSelection(this.selection.contains(object));
        }
        this.setLabel();
    }

    T getLastModified() {
        return this.lastModified;
    }

    Shell getPopup() {
        return this.popup;
    }

    private void createPopup() {
        int[] nArray;
        this.popup = new Shell(this.getShell(), 16392);
        this.popup.setLayout((Layout)new FillLayout());
        for (int button : nArray = new int[]{21, 27, 12}) {
            this.popup.addListener(button, this.listener);
        }
        if (this.elements == null) {
            return;
        }
        this.scrolledComposite = new ScrolledComposite((Composite)this.popup, 2560);
        Composite composite = new Composite((Composite)this.scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout(this.numberOfColumns, true));
        this.checkboxes = new ArrayList<Button>(this.elements.size());
        for (final T t : this.elements) {
            final Button button = new Button(composite, 32);
            if (this.font != null) {
                button.setFont(this.font);
            }
            if (this.foreground != null) {
                button.setForeground(this.foreground);
            }
            if (this.background != null) {
                button.setBackground(this.background);
            }
            button.setData(t);
            button.setLayoutData((Object)new GridData(1, 2, false, false));
            button.setText(this.labelProvider.getText(t));
            button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

                @Override
                public void handle(SelectionEvent selectionEvent) {
                    if (button.getSelection()) {
                        MultiChoice.this.selection.add(t);
                    } else {
                        MultiChoice.this.selection.remove(t);
                    }
                    MultiChoice.this.lastModified = t;
                    MultiChoice.this.setLabel();
                }
            });
            if (this.selectionListener != null) {
                button.addSelectionListener(this.selectionListener);
            }
            button.setSelection(this.selection.contains(t));
            this.checkboxes.add(button);
        }
        this.scrolledComposite.setContent((Control)composite);
        this.scrolledComposite.setExpandHorizontal(false);
        this.scrolledComposite.setExpandVertical(true);
        composite.pack();
        this.preferredHeightOfPopup = composite.getSize().y;
    }

    private void setLabel() {
        if (this.checkboxes == null) {
            this.text.setText("");
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Button object2 : this.checkboxes) {
            if (!object2.getSelection()) continue;
            arrayList.add(object2.getText());
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(this.separator);
        }
        this.text.setText(stringBuilder.toString());
    }

    private void handleFocusEvents(int n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(15, event);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control control = this.getDisplay().getFocusControl();
                if (control == this.arrow) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(16, event);
                break;
            }
        }
    }

    private void handleMultiChoiceEvents(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.changeVisibilityOfPopupWindow(false);
                break;
            }
            case 11: {
                if (!this.isDropped()) break;
                this.changeVisibilityOfPopupWindow(false);
            }
        }
    }

    private void handleButtonEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocusEvents(15);
                break;
            }
            case 13: {
                this.changeVisibilityOfPopupWindow(!this.isDropped());
            }
        }
    }

    private boolean isDropped() {
        return !this.popup.isDisposed() && this.popup.getVisible();
    }

    private void handlePopupEvent(Event event) {
        switch (event.type) {
            case 21: {
                event.doit = false;
                this.changeVisibilityOfPopupWindow(false);
                break;
            }
            case 27: {
                this.changeVisibilityOfPopupWindow(false);
                break;
            }
            case 12: {
                if (this.checkboxes != null) {
                    this.checkboxes.clear();
                }
                this.checkboxes = null;
            }
        }
    }

    private void changeVisibilityOfPopupWindow(boolean bl) {
        if (bl == this.isDropped()) {
            return;
        }
        if (!bl) {
            this.popup.setVisible(false);
            if (!this.isDisposed()) {
                this.text.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            this.popup.dispose();
            this.popup = null;
            this.createPopup();
        }
        Point point = this.arrow.toDisplay(this.arrow.getSize().x - 5, this.arrow.getSize().y + this.arrow.getBorderWidth() - 3);
        int n = point.x;
        int n2 = point.y;
        Rectangle rectangle = this.getMonitor().getClientArea();
        Rectangle rectangle2 = this.getDisplay().map((Control)this.getParent(), null, this.getBounds());
        this.popup.pack();
        int n3 = this.popup.getBounds().width;
        int n4 = 2 * rectangle.height / 3;
        int n5 = this.popup.getBounds().height;
        if (n5 > n4) {
            n5 = n4;
            this.popup.setSize(n3, n5);
            this.scrolledComposite.setMinHeight(this.preferredHeightOfPopup);
            this.popup.layout(true);
        }
        if (n2 + n5 > rectangle.y + rectangle.height && (n2 = rectangle2.y - n5) < 0) {
            n5 += n2;
            n2 = rectangle2.y - n5 + 5;
            this.popup.setSize(n3, n5);
            this.scrolledComposite.setMinHeight(this.preferredHeightOfPopup);
            this.popup.layout(true);
        }
        if (n + n3 > rectangle.x + rectangle.width) {
            n = rectangle.x + rectangle.width - n3;
        }
        this.popup.setLocation(n, n2);
        this.popup.setVisible(true);
        this.popup.setFocus();
    }

    private void checkNullElement() {
        if (this.elements == null) {
            throw new NullPointerException("There is no element associated to this widget");
        }
    }

    private void checkRange(int n) throws NullPointerException {
        this.checkNullElement();
        if (n < 0 || n >= this.elements.size()) {
            SWT.error((int)6);
        }
    }
}

